<?php
/**
	* "Old School" posts by category widget
	*
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<?php
if ( is_single() &&	has_category() ) : 
	$oldschool_categories = get_the_category( $post->ID );
	if ( $oldschool_categories ) :
		$oldschool_category_ids = array();
		foreach ( $oldschool_categories as $oldschool_individual_category ) 
			$oldschool_category_ids[] = $oldschool_individual_category->term_id;
			$oldschool_args = array(
				'category__in' => $oldschool_category_ids,
				'post__not_in' => array( $post->ID ),
				'showposts' => 5,
				'orderby' => 'rand',
				'order' => 'ASC',
				'ignore_sticky_posts' => 1,
			);
			$oldschool_my_query = new wp_query( $oldschool_args );
			if ( $oldschool_my_query->have_posts() ) :
				?>
				<div class="post-widgets__posts-by-category">
					<div class="posts-by-category__title">
						<h3 class="posts-title__h3">
							<?php esc_html_e( 'You will also like', 'oldschool' ); ?>
						</h3>
					</div>
					<div class="posts-by-category__content">
						<div class="content-block__list">
							<?php
							while ( $oldschool_my_query->have_posts() ) :
								$oldschool_my_query->the_post();
								?>
							<div class="post-list__item">
								<a class="post-list__link" href="<?php the_permalink(); ?>" rel="nofollow">

									<div class="post-list__content-block">
										<div class="content-block__thumbnail">
											<div class="post-thumbnail__block">
												<?php
												if ( has_post_thumbnail() ) {
													the_post_thumbnail(
														'thumbnail',
														array(
															'class' => 'widget-posts-by-category__img',
															'alt'   => get_the_title(),
															'title' => get_the_title(),
														)
													);
												} else {
													/* if the post does not have thumbnail, then the slider will display a special block with the background icon */
													?>
													<div class="post-image__svg-post-thumbnail">
														<div class="svg-background-icon"></div>
													</div>
												<?php } ?>
											</div>
										</div>

										<div class="content-block__content-grid">
											<div class="content-grid__list">
												<div class="post-item-content__title">
													<div class="post-title__link">
														<h3 class="post-title-link__headline">
															<?php the_title(); ?>
														</h3>
													</div>
												</div>
												<div class="post-item-content__meta-menu">
													<ul class="meta-menu-posts-block__list">
														<li class="posts-by-cat-meta-list__views">
															<div class="posts-meta-views__svg-icon">
																<div class="eye-icon"></div>
															</div>
														</li>
														<li class="posts-by-cat-meta-list__comments">
															<?php	oldschool_comments_counter_nav(); ?>
														</li>
													</ul>
												</div>
											</div>
										</div>		
									</div>
								</a>							
							</div> <!-- post-list__item -->
							<?php endwhile; ?>
						</div> <!-- content-block__list -->
					</div>
				</div>
				<?php endif; ?>
				<?php wp_reset_query(); ?>
				<?php endif; ?>
				<?php endif; ?>
