<?php
/**
	* "Old School" article thumbnail template. This template show structure of article thumbnail block.
	*
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="article__article-top-thumbnail">
	<?php
	oldschool_post_img_sizes_category_block();
	// Page thumbnail
	if ( has_post_thumbnail() ) :
		$oldschool_article_img_data = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		if ( $oldschool_article_img_data ) {
			$oldschool_article_img_width = $oldschool_article_img_data[1]; // thumbnail's width
			$oldschool_article_img_height = $oldschool_article_img_data[2]; // thumbnail's height
		}
		$oldschool_article_img_full_size = 600; //not-full-thumbnail's width
		$oldschool_article_img_medium_size = 300; //medium-thumbnail's width
		$oldschool_article_img_class = '';
		//set class to postthumbnai, if it has different sizes
		if ( $oldschool_article_img_width >= $oldschool_article_img_full_size ) {
			$oldschool_article_img_class = 'post-thumbnail__img-thumbnail-size-full';
		} else if (
			( $oldschool_article_img_width <= $oldschool_article_img_full_size ) &&
			( $oldschool_article_img_width >= $oldschool_article_img_medium_size )
		) {
			$oldschool_article_img_class = 'post-thumbnail__img-thumbnail-size-medium';
		} else if (
			( $oldschool_article_img_width < $oldschool_article_img_medium_size ) ||
			( $oldschool_article_img_height < $oldschool_article_img_medium_size )
		) {
			$oldschool_article_img_class = 'post-thumbnail__img-thumbnail-size-small';
		}

		// post image output

		// if desktop
		if ( !wp_is_mobile() ) {
			$oldschool_page_thumbnail = the_post_thumbnail(
				'medium-large',
				array(
					'class' => $oldschool_article_img_class,
					'alt'   => get_the_title(),
					'title' => get_the_title(),
				)
			);

		// if smartphone or mobile or tablet	
		} else {
			$oldschool_page_thumbnail = the_post_thumbnail(
				'medium',
				array(
					'class' => $oldschool_article_img_class,
					'alt'   => get_the_title(),
					'title' => get_the_title(),
				)
			);
		}	
		else :
			if ( ! has_post_thumbnail() || ! is_front_page() ) {
				?>
				<!--if post has no thumbnail-->
				<div class="post-thumbnail__svg-background-icon">
					<div class="svg-background-icon"></div>
				</div>
	<?php } ?>
	<?php endif; ?>
	<?php
		/** if mobile resolution and img has full size,
			* a block with categories is attached to this block.
			*/
	if (
			( has_post_thumbnail() ) &&
			( $oldschool_article_img_width > $oldschool_article_img_full_size )
		) :
		?>
			<div class="post-thumbnail__mobile-category-psition"></div>
		<?php endif; ?>
		<?php
		/*
			* Activates another meta navigation section if post thumbnail
			* has medium or small sizes or not exist.
			*/
		if (
			( ! has_post_thumbnail() ) ||
			( ( has_post_thumbnail() ) &&
			( $oldschool_article_img_width < $oldschool_article_img_full_size ) &&
			( $oldschool_article_img_width >= $oldschool_article_img_medium_size ) ||
			( $oldschool_article_img_width < $oldschool_article_img_medium_size ) )
		) {
			?>
			<div class="meta-block-not-full-width-img">
				<?php get_template_part( 'template-parts/page/post-meta-navigation' ); ?>
			</div>
	<?php } ?>
</div>

