<?php
/**
	* This template display a grid of posts on the main page, the search results page and on the archives page.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<?php get_header(); ?>
<div class="site-layer__middle">
	<div class="content-block__site-content <?php oldschool_content_size(); ?>">
		<main class="main-block__main-content-grid">
			<?php
			if (
				( is_home() ) &&
				get_theme_mod( 'featured_display', 'true' ) == true ) :
				get_template_part( 'template-parts/automatron-slider/automatron', 'slider' );
			endif;
			?>
			<div id="content" tabindex="-1"
				class="content-block-part__site-content-grid <?php oldschool_loop_types(); ?>">
				<?php
				if ( have_posts() ) :

					// Load posts loop
					while ( have_posts() ) :
						the_post();
						?>
							<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<a class="news-block__image-link" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"></a>
								<?php if ( has_category() ) : ?>
									<div class="post-text__page-category-mobile"></div>
								<?php endif; ?>
										<div class="post__article-post-grid">
											<div class="article-post-grid__news-block">												
														<div class="news-block__dark-background-hover"></div>
														<div class="news-block__image">
															<div class="news-block__post-image">
																<?php
																if ( has_post_thumbnail() ) {
																	if ( !wp_is_mobile() ) {
																		set_post_thumbnail_size( 500, 500, array( 'center', 'center' ) );
																	} else {
																		set_post_thumbnail_size( 350, 350, array( 'center', 'center' ) );
																	}	
																	the_post_thumbnail();
																} else {
																	/* if the post does not have thumbnail, then the slider will display a special block with the background icon */
																	?>
																	<div class="post-image__svg-post-thumbnail">
																		<div class="svg-background-icon"></div>
																	</div>
																<?php } ?>
															</div>
														</div>
														<div class="news-block__meta">
															<ul class="news-block__meta-list">
																<li class="post-meta-list__post-comments">
																	<?php oldschool_comments_counter_nav(); ?>
																</li>
															</ul>
														</div>
												</a>
											</div>
						<div class="site-last-content__post-text">
							<?php if ( has_category() ) : ?>
								<div class="post-text__page-category">
									<div class="loop-page-category__links">
										<div class="loop__tag-icon">
											<div class="flag-icon"></div>
											<div class="flag-triangle-bottom-icon"></div>
										</div>
										<?php the_category( ', ' ); ?>
									</div>
								</div>
							<?php endif; ?>
							
							<div class="post-text__title">
								<h2 class="post-title__h2-headline">
									<?php the_title(); ?>
								</h2>
							</div>

							<?php if ( '' !== get_post()->post_content ) : ?>
								<div class="post-text__description">
									<?php the_excerpt( '<span class="moretext">...</span>' ); ?>
								</div>
							<?php endif; ?>
							<div class="post-text__list-meta"></div>
						</div>
					</div>
							</article>
				<?php endwhile; ?>
				<?php else : ?>
				<h2 class="search-result">
					<?php esc_html_e( 'Sorry, no posts matched your criteria.', 'oldschool' ); ?>
				</h2>
				<?php endif; ?>
			</div>
		</main>
	</div>
	<?php get_sidebar(); ?>
</div>
<div class="page-navigation__list">
	<?php echo wp_kses_post( paginate_links() ); ?>
</div>
<?php
	get_footer();

