<?php
/**
	*  This template display header block of social networks and search.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="header-top__social">	
	<div class="header-social__block">
		<!--
		This block ( header-social-content__social-block ) is needed because
		social network icons appear in it, or
		if the "Old School" plugin of the contact form is activated,
		an email icon will appear.
		-->
		<div class="header-social-content__social-block">
			<?php
			// if social links activated, then create block with social icons
			if (
				( get_theme_mod( 'oldschool_social_link_activate', 'disable' ) == 'enable' ) &&
				( ( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'header' ) ||
				( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'both' ) )
			) :
				?>
			<ul class="header-social-icons__list">
				<?php oldschool_social_icons(); ?>
			</ul>
		<?php endif; ?>
		</div>

		<!-- site header search form -->
		<div class="header-social-content__search">
			<?php get_search_form(); ?>
		</div>

	</div>
</div>
