<?php
/**
	*  This template display header block with a logo and description of the site.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="header-top__main">
	<div class="header-main__block">

		<?php
		// if site logo or site title exist, then block with logo and title will be exist
		if ( has_custom_logo() || ( ! empty( get_bloginfo( 'name' ) ) ) ) :
			?>
			<div class="header-desktop-block__logo">
				<div class="header-main-content__logo">
					<?php
					// if logo exist
					if ( has_custom_logo() ) :
						?>
						<div class="site-logo"><?php the_custom_logo(); ?></div>
					<?php endif; ?>
					<?php $oldschool_site_info = get_bloginfo( 'name' ); ?>
					<?php if ( ! empty( $oldschool_site_info ) ) : ?>
						<?php if ( is_home() || is_front_page() ) : ?>
							<h1 class="header-oldschool-logo__title" title="<?php bloginfo( 'name' ); ?>">
								<a class="header-logo__link" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
									<?php bloginfo( 'name' ); ?>
								</a>
							</h1>
						<?php else : ?>
							<h2 class="header-oldschool-logo__title" title="<?php bloginfo( 'name' ); ?>">
								<a class="header-logo__link" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
									<?php bloginfo( 'name' ); ?>
								</a>
							</h2>
						<?php endif; ?>
					<?php endif; ?>
				</div>

			</div>
		<?php endif; ?>

		<?php
			$oldschool_site_description = get_bloginfo( 'description', 'display' );
		if ( $oldschool_site_description || is_customize_preview() ) :
			?>
			<div class="header-desktop-block__description">
				<div class="header-main-content__site-description">
					<?php bloginfo( 'description', 'display' ); ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>
