<?php
/**
	* This template show footer block with widgets.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
/**
	* if at least one of the blocks with widgets is enabled,
	* then the footer middle block with widgets will appear
	*/
if (
	is_active_sidebar( 'oldschool-sidebar-3' ) ||
	is_active_sidebar( 'oldschool-sidebar-4' ) ||
	is_active_sidebar( 'oldschool-sidebar-5' ) ||
	is_active_sidebar( 'oldschool-sidebar-6' )
) :
	?>
	<div class="footer-part__middle">
		<div class="footer-middle-block__footer-widgets">
			<!-- first block of widgets -->
			<div class="widgets-footer__widget-column">
				<?php if ( is_active_sidebar( 'oldschool-sidebar-3' ) ) : ?>
					<div class="widget-block-column__widget-area-1">
						<?php dynamic_sidebar( 'oldschool-sidebar-3' ); ?>
					</div>			
				<?php endif; ?>	
			</div>

			<!-- second block of widgets -->
			<div class="widgets-footer__widget-column">
				<?php if ( is_active_sidebar( 'oldschool-sidebar-4' ) ) : ?>
					<div class="widget-block-column__widget-area-2">
						<?php dynamic_sidebar( 'oldschool-sidebar-4' ); ?>
					</div>
				<?php endif; ?>
			</div>

			<!-- third block of widgets -->
			<div class="widgets-footer__widget-column">
				<?php if ( is_active_sidebar( 'oldschool-sidebar-5' ) ) : ?>
					<div class="widget-block-column__widget-area-3">
						<?php dynamic_sidebar( 'oldschool-sidebar-5' ); ?>
					</div>
				<?php endif; ?>
			</div>

			<!-- fourth block of widgets -->
			<div class="widgets-footer__widget-column">
				<?php if ( is_active_sidebar( 'oldschool-sidebar-6' ) ) : ?>
					<div class="widget-block-column__widget-area-4">
						<?php dynamic_sidebar( 'oldschool-sidebar-6' ); ?>
					</div>
				<?php endif; ?>
			</div>

		</div>
	</div>
<?php endif; ?>
