https://kino.mail.ru/series/selection/416_russkie_sherloki_25_serialov_pro_neobichnih_detektivov/?from=mr_news&exp_id=933


/* "Old School" frontend functions
 * 
 *  This file contains all theme functions that are performed on the client side 
 *  (exclusively in the browser) and affect only certain theme elements: 
 *  mobile menu;  
 *  change in the location of elements at different screen resolutions;
 *  and much more. 
 * 
 * */

/*globals jQuery, SwipeIt, Symbol */

/* "Old School" frontend functions
 * 
 *  This file contains all theme functions that are performed on the client side 
 *  (exclusively in the browser) and affect only certain theme elements: 
 *  mobile menu;  
 *  change in the location of elements at different screen resolutions;
 *  and much more. 
 * 
 * */

/* globals jQuery */

function C(name) {
  this.n = name;
  this.lnk = document.getElementsByClassName(this.n)[0];
  this.lnk2 = document.getElementsByClassName(this.n);
}

(function () {
  "use strict";
  /* 
   * Scroll-bar color change when scrolling the page
   */

  function progressBarColor() {
    let mpf = new C("nav--fixed").lnk;
    let pc = new C("prgrss-blck").lnk;
    let pcb = new C("prgrss__bar").lnk;
    let u = undefined;

    if (mpf === u) {
      return;
    }
    if (pc) {
      pc.style.backgroundColor = "transparent";
      pcb.style.backgroundColor = "#e40806";
    } else {
      if (pc) {
        pc.style.backgroundColor = "#000";
        pcb.style.backgroundColor = "#fff";
      }
    }
  }
  progressBarColor();
})();

(function () {
  "use strict";
  /*
   * Change the category title position if desktop or mobile  
   */

  function changeCategoryPosition(mobileCategories) {
    let cpb = new C("page-category__block").lnk;
    let mcs = new C("post-thumbnail__mobile-category-position").lnk;
    let dcs = new C("page-content-block__page-category").lnk;

    // if screen resolution is less then 1023px
    if (mobileCategories.matches) {
      if (cpb && mcs && dcs) {
        mcs.appendChild(cpb);
      }
      // if screen resolution is higher then 1023px
    } else if (cpb && mcs && dcs) {
      dcs.appendChild(cpb);
    } else {
      return;
    }
  }

  // screen resolution function
  let x = window.matchMedia("(max-width: 1023px)");
  changeCategoryPosition(x);
  x.addListener(changeCategoryPosition);
})();


(function () {
  /*
   * if the page ( article or post ) has a YouTube video, the video will turn 
   * into html block code ( div class="oldschool-video-container" ), 
   * for more convenient display not only on the desktop, but also in the mobile version of the site
   */


  function createYouTubeBlock() {
    'use strict';
    // if youtube video doesn's exist on the page
    // 
    let yi = document.querySelector('iframe');
    let yb = document.createElement('div');
    let n = null;
    let u = undefined;

    if (yi !== (u || n)) {
      yb.className = "oldschool-video-container";
      yi.parentNode.insertBefore(yb, yi);
      yb.appendChild(yi);
    }
  }
  createYouTubeBlock();
})();


(function () {
  "use strict";
  /*
   * Change the category links position if screen resolution
   * is less then 800px in: main, archive or search result pages 
   */



  function changeLoopCategoriesPosition(screenMobileResolution) {
    let lcd = new C("post-text__page-category").lnk2;
    let lcm = new C("post-text__page-category-mobile").lnk2;
    let lcl = new C("loop-page-category__links").lnk2;

    // if screen resolution is less then 800px
    if (screenMobileResolution.matches) {

      /* get all cagerories links from every articles blocks
       * and put them to mobile category blocks, 
       * which exist for each block
       */
      for (let i = 0; i < lcm.length; i++) {
        lcm[i].appendChild(lcl[i]);
      }
      // if screen resolution is higher then 800px  
    } else {
      for (let j = 0; j < lcm.length; j++) {
        lcd[j].appendChild(lcl[j]);
      }
    }
  }

  // screen resolution function
  let mobileScreenResolution = window.matchMedia("(max-width: 800px)");
  changeLoopCategoriesPosition(mobileScreenResolution);
  mobileScreenResolution.addListener(changeLoopCategoriesPosition);
})();


(function () {
  "use strict";
  /* Fixed Menu and progress container */
  let n = null;
  let u = undefined;
  let rmf = new C("nav--fixed").lnk;
  let hm = new C("header-bottom__navigation").lnk;
  let hmp = new C("header__bottom").lnk;
  let pb = new C("prgrss-blck").lnk;
  let pls = new C("prgrss__bar").lnk;

  /* Progress Container */
  function getRedline() {

    let currScrollTop = document.body.scrollTop || document.documentElement.scrollTop;
    let height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
    let scrolled = (currScrollTop / height) * 100;
    pls.style.width = scrolled + "%";
  }

  window.addEventListener('scroll', getRedline);

  let menuOnScroll = function () {

    let prevScrollTop = 0,
      liftUp = 0,
      liftDown = 0,
      step = 1;

    return function () {

      let currScrollTop = document.body.scrollTop || document.documentElement.scrollTop;

      if (currScrollTop > 200) {
        if (liftDown > step) {
          // If Menu Fixed
          if (rmf !== u) {
            rmf.appendChild(hm);
            hmp.style.minHeight = "36px";
            hm.style.marginTop = '0px';
            pb.style.background = '#000';
            pls.style.background = '#fff';
          }
        }
      } else if (liftUp > step) {
        if (rmf !== u) {
          hmp.appendChild(hm);
          hm.style.marginTop = '';
          pb.style.background = 'transparent';
        }
      } else if (currScrollTop < 200) {
        if (liftDown < step) {
          if (rmf !== u) {
            hmp.appendChild(hm);
            hmp.style.height = "auto";
            hm.style.marginTop = '';
            pb.style.background = 'transparent';
          }
        }
      }

      if ((prevScrollTop - currScrollTop) > 0) {
        liftUp++;
        liftDown = 0;
      } else {
        liftDown++;
        liftUp = 0;
      }
      prevScrollTop = currScrollTop;
    };
  }();

  function menuOnMatchMedia(menuMatchMedia) {
    'use strict';

    if (menuMatchMedia.matches) {
      // if screen resolution is higher than 1023px
      window.addEventListener('scroll', menuOnScroll);
    } else {
      // if screen resolution is less than 1023px
      window.removeEventListener('scroll', menuOnScroll);
      pls.style.background = '#e40806';
    }
  }

  // screen resolution function 
  let menuMatchMedia = window.matchMedia("(min-width: 1023px)");
  menuMatchMedia.addListener(menuOnMatchMedia);
  menuOnMatchMedia(menuMatchMedia);
})();


(function () {
  'use strict';
  /*
   * "Back to top button" function
   * 
   */


  document.addEventListener("DOMContentLoaded", function () {
    let anchorToTop = document.querySelector('.back-to-top__button'),
      offset = 280, // browser window scroll (in pixels) after which the "back to top" link is shown
      scrollDuration = 300;

    function scrollToTop(duration) {
      let start = window.pageYOffset,
        startTime = Math.floor(Date.now());

      function scroll() {
        Math.easeInOutQuad = function (t) {
          return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
        };

        let time = Math.min(1, ((Math.floor(Date.now()) - startTime) / duration));
        window.scroll(0, Math.ceil((Math.easeInOutQuad(time) * (0 - start)) + start));

        if (window.pageYOffset === 0) {
          return;
        }

        requestAnimationFrame(scroll);
      } //scroll();
      scroll();
    } //scrollToTop()

    function scrollingDown() {
      if (document.body.scrollTop > offset || document.documentElement.scrollTop > offset) {
        anchorToTop.removeAttribute("style", "transform: translateX(120px);");
        anchorToTop.setAttribute("style", "transform: translateX(0);");
      } else {
        anchorToTop.removeAttribute("style", "transform: translateX(0);");
        anchorToTop.setAttribute("style", "transform: translateX(120px);");
      }
    } //scrollingDown()

    // if user was clicked on button, then the function takes it to the top of the page.
    anchorToTop.addEventListener('click', function () {
      if (!window.requestAnimationFrame) {
        window.scrollTo(0, 0);
      } else {
        scrollToTop(scrollDuration);
      }
    }); //anchorToTop()
    window.addEventListener('scroll', scrollingDown);
  });
})();



(function () {
  /*
   * Change the posts loop meta menu position 
   */

  let u = undefined;
  let n = null;

  function loopMetaMenuPosition() {
    'use strict';
    let col = new C("loop-type__columns").lnk;
    let lst = new C("loop-type__list").lnk;
    let cmm = document.getElementsByClassName('news-block__meta');
    let lmm = document.getElementsByClassName('post-text__list-meta');
    let mm = document.getElementsByClassName('news-block__meta-list');

    function changeMetaMenuPosition(mobileResolution) {
      'use strict';
      if (lst !== u) {
        for (let i = 0; i < mm.length; i++) {
          if (mobileResolution.matches) {
            cmm[i].appendChild(mm[i]);
          } else if (!mobileResolution.matches) {
            lmm[i].appendChild(mm[i]);
          }
        }
      } else if (col !== u) {
        for (let j = 0; j < mm.length; j++) {
          if (mobileResolution.matches) {
            cmm[j].appendChild(mm[j]);
          } else if (!mobileResolution.matches) {
            cmm[j].appendChild(mm[j]);
          }
        }
      }
    }

    let x = window.matchMedia("(max-width: 800px)");
    changeMetaMenuPosition(x);
    x.addListener(changeMetaMenuPosition);
  }
  loopMetaMenuPosition();
})();


(function () {
  /*
   * Footer top block options
   * 
   * This function sets the behavior of the blocks in the top menu of the footer. 
   *
   */
  function oldschoolFooterTopBlockOptions() {
    'use strict';

    let fl = new C("footer-top-block__footer-site-information").lnk;
    let ftm = new C("footer-top-block__navigation").lnk;
    let ftsi = new C("footer-widgets__social-icons").lnk;
    let u = undefined;
    let n = null;

    if (((fl && ftm) === u) && ftsi !== u) {
      ftsi.className += " footer-soc-width";
    } else if ((ftm !== u && ftsi === u) || (((fl && ftsi) === u) && ftm !== u) || (fl === u && ((ftm && ftsi) !== u))) {
      ftm.className += " footer-nav--width";
    } else {
      return;
    }
  }
  oldschoolFooterTopBlockOptions();
})();


(function () {
  /**
   * MOBILE MENU FUNCTIONS 
   */

  let u = undefined;
  let n = null;
  let sil = new C("header-social-icons__list").lnk;
  let sibd = new C("header-social-content__social-block").lnk;
  let st = new C("header-main-content__logo").lnk;
  let stdb = new C("header-desktop-block__logo").lnk;
  let mldb = new C("header-meta__block").lnk;
  let mlmp = new C("mobile-meta-nav__point").lnk;
  let dhmp = new C("header__bottom").lnk;
  let mhmp = new C("mobile-nav-show-item__main-nav").lnk;
  let hbn = new C("header-bottom__navigation").lnk; 
  let sibm = new C("mobile-nav-content-show__social").lnk;
  let mll = new C("header-meta-block__list").lnk;
  let stmb = new C("header-mobile-block__logo").lnk;
  let mno = new C("header-block__mobile-nav-content").lnk;

  /* ----- 01 ----- */
  function changeHeaderElements(xxx) {
    /**
     * Change header elements positions while resize from desktop to mobile  
     */

    // if screen resolution is higher then 1023px 
    if (xxx.matches) {
      // change site title position if mobile 
      if ((stdb || st) !== u ) { 
        stdb.appendChild(st);
      }
      // if social icons do not exist 
      if (sil !== u) {
        sibd.appendChild(sil);
      }
      mll.className = "header-meta-block__list";
      mldb.appendChild(mll);
      // if header red menu exist
      if (hbn !== u) {
        hbn.className = "header-bottom__navigation";
        document.body.style.overflow = "visible";
        dhmp.appendChild(hbn);
        // if header red menu do not exist
      } else {
        return;
      }
      // if screen resolution is higher then 1023px   
    } else {
      if (st !== u) {
        stmb.appendChild(st);
      }
      // if mobile navigation content exist if desktop
      if (mno.style.display === "block") {
        document.body.style.overflow = "hidden";
        mnb.style.position = "fixed";
      }
      if ((sibm !== u) || (sil !== u)) {
        sibm.appendChild(sil);
      }
      mll.className += " meta--show";
      mlmp.appendChild(mll);
      // if desktop, change red menu position
      if (hbn !== u) {
        hbn.className = "mobile-navigation-show";
        mhmp.appendChild(hbn);
      }
    }
  }
  // screen resolution function 
  let xxx = window.matchMedia("( min-width: 1023px )");
  changeHeaderElements(xxx);
  xxx.addListener(changeHeaderElements);

})();


( function() {

  let mnbi = new C("nav-bar-mobile__icon").lnk;
  
  function getResponsiveNavBar() {
    /* ----- 02 ----- */
    /**
     * Open a mobile menu with content: 
     * meta menu: login, registration; search form and, if the plug-in with the "Old School" contact form is activated, the button "write a letter to the administrator"; 
     * header menu - the red menu if the desktop,
     * social network icons - the red block at the bottom of the screen
     */
    let u = undefined;
    let n = null;
    let getHtml = document.querySelector('html');
    let mmb = new C("meta-tab").lnk;
    let mmst1 = new C("top-nav-item__tab-1").lnk;
    let mmst3 = new C("top-nav-item__tab-3").lnk;
    let mno = new C("header-block__mobile-nav-content").lnk;
    let mhi = new C("hamburger-icon-button__icon").lnk;
    let mll = new C("header-meta-block__list").lnk;
    let sibm = new C("mobile-nav-content-show__social").lnk;
    let si = new C("social-icons-list__item").lnk2;
    let mnbp = new C("mobile-nav-content-show__list").lnk;

    // if hamburger icon was clicked, then shows mobile content menu
    if (mnbi.className === "nav-bar-mobile__icon") {
      mnbi.className = "nav-bar-mobile__icon--pressed";
      getHtml.style.scrollBehavior = "unset";
      getHtml.style.overflowY = "unset";
      mno.style.display = "block";
      document.body.style.overflow = "hidden";
      mhi.className += " button--pressed";
      mll.style.visibility = "visible";
      // timeout for first block with tabs
      setTimeout(function () {
        mmst1.style.left = "0";
        mmst1.style.transition = ".2s";
        mmst3.style.right = "0";
        mmst3.style.transition = ".2s";
      }, 200);
      // timeout for second block
      setTimeout(function () {
        mnbp.style.top = "0px";
      }, 50);
      // timeout for third block with social icons
      setTimeout(function () {
        // If block with social icons empty
        if ((si[0] === u) || (sibm === u)) {
          mno.style.bottom = "0px";
          // If block with social icons is not empty  
        } else {
          mno.style.bottom = "60px";
          mno.style.transition = ".2s";
          sibm.style.bottom = "0px";
          sibm.style.transition = ".2s";
        }
      }, 350);
      if (sibm !== u) {
        sibm.style.transition = "none";
      }
      // if hamburger icon not clicked or desktop or mobile content menu was closed   
    } else {
      mnbi.className = "nav-bar-mobile__icon";
      mno.style.display = "";
      mno.style.bottom = "0px";
      getHtml.style.scrollBehavior = "";
      getHtml.style.overflowY = "";
      document.body.style.overflow = "visible";
      mhi.className = "hamburger-icon-button__icon";
      if (sibm !== u) {
        sibm.style.bottom = "-10%";
        sibm.style.transition = "none";
      }
      mmst1.style.left = "-50%";
      mmst1.style.transition = "none";
      mmst3.style.right = "-50%";
      mmst3.style.transition = "none";
      mnbp.style.top = "35%";
    }
  }
  // "mobile content menu" function, if someone was clicked on hamburger icon 
  mnbi.addEventListener("click", getResponsiveNavBar);
})();


( function() {  
  function openMobileMetaList() {    
    /* ----- 03 ----- */
    /**
     * After opening the mobile menu with content, the meta menu 
     * will open, if you click on the button with the user icon
     */
    let mlmb = new C("mobile-nav-show-item__meta-nav").lnk;
    let omsb = new C("mobile-nav-show-item__search-block").lnk;
    let stmix = new C("mob-top-link-icon__search-svg-close").lnk;
    let stmi = new C("mob-top-link-icon__search-svg").lnk;
    let mmst1 = new C("top-nav-item__tab-1").lnk;
    let mmst3 = new C("top-nav-item__tab-3").lnk;
    let mlmi = new C("mob-top-link-icon__user-svg").lnk;
    
    // if "add user" icon was clicked, then shows mobile meta menu 
    if (mlmb.className === "mobile-nav-show-item__meta-nav") {
      mlmb.className += " tab--open";
      mlmb.style.display = "block";
      omsb.className = "mobile-nav-show-item__search-block";
      omsb.style.display = "none";
      stmix.style.display = "none";
      stmi.style.display = "unset";
      mmst3.style.background = "#fff";
      mmst3.style.opacity = ".3";
      mmst1.style.background = "#f3f3f3";
      mmst1.style.opacity = "1";
      mlmi.style.fill = "#e40806";
      stmi.style.fill = "#000";
      //  if "add user" icon not clicked or desktop or mobile content menu was closed or meta menu was closed
    } else {      
      mlmb.className = "mobile-nav-show-item__meta-nav";
      mlmb.style.display = "";
      mmst3.style.opacity = "1";
      mmst3.style.background = "";
      mmst1.style.background = "";
      stmi.style.fill = "";
      mlmi.style.fill = "";
    }
  }

  // "mobile meta menu" function, if someone was clicked on "add user" icon
  let mmb = new C("meta-tab").lnk;
  mmb.addEventListener("click", openMobileMetaList);
})();


 ( function() {

  /* ----- 04 ----- */
  function openMobileSearchForm() {
    /**
     * After opening the mobile menu with content, 
     * a block with a search form will open, 
     * if you click on the button with the "magnifying glass" icon
     */    

    let omsb = new C("mobile-nav-show-item__search-block").lnk;
    let mlmb = new C("mobile-nav-show-item__meta-nav").lnk;
    let stmi = new C("mob-top-link-icon__search-svg").lnk;
    let stmix = new C("mob-top-link-icon__search-svg-close").lnk;
    let mmst1 = new C("top-nav-item__tab-1").lnk;
    let mmst3 = new C("top-nav-item__tab-3").lnk;
    let mlmi = new C("mob-top-link-icon__user-svg").lnk;

    // if "magnifying glass" icon icon was clicked, then shows mobile search block 
    if (omsb.className === "mobile-nav-show-item__search-block") {
      omsb.className += " search-block--open";
      omsb.style.display = "block";
      mlmb.className = "mobile-nav-show-item__meta-nav";
      mlmb.style.display = "none";
      stmi.style.display = "none";
      stmix.style.display = "unset";
      mmst1.style.opacity = ".3";
      mmst1.style.background = "#fff";
      mmst3.style.background = "#f3f3f3";
      mmst3.style.opacity = "1";
      stmix.style.fill = "#e40806";
      mlmi.style.fill = "#000";
      //  if "magnifying glass" icon not clicked or desktop or mobile content menu was closed or mobile search block was closed 
    } else {
      omsb.className = "mobile-nav-show-item__search-block";
      omsb.style.display = "";
      stmix.style.display = "none";
      stmi.style.display = "unset";
      mmst3.style.background = "";
      mmst1.style.background = "";
      mmst1.style.opacity = "";
      mlmi.style.fill = "";
      stmi.style.fill = "";
    }
  }

  // mobile search blockfunction, if someone was clicked on "magnifying glass" icon
  let msb = new C("search-tab").lnk;
  msb.addEventListener("click", openMobileSearchForm);
})();

(function() {

 /* ----- 05 ----- */
  /*
   * Mobile Menu Focus On "X" Button Function     
   */

  function getOldschoolMobileSubMenu(mobileCategories) {

    // if screen resolution is less then 1023px
    if (mobileCategories.matches) {

      let mobNavUl = document.getElementsByClassName('oldschool-header-menu')[0];

      if (mobNavUl) { // if menu is on site
        let mobNavLi = mobNavUl.getElementsByClassName('menu-item-has-children');
        let mobNavSubMenu = mobNavUl.getElementsByClassName('sub-menu');
        let mobNavLink = mobNavUl.getElementsByTagName('');
        
        for (let i = 0; i < mobNavLi.length; i++) {            
          // create <button> to every "menu-item-has-children" list element
          let mobNavBtn = document.createElement('button');
          mobNavBtn.className = 'has-children-btn';          
          mobNavLi[i].appendChild(mobNavBtn);
          mobNavLi[i].appendChild(mobNavSubMenu[i]);
          // Open Mobile Sub Menu
          mobNavBtn.onclick = function () {
              mobNavSubMenu[i].classList.toggle('active');
              mobNavBtn.classList.toggle('has-children-btn--pressed');
          }; // end "mobNavBtn.onclick" func 

        } // end for   

     } 
      //screen resolution is higher then 1023px
    } else {
      return;
    }  
  } 

  // screen resolution function
  let x = window.matchMedia("(max-width: 1023px)");
  getOldschoolMobileSubMenu(x);
  x.addListener(getOldschoolMobileSubMenu);

})();

(function(){
  function mobileFocusAction(mobileCategories) {
    /* ----- 06 ----- */
    /*
    *  Mobile Menu Focus On "Close" Button (if press Tab) Function
    */

    // if screen resolution is less then 1023px
    if (mobileCategories.matches) {
    
    let focusToCloseBtn = new C("focus-to-close-btn").lnk;
    let closeBtn = new C("nav-bar-mobile__icon").lnk;

    focusToCloseBtn.onfocus = function () {
      let closeBtn = new C("nav-bar-mobile__icon--pressed").lnk;
      if(closeBtn !== undefined) {      
        closeBtn.focus();
      }  
    };

    //screen resolution is higher then 1023px
    } else {
      return;
    }  
  } 
  // screen resolution function
  let x = window.matchMedia("(max-width: 1023px)");
  mobileFocusAction(x);
  x.addListener(mobileFocusAction);

})();

(function(){
  function mobileFocusAction(mobileFocus) {

  /* ----- 07 ----- */
  /*
   *  Mobile Menu - Focus to last element of mobile menu (if press Shift + Tab) Function
   */

  // if screen resolution is less then 1023px
  if (mobileFocus.matches) {

  document.addEventListener('keydown', function (event) {
    let closeBtn = new C("nav-bar-mobile__icon--pressed").lnk;
    let focusBackBtn = new C("focus-back").lnk;
    let mobileSkipLink = new C("mobile-skip-link").lnk;
    
    if (closeBtn !== undefined && closeBtn.className === 'nav-bar-mobile__icon--pressed') {  
      if ((document.activeElement === closeBtn) && (event.shiftKey && event.keyCode == 9)) {
        focusBackBtn.style.display = "block";
        focusBackBtn.focus();
      } else {
        focusBackBtn.style.display = 'none';
      }
    } 
  });
        
    //screen resolution is higher then 1023px
    } else {
      return;
    }  
  } 
  // screen resolution function
  let x = window.matchMedia("(max-width: 1023px)");
  mobileFocusAction(x);
  x.addListener(mobileFocusAction);

})();


( function() {
  function mobileTitleAction(mobileTitle) {
    /* ----- 08 ----- */
    /*
    *  Mobile Menu - Title (Only first letters if to little screen resolution)
    */
   
    // if screen resolution is less then 1023px
    if (mobileTitle.matches) {
	
	  let u = undefined;
	  let mobileSiteTitle = new C('header-logo__link').lnk;	  
	  let mobileTitleBlock = new C('header-main-content__logo').lnk;
    let mobileSiteHeadingTitle = new C('header-oldschool-logo__title').lnk;	      
      
    if (mobileSiteTitle!==u) {
      // Change top site title in mobile resolution if site load
      setMobileSiteTitle();
      // Change top site title in mobile resolution if site load and resize
      mobileSiteTitleIfResize(); 
    }
      // Function to change top site title in mobile resolution if site load
      function setMobileSiteTitle() {
        let longTitle = mobileSiteTitle.innerHTML;
	      let shortTitle = mobileSiteTitle.innerHTML.split(/\s/).reduce((response,word)=> response+=word.slice(0,1),'');

        if (mobileSiteHeadingTitle.clientWidth >= mobileTitleBlock.clientWidth) {
            mobileSiteTitle.innerHTML = shortTitle;
        } else {
          mobileSiteTitle.innerHTML;          
        }         
      } // setMobileSiteTitle();

      // Function to change top site title in mobile resolution if site load and resize
      function mobileSiteTitleIfResize() {
        let longTitle = mobileSiteTitle.innerHTML;
        let shortTitle = mobileSiteTitle.innerHTML.split(/\s/).reduce((response,word)=> response+=word.slice(0,1),'');

        window.addEventListener("resize", function() {
          if (mobileSiteHeadingTitle.clientWidth >= mobileTitleBlock.clientWidth) {
            mobileSiteTitle.innerHTML = shortTitle;
          } else if (mobileSiteHeadingTitle.clientWidth < mobileTitleBlock.clientWidth) {
            longTitle;
          }                                 
        });
      }

    //screen resolution is higher then 1023px
    } else {
      return;
    }  
  } 
  // screen resolution function
  let x = window.matchMedia("(max-width: 1023px)");
  mobileTitleAction(x);
  x.addListener(mobileTitleAction);

})();


(function () {
  /*
   * Slider functions 
   */
  let u = undefined;
  let n = null;
  let b = document.getElementsByClassName("slider-grid__content-block");
  let c = document.getElementsByClassName("slider-dots-block__dot");
  let slideTimeout;
  let slideIndex = 0;
  let slidesCount = b.length;
  currentSlide(0);
  // change timeout swipes  
  function setSlideTimeout() {
    "use strict";
    if (slideTimeout) clearTimeout(slideTimeout);
    // slides timeout = 4sec
    slideTimeout = setTimeout(function () {
      nextSlide();
    }, 4000);
  }
  // next slide function  
  function nextSlide() {
    "use strict";
    slideIndex = (slideIndex + 1) % slidesCount;
    showSlides();
    setSlideTimeout();
  }
  // previous slide function
  function prevSlide() {
    "use strict";
    slideIndex = (slideIndex < 1 ? slidesCount : slideIndex) - 1;
    showSlides();
    setSlideTimeout();
  }
  // current slide function 
  function currentSlide(a) {
    "use strict";
    slideIndex = a;
    showSlides();
    setSlideTimeout();
  }
  window.slider = {
    prevSlide: prevSlide,
    nextSlide: nextSlide,
    currentSlide: currentSlide
  };
  // slides styles
  function showSlides() {
    "use strict";
    let a;
    for (a = 0; a < b.length; a++) {
      b[a].style.display = "none";
    }
    for (a = 0; a < c.length; a++) {
      c[a].className = c[a].className.replace(" slide--active", "");
    }
    if (b[slideIndex] === u) {
      return;
    } else {
      b[slideIndex].style.display = "block";
    }
    c[slideIndex].className += " slide--active";
  }
  let _slicedToArray = function () {
    function sliceIterator(arr, i) {
      "use strict";
      let _arr = [];
      let _n = true;
      let _d = false;
      let _i, _s, _e;
      try {
        for (_i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);
          if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"]) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }
      return _arr;
    }
    return function (arr, i) {
      "use strict";
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();
  // swipe function 
  (function (n, t, e) {
    "use strict";

    function i(n) {
      function e() {
        o("touchstart", m, w);
        o("touchmove", d, w);
        o("touchend", p, w);
        if (E.mouseEvent) {
          o("mousedown", s, w);
        }
      }

      function i() {
        y = !1;
        D = !1;
        A = !1;
        b = !1;
        a = !1;
      }

      function s(n) {
        /* jshint validthis: true */
        a = this;
        y = n.clientX;
        D = n.clientY;
        o("mousemove", l, v);
        o("mouseup", h, v);
      }

      function l(n) {
        n.preventDefault();
        if (y && D) {
          A = n.clientX;
          b = n.clientY;
        }
      }

      function h(n) {
        r("mousemove", l, v);
        r("mouseup", h, v);
        p(n);
      }

      function m(n) {
        /* jshint validthis: true */
        a = this;
        y = n.touches[0].clientX;
        D = n.touches[0].clientY;
      }

      function d(n) {
        A = n.touches[0].clientX;
        b = n.touches[0].clientY;
      }

      function p(n) {
        if (y && D && A && b) {
          let t = y - A,
            e = D - b,
            o = [t, e].map(Math.abs),
            r = _slicedToArray(o, 2),
            c = r[0],
            s = r[1],
            v = E.minDistance;
          if (c > v) {
            let f = y < A ? "swipeRight" : "swipeLeft";
            u(f, a, {
              distance: t,
              start: y,
              end: A
            });
          }
          if (s > v) {
            let l = D > b ? "swipeUp" : "swipeDown";
            u(l, a, {
              distance: e,
              start: D,
              end: b
            });
          }
          if (c > v || s > v) {
            u("swipe", a);
          }
        }
        i();
      }
      let E = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
        w = c(t.querySelectorAll(n)),
        y = void 0,
        D = void 0,
        A = void 0,
        b = void 0;
      /* jshint validthis: true */
      E.mouseEvent = void 0 === E.mouseEvent ? f.mouseEvent : E.mouseEvent;
      E.minDistance = void 0 === E.minDistance ? f.minDistance : E.minDistance;
      i();
      e();
      this.on = function (n, t) {
        return o(n, t, w),
          this;
      };
    }

    function o(n, t, e) {
      s(e).forEach(function (e) {
        return e.addEventListener(n, t);
      });
    }

    function r(n, t, e) {
      s(e).forEach(function (e) {
        return e.removeEventListener(n, t);
      });
    }

    function u(n, e) {
      let i = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
        o = t.createEvent("Event");
      o.initEvent(n, !0, !0);
      o.swipe = i;
      s(e).forEach(function (n) {
        return n.dispatchEvent(o);
      });
    }

    function c(n) {
      for (let t = [], e = 0; e < n.length; e++) t.push(n[e]);
      return t;
    }

    function s(n) {
      return Array.isArray(n) ? n : [n];
    }
    let a = !1,
      v = [n],
      f = {
        mouseEvent: !0,
        minDistance: 30
      };
    n[e] = i;
  })(window, document, "SwipeIt");
  let swipeIt = new SwipeIt(
    ".automatron-slider__slideshow", {
      minDistance: 80
    }
  );
  // swipe right function ( to previous slide )
  swipeIt.on(
      "swipeRight",
      prevSlide
    )
    // swipe left function ( to next slide )
    .on(
      "swipeLeft",
      nextSlide
    );
})();