<?php
	/**
	*  "Old School" header template. Show all content in header of site.
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<!-- This hook is important for WordPress plugins and other many things-->
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!-- progress container in the top of display -->
<div class="prgrss-blck">
	<div class="prgrss__bar"></div>
</div>
	
<!-- theme main block with content -->
<div class="main-grid-container wrapper-size-medium">
	<!-- top layer of site -->
	<div class="site-layer__top">
		<!-- header -->
		<header class="header__content-block">
			<!-- header mobile navigation bar -->
			<?php get_template_part( 'template-parts/header/header', 'mobile' ); ?>
			<!-- header top block: site logo and title, social icons and search block and site meta menu -->
			<?php get_template_part( 'template-parts/header/header', 'desktop' ); ?>
		</header><!-- end "header" -->
	</div>
	
