<?php
/**
 * "Old School" default functions and definitions.
 *
 * Displays all functions in the head and templates elements.
 *
 * @package oldschool
 * @since oldschool 1.0
 */
/*---------------------------------------------
   TABLE OF CONTENTS:
---------------------------------------------*/
/**
 *   1.0.  Content Width
 *   2.0.  Theme Default Functions
 *   3.0.  Enable Widget Areas
 *   4.0.  Loading "Montserrat" Font
 *   5.0.  Customizer
 *   6.0.  Modify Font Size Tag Cloud Link Widget
 *   7.0.  Excerpt Length
 *   8.0.  Automatron Slider Categories
 *   9.0.  Loading Styles
 *   10.0. Loading Scripts
 *   11.0. Loop Types: 2 Columns And List Of Posts
 *   12.0. OldSchool Options Button
 *   13.0. OldSchool Register
 *   14.0. Article Author
 *   15.0. Category Block Class
 *   16.0. Page meta load if thumbnail with not full width
 *   17.0. Category block load if thumbnail with not full width
 *   18.0. No Sidebar: content block width
 *   19.0. Social icons
 *   20.0. Header menu options
 *   21.0.  Post/Article comments counter nav
 */
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
/*---------------------------------------------
 1.0.  Content Width
---------------------------------------------*/
/**
* Let's set the maximum content width based on the theme's design and stylesheet.
* This will limit the width of all uploaded images and embeds.
*/
// Set content-width.
function oldschool_blog_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'oldschool_blog_content_width', 770 );
}
add_action( 'after_setup_theme', 'oldschool_blog_content_width', 0 );
/*---------------------------------------------
 2.0.  Theme Default Functions
---------------------------------------------*/
if ( ! function_exists( 'oldschool_setup' ) ) :
	/**
	* Sets up theme defaults and registers support for various WordPress features.
	*
	* Note that this function is hooked into the after_setup_theme hook, which runs
	* before the init hook. The init hook is too late for some features, such as indicating
	* support post thumbnails.
	*/
	function oldschool_setup() {
		/**
		* Make theme available for translation.
		* Translations can be placed in the folder "languages" in template directory.
		*/
		load_theme_textdomain( 'oldschool', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Register background functions.
		add_theme_support( 'custom-background' );

		// Add support for core custom logo.
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 37,
				'flex-width'  => false,
				'flex-height' => false,
			)
		);

		// Add default posts and comments RSS feed links to <head>.
		add_theme_support( 'automatic-feed-links' );

		// Enable support for post thumbnails and featured images.
		add_theme_support( 'post-thumbnails' );

		// Add support for three custom navigation menus.
		register_nav_menus(
			array(
				'header-menu'        => __( 'header-menu', 'oldschool' ),
				'top-footer-menu'    => __( 'top-footer-menu', 'oldschool' ),
				'bottom-footer-menu' => __( 'bottom-footer-menu', 'oldschool' ),
			)
		);

		/*
		* Switch default core markup for: gallery, search form, comment form, comments, caption.
		* to output valid HTML5.
		*/
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );
		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );
		// Add support for editor styles.
		add_theme_support( 'editor-styles' );
		// Enqueue editor styles.
		add_editor_style( 'style-editor.css' );
		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => __( 'Small', 'oldschool' ),
					'shortName' => __( 'S', 'oldschool' ),
					'size'      => 19.5,
					'slug'      => 'small',
				),
				array(
					'name'      => __( 'Normal', 'oldschool' ),
					'shortName' => __( 'M', 'oldschool' ),
					'size'      => 22,
					'slug'      => 'normal',
				),
				array(
					'name'      => __( 'Large', 'oldschool' ),
					'shortName' => __( 'L', 'oldschool' ),
					'size'      => 36.5,
					'slug'      => 'large',
				),
				array(
					'name'      => __( 'Huge', 'oldschool' ),
					'shortName' => __( 'XL', 'oldschool' ),
					'size'      => 49.5,
					'slug'      => 'huge',
				),
			)
		);

		// Editor color palette.
		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => __( 'Dark Gray', 'oldschool' ),
					'slug'  => 'dark-gray',
					'color' => '#111',
				),
				array(
					'name'  => __( 'Light Gray', 'oldschool' ),
					'slug'  => 'light-gray',
					'color' => '#767676',
				),
				array(
					'name'  => __( 'White', 'oldschool' ),
					'slug'  => 'white',
					'color' => '#fff',
				),
			)
		);
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
	}
endif; // oldschool_setup
add_action( 'after_setup_theme', 'oldschool_setup' );
/*---------------------------------------------
 3.0.  Enable Widget Areas
---------------------------------------------*/
/*
* Register widget area.
*
* @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
*/

function oldschool_custom_sidebars() {

	// Register sidebar
	$oldschool_sidebar = array(
		'id'            => 'oldschool-sidebar-1',
		'class'         => 'oldschool-sidebar-widget-area ',
		'name'          => __( 'custom-sidebar', 'oldschool' ),
		'description'   => __( 'Add the block of widgets to the custom sidebar', 'oldschool' ),
		'before_title'  => '<h2 class="sidebar-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="sidebar-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_sidebar );
	$oldschool_sidebar_page = array(
		'id'            => 'oldschool-sidebar-2',
		'class'         => 'oldschool-sidebar-widget-area',
		'name'          => __( 'page-sidebar', 'oldschool' ),
		'description'   => __( 'Add the block of widgets to the 2nd sidebar in page of article', 'oldschool' ),
		'before_title'  => '<h2 class="sidebar-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="sidebar-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_sidebar_page );
}

add_action( 'widgets_init', 'oldschool_custom_sidebars' );
function oldschool_footer_sidebars() {

	// Register Footer Widget Areas
	$oldschool_footer_first = array(
		'id'            => 'oldschool-sidebar-3',
		'class'         => 'oldschool-footer-widget-area ',
		'name'          => __( 'footer-widget-1', 'oldschool' ),
		'description'   => __( 'Add 1st block of widgets to the footer 1st area', 'oldschool' ),
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="footer-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_footer_first );
	$oldschool_footer_second = array(
		'id'            => 'oldschool-sidebar-4',
		'class'         => 'oldschool-footer-widget-area',
		'name'          => __( 'footer-widget-2', 'oldschool' ),
		'description'   => __( 'Add 2nd block of widgets to the footer 2nd area', 'oldschool' ),
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="footer-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_footer_second );
	$oldschool_footer_third = array(
		'id'            => 'oldschool-sidebar-5',
		'class'         => 'oldschool-footer-widget-area',
		'name'          => __( 'footer-widget-3', 'oldschool' ),
		'description'   => __( 'Add 3rd block of widgets to the footer 3rd area', 'oldschool' ),
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="footer-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_footer_third );
	$oldschool_footer_fourth = array(
		'id'            => 'oldschool-sidebar-6',
		'class'         => 'oldschool-footer-widget-area',
		'name'          => __( 'footer-widget-4', 'oldschool' ),
		'description'   => __( 'Add 4th block of widgets to the footer 4th area', 'oldschool' ),
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="footer-widget-block %2$s">',
		'after_widget'  => '</div>',
	);
	register_sidebar( $oldschool_footer_fourth );
}

add_action( 'widgets_init', 'oldschool_footer_sidebars' );
/*---------------------------------------------
 4.0.  Loading "Montserrat" Font
---------------------------------------------*/
/**
	* Load Montserrat font.
	*/
function oldschool_fonts() {
	wp_enqueue_style( 'oldschool-fonts', '//fonts.googleapis.com/css?family=Montserrat:400,600,800&display=swap', '', '1.0.0', 'screen' );
}

if ( !wp_is_mobile() ) {
	add_action( 'wp_enqueue_scripts', 'oldschool_fonts' );
}	
/*---------------------------------------------
 5.0.  Customizer
---------------------------------------------*/
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/*---------------------------------------------
 6.0.  Modify Font Size Tag Cloud Link Widget
---------------------------------------------*/
	/**
	* Modifies tag cloud widget arguments to display all tags in the same font size.
	*
	* @param array $args Arguments for tag cloud widget.
	* @return array The filtered arguments for tag cloud widget.
  */
// 6.1. Changing font size
function oldschool_tag_cloud_font_size( $args ) {
	$args['largest'] = 12;
	$args['smallest'] = 12;
	$args['unit'] = 'px';
	$args['format'] = 'flat';
	$args['separator'] = ' ';
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'oldschool_tag_cloud_font_size' );
/*---------------------------------------------
 7.0.  Excerpt Length
---------------------------------------------*/
/**
	* Modifies default length of excerpt
	*
	*/

// Filter except length to 30 words.
// oldschool custom excerpt length
function oldschool_custom_excerpt_length( $length ) {
	if ( is_admin() ) {
		return $length;
	} else {
		return 30;
	}
}
add_filter( 'excerpt_length', 'oldschool_custom_excerpt_length', 999 );
/*---------------------------------------------
 8.0.  Automatron Slider Categories
---------------------------------------------*/
/**
	* This function set the category ID for Automatron Slider options
	*/
function oldschool_slider_categories() {
	if ( ! isset( $category_id ) ) {
		$category_id = get_theme_mod( 'oldschool_featured_category' );
	}
	return $category_id;
}
add_action( 'customize_preview_init', 'oldschool_slider_categories' );
/*---------------------------------------------
 9.0.  Loading Styles
---------------------------------------------*/
/**
	* Enqueue styles.
	*/
function oldschool_styles() {
	// Theme stylesheet.
	wp_enqueue_style( 'oldschool-styles', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );
	if ( is_single() || is_page() || is_singular() ) {
		wp_enqueue_style( 'oldschool_page_styles', get_template_directory_uri() . '/css/page.css', '', 'all' );
	} else {
		if ( get_theme_mod( 'featured_display', 'disable' ) == 'enable' ) {// if enable slider
			if ( get_theme_mod( 'loop', 'columns' ) == 'list' ) {
				wp_enqueue_style( 'oldschool_loop_list_slider_styles', get_template_directory_uri() . '/css/loop-list-slider.css', '', 'all' );// loop-list+slider
			} else {
				wp_enqueue_style( 'oldschool_loop_columns_slider_styles', get_template_directory_uri() . '/css/loop-columns-slider.css', '', 'all' );// loop-columns+slider
			}
		} else { // if slider mode disable
			if ( get_theme_mod( 'loop', 'columns' ) == 'columns' ) {
				wp_enqueue_style( 'oldschool_loop_columns_styles', get_template_directory_uri() . '/css/loop-columns.css', '', 'all' );// loop-columns
			} else {
				wp_enqueue_style( 'oldschool_loop_list_styles', get_template_directory_uri() . '/css/loop-list.css', '', 'all' );// loop-list
			}
		}
	}
}
add_action( 'wp_enqueue_scripts', 'oldschool_styles' );
/*---------------------------------------------
 10.0.  Loading Scripts
---------------------------------------------*/
/**
	* Enqueue scripts.
	*/
function oldschool_scripts() {
	if ( is_single() || is_page() || is_singular() ) {
		wp_enqueue_script( 'oldschool-functions', get_theme_file_uri( '/js/functions.js' ), array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );
	} else {
		if ( get_theme_mod( 'featured_display', 'disable' ) == 'enable' ) {// if enable slider
			wp_enqueue_script( 'oldschool-functions-slider', get_theme_file_uri( '/js/functions-slider.js' ), array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );
		} else {
			wp_enqueue_script( 'oldschool-functions', get_theme_file_uri( '/js/functions.js' ), array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );
		}
	}

	/**
		* Add .js script if "Enable threaded comments" is activated in Admin
		* Codex: {@link https://developer.wordpress.org/reference/functions/wp_enqueue_script/}
		*/
	if ( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1 ) ) {
		wp_enqueue_script( 'comment-reply', 'wp-includes/js/comment-reply', array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );
	}
}
add_action( 'wp_enqueue_scripts', 'oldschool_scripts' );
/*---------------------------------------------
 11.0.  Loop Types: 2 Columns And List Of Posts
---------------------------------------------*/
/**
	* Enqueue scripts.
	*/
function oldschool_loop_types() {
	$post_type_class = 'loop-type__columns';
	if ( ! empty( $post_type_class ) ) {
		if ( get_theme_mod( 'loop', 'columns' ) == 'list' ) {
			$post_type_class = 'loop-type__list';
		} elseif ( get_theme_mod( 'loop', 'columns' ) == 'columns' ) {
			$post_type_class = 'loop-type__columns';
		}
		echo esc_attr( $post_type_class );
	}
}
/*---------------------------------------------
 12.0.  OldSchool Options Button
---------------------------------------------*/
/**
	* Add Old School list element options page in appearance
 */
function oldschool_options() {
	add_theme_page(
		'OldSchool Customizer',
		__( '"Old School" Customizer', 'oldschool' ),
		'administrator',
		'customize.php',
		'',
		null,
		'4'
	);
}
add_action( 'admin_menu', 'oldschool_options' );
/*---------------------------------------------
 13.0.  OldSchool Register
---------------------------------------------*/
/**
	* Add block with register in header. This function should be
	* used in this way, because if the option prohibiting user
	* registration is enabled in the settings, then instead of
	* the block with registration, a block with the date and the
	* clock icon appear
	*/
function oldschool_register() {
	if ( ! is_user_logged_in() ) {
		if ( ! get_option( 'users_can_register' ) ) {
			?>
		<div class="header-meta__time">
			<div class="header-time__block">
				<div class="clock-icon"></div>
			</div>
			<div class="meta-icon-time__date-block">
				<?php echo esc_html( date( 'd.m.Y' ) ); ?>
			</div>
		</div>
			<?php
		} else {
			wp_register( '', '' );
		}
	} else {
		wp_register( '', '' );
	}
}
/*---------------------------------------------
 14.0.  Article Author
---------------------------------------------*/
/**
	* Enable Or Disable Author Name In Post
	*/
function oldschool_authorship() {
	$oldschool_author = '';
	if ( get_theme_mod( 'author_name', 'enable' ) == 'disable' ) {
		$oldschool_author = '';
	} elseif ( get_theme_mod( 'author_name', 'enable' ) == 'enable' ) {
		?>
	<li class="post-info__item">
		<div class="meta-item__icon-author">
			<div class="user-icon"></div>
		</div>
		<div class="meta-item__author-name">
			<?php the_author(); ?>
		</div>
	</li>
		
		<?php
	}
	echo esc_attr( $oldschool_author );
}
/*---------------------------------------------
 15.0.  Category Block Class
---------------------------------------------*/
/**
	* This function display category list for articles, pages and posts if
	* post thumbnail not exist or thumbnail has medium or small sizes.
	*/
function oldschool_thumbnail_category_section() {
	$oldschool_img_data = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
	if ( $oldschool_img_data ) {
		$oldschool_img_width = $oldschool_img_data[1]; // thumbnail's width
		$oldschool_img_height = $oldschool_img_data[2]; // thumbnail's height
	}
	$oldschool_img_full_size = 600; //full-thumbnail's width
	$oldschool_img_medium_size = 300; //medium-thumbnail's width
	$oldschool_category_size_options = '';

	if ( ( ! empty( $oldschool_img_data ) ) && ( ! empty( $oldschool_img_width ) ) && ( ! empty( $oldschool_img_height ) ) && ( ! empty( $oldschool_img_full_size ) ) && ( ! empty( $oldschool_img_medium_size ) ) ) {
		if ( has_post_thumbnail() && ( $oldschool_img_width > $oldschool_img_full_size ) ) {
			return;
		} else {
			if ( ! has_post_thumbnail() || ( has_post_thumbnail() && ( $oldschool_img_width < $oldschool_img_medium_size ) ) ) {
				$oldschool_category_size_options = 'small';
			} else if ( has_post_thumbnail() && ( ( $oldschool_img_width <= $oldschool_img_full_size ) && ( $oldschool_img_width >= $oldschool_img_medium_size ) ) ) {
				$oldschool_category_size_options = 'medium';
			}
			?>
		<div class="category-block__img-size-<?php echo esc_attr( $oldschool_category_size_options ); ?>">
			<div class="thumb-category__block">
				<?php if ( has_category() ) { ?>
					<div class="thumb-category__links-list">
						<?php the_category( '', '' ); ?>
					</div>
				<?php } else { ?>
					<div class="thumb-category__links-list">
						<div class="thumb-category__title">
							<?php the_title_attribute(); ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
			<?php
		}
	}
}
/*---------------------------------------------
 16.0.  Page meta
---------------------------------------------*/
/**
	* Page meta load if thumbnail with not full width
	*/
function oldschool_page_meta_navigation_block() {
	/**
	* This function activates another meta navigation section if post thumbnail
	* has not full or not medium sizes.
	*/
	$oldschool_img_data = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
	if ( $oldschool_img_data ) {
		$oldschool_img_width = $oldschool_img_data[1]; // thumbnail's width
	}
	$oldschool_img_full_size = 600; //not-full-thumbnail's width
	$oldschool_img_medium_size = 300; //medium-thumbnail's width
	if ( has_post_thumbnail() && ( ( ! empty( $oldschool_img_width ) ) && ( ! empty( $oldschool_img_full_size ) ) && ( ! empty( $oldschool_img_medium_size ) ) ) ) {
		if ( $oldschool_img_width >= $oldschool_img_full_size ) {
			?>
			<div class="article__meta-navigation">
			<?php get_template_part( 'template-parts/page/post-meta-navigation' ); ?>
			</div>
			<?php
		} else if ( ( ( $oldschool_img_width < $oldschool_img_full_size ) && ( $oldschool_img_width >= $oldschool_img_medium_size ) ) || ( $oldschool_img_width < $oldschool_img_medium_size ) ) {
			return;
		}
	}
}
/*---------------------------------------------
 17.0.  Category block load if thumbnail with not full width
---------------------------------------------*/
/**
	* This function display categoryblock for articles, pages and posts if
	* post thumbnail not exist or thumbnail has medium or small sizes.
	*/
function oldschool_post_img_sizes_category_block() {
	$oldschool_img_data = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
	if ( $oldschool_img_data ) {
		$oldschool_img_width = $oldschool_img_data[1]; // thumbnail's width
		$oldschool_img_height = $oldschool_img_data[2]; // thumbnail's height
	}
	$oldschool_img_full_size = 600; //not-full-thumbnail's width
	$oldschool_img_medium_size = 300; //medium-thumbnail's width
	if ( has_post_thumbnail() && ( $oldschool_img_width >= $oldschool_img_full_size ) ) {
		return;
	} else {
		if ( has_post_thumbnail() && ( ( $oldschool_img_width < $oldschool_img_full_size ) && ( $oldschool_img_width >= $oldschool_img_medium_size ) ) ) {
			$oldschool_category_size_options = 'medium';
		} else if ( ( has_post_thumbnail() && ( $oldschool_img_width < $oldschool_img_medium_size ) ) || ( ! has_post_thumbnail() ) ) {
			$oldschool_category_size_options = 'small';
		}
		?>
		<div class="category-block__img-size-<?php echo esc_attr( $oldschool_category_size_options ); ?>">
			<div class="thumb-category__block">
				<?php if ( has_category() ) { ?>
					<div class="thumb-category__links-list">
						<?php the_category( ' ', '' ); ?>
					</div>
				<?php } else { ?>
					<div class="page-category__links-list">
						<div class="page-category__title">
							<?php the_title_attribute(); ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
		<?php
	}
}
/*---------------------------------------------
 18.0.  No Sidebar: content block width
---------------------------------------------*/
/**
	* Add class to content block if sidebar exist or not
	*/
function oldschool_content_size() {
	$oldschool_content_class = 'full-width';
	if ( ! empty( $oldschool_content_class ) ) {
		if ( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'no_sidebar' ) {
			$oldschool_content_class = 'full-width';
		} elseif ( ( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'one_sidebar' ) || ( ( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'two_sidebars' ) ) ) {
			$oldschool_content_class = 'content-width';
		}
	}
	echo esc_attr( $oldschool_content_class );
}
/*---------------------------------------------
 19.0.  Social icons
---------------------------------------------*/
/*
	* Add class to content block if sidebar exist or not
	*
	* This function display social icons in: header and footer
	*
	* Get links through Theme Options
	*/
function oldschool_social_icons() {
	$oldschool_social_links = array(
		'oldschool_social_facebook'      => 'fb',
		'oldschool_social_vkontakte'     => 'vk',
		'oldschool_social_odnoclassniki' => 'ok',
		'oldschool_social_twitter'       => 'tw',
		'oldschool_social_youtube'       => 'yt',
		'oldschool_social_telegram'      => 'tlg',
		'oldschool_social_instagram'     => 'inst',
	);
	?>
	<?php foreach ( $oldschool_social_links as $key => $value ) : ?>
		<?php $link = get_theme_mod( $key, '' ); ?>
		<?php if ( ! empty( $link ) ) : ?>
			<li class="social-icons-list__item">
				<a class="soc-icons-item__link" href="<?php echo ( esc_url( $link ) ); ?>" rel="nofollow">
					<svg class="header-social-icon__svg <?php echo esc_attr( $value ); ?>-icon">
						<use xlink:href="#<?php echo esc_attr( $value ); ?>"></use>
					</svg>
				</a>
			</li>
<?php endif; ?>
<?php endforeach; ?>
<?php }

/*---------------------------------------------
 20.0.  Header menu options
---------------------------------------------*/
/**
	* Fixed or not fixed menu
	*/
function oldschool_fixed_menu() {
	$fixed_menu_class = '';
	if ( get_theme_mod( 'fixed_menu', 'not_fixed' ) == 'fixed' ) {
		$fixed_menu_class = ' nav--fixed';
	}
	echo esc_attr( $fixed_menu_class );
}

/*---------------------------------------------
 21.0.  Post/Article comments counter nav
---------------------------------------------*/
/**
	* Meta navigation for posts or article
	*/
function oldschool_comments_counter_nav() {
	comments_number(
		'',
		'<div class="post-comments__icon">
			<div class="post-comments-icon__svg">
				<div class="comment-icon"></div>
			</div>
		</div>
		<div class="post-comments__count-value">
			1
		</div>',
		'<div class="post-comments__icon">
			<div class="post-comments-icon__svg">
			<div class="comment-icon"></div>
		</div>
		</div>
		
		<div class="post-comments__count-value">
			%
		</div>'
	);
}

?>