<?php
/**
	*"Old School" footer template.
	*
	* @package oldschool
	* @subpackage Templates
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
// loading main and top theme icons for quick display
get_template_part( 'template-parts/footer/sprite', 'icons' );
?>	 
<div class="site-layer__bottom">		
	<footer class="site-footer__block">			
		<?php
		get_template_part( 'template-parts/footer/footer-top-block' );
		get_template_part( 'template-parts/footer/footer-middle-block' );
		get_template_part( 'template-parts/footer/footer-bottom-block' );
		?>
		<!-- back to top button -->
		<div class="back-to-top__btn">
			<a href="#" class="back-to-top__button">
				<div class="back-to-top-button__icon">
					<div class="back-to-top-icon__arrow-icon">
						<svg class="back-to-top-arrow-icon__svg">
							<use xlink:href="#arrow"></use>
						</svg>
					</div>
				</div>
			</a>
		</div><!-- end "back to top button" -->
		<!-- theme creators -->
		<div class="site-footer__oldschool-creators">
			<ul class="oldschool-creators__list">
				<li class="footer-creators-list__item">
					<a class="footer-creators-item__link wp" title="Proudly powered by WordPress" href="http://wordpress.org" rel="nofollow">
						<span>
							<?php esc_html_e( 'Proudly powered by WordPress', 'oldschool' ); ?>
						</span>            						
						<svg class="footer-creators-icon__wp-svg-icon">
							<use xlink:href="#wp"></use>
						</svg>
					</a>
				</li>
				<li class="footer-creators-list__item">
					<span class="footer-creators-item__link" title="Designed By CYBER DONUT">
						<?php esc_html_e( 'Designed By', 'oldschool' ); ?>
							<span class="creators-developer__wp-donut">
								<?php esc_html_e( 'CYBER DONUT', 'oldschool' ); ?>
							</span>
					</span>
				</li>
			</ul>
		</div>
	<!-- end "theme creators" -->
	</footer>
</div><!-- end "site-layer__bottom" -->
</div><!-- main-grid-container -->
<?php wp_footer(); ?>
</body>
</html>
