<?php
/**
 *"Old School" comments template. The template for displaying comments.
 *
 *
	* @package oldschool
 * @since oldschool 1.0
 */
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
if ( post_password_required() ) {
	return;
}
?>
<div class="comments__content-block">
	<div class="comments__block <?php oldschool_content_size(); ?>">
		<?php if ( comments_open() ) : ?>
		<!--Comment block title-->
			<h3 class="site-comments__headline-title ">
				<?php esc_html_e( 'Talk', 'oldschool' ); ?>
			</h3>
			<?php if ( ! get_comments_number() == 0 ) : ?>
			<!-- List with comments -->
				<ul class="site-comments__list">
				<?php function oldschool_comments( $comment, $oldschool_args, $depth ) { ?>
					<?php $comment = $GLOBALS['comment']; ?>
					<!-- Comment list element -->
					<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
						<div id="comment-<?php comment_ID(); ?>">
							<div class="comment-list__author-block">
								<div class="comments-author-block__avatar-name-grid">
									<div class="comment-author__avatar">
									<?php
										/* Site avatar or svg icon function
										*
										* Svg icon option
										*/
									if ( get_theme_mod( 'avatar_svg_icon_enabled', 'disable' ) == 'enable' ) {
										?>
									<div class="comment-user-icon"></div>
										<?php
										// avatar option ( by default )
									} else {
										echo get_avatar( $id_or_email, $size, $default, $alt, $oldschool_args );
									}
									?>
							</div>
							<div class="comment-author__name">
								<cite class="comment-author-name__text">
									<?php
									/* Comment author name or comment author name with link
									 *
									 * Enable just comment author name
									 */
									if ( get_theme_mod( 'avatar_name_link_disabled', 'disable' ) == 'enable' ) {
										comment_author();
										// Enable comment author name with link ( by default )
									} else {
										comment_author_link();
									}
									?>
								</cite>
							</div>
						</div>
						<div class="comments-links-block__edit-comment">
							<?php
								// Enable edit link ( by default )
							if ( get_theme_mod( 'edit_link_disabled', 'enable' ) == 'enable' ) {
								edit_comment_link();
							}
							?>
						</div>
					</div>
					<?php comment_text(); ?>
					<div class="comment-list__edit-reply-block">
						<div class="comments-author-block__date">
							<span class="comments-date__time-string">
								<?php
									printf(
										esc_html( '%1$s at %2$s', 'oldschool' ),
										esc_html( get_comment_date() ),
										esc_html( get_comment_time() )
									)
								?>
							</span>
						</div>
						<!-- comment reply button -->
						<div class="comments-links-block__reply-comment">
							<?php
								comment_reply_link(
									array_merge(
										$oldschool_args,
										array(
											'depth' => $depth,
											'max_depth' => $oldschool_args['max_depth'],
										)
									)
								);
							?>
						</div>
					</div>
				</div>
					<?php
				} //oldschool_comments
				$oldschool_args = array(
					'callback' => 'oldschool_comments',
				);
				wp_list_comments( $oldschool_args );
				?>
				</ul>
		<?php endif; ?>
		<div class="site-comments__page-navigation">
			<?php
				paginate_comments_links(
					array(
						'prev_text' => '
							<div class="comments-pages-navigation__arrow-left">
								<svg class="comment-arrow-prev__svg">
									<use xlink:href="#arrow"></use>
	 							</svg>
							</div>
						',
						'next_text' => '
							<div class="comments-pages-navigation__arrow-right">
								<svg class="comment-arrow-next__svg">
									<use xlink:href="#arrow"></use>
	 							</svg>
							</div>',
					)
				);
			?>
		</div>
			<?php comment_form(); ?>
		<?php else : ?>
			<h3>
				<?php esc_html_e( 'Discussions are closed for this page', 'oldschool' ); ?>
			</h3>
		<?php endif; ?>
	</div>
</div>
