<?php
/**
 * ocomedrev Theme Customizer
 *
 * @package ocomedrev
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ocomedrev_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	/* Fonts
	/*--------------------------------------*/
    $wp_customize->add_section(
        'ocomedrev_typography',
        array(
            'title' => __('Ocomedrev Fonts', 'ocomedrev' ),
            'priority' => 1,
        )
    );
    $font_choices = 
      array(
        'Arimo:400,700,400italic,700italic' => 'Arimo',
        'Arvo:400,700,400italic,700italic' => 'Arvo',
        'Abel' => 'Abel',

        'Cabin:400,700' => 'Cabin',
        'Cuprum:400,400italic,700' => 'Cuprum',

        'Bitter:400,700,400italic' => 'Bitter',
        'Bree+Serif' => 'Bree Serif',

        'Dancing+Script:400,700' => 'Dancing Script',
        'Droid Sans:400,700' => 'Droid Sans',
        'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
        'Dosis:300,400,700' => 'Dosis',
      
        'Fira Sans:400,700,400italic,700italic' => 'Fira Sans',

        'Indie+Flower' => 'Indie Flower',
        'Inconsolata:400,700' => 'Inconsolata',

        'Josefin+Sans:400,700' => 'Josefin Sans',

        'Fjalla+One' => 'Fjalla One',

        'Karla:700,400,400italic' => 'Karla',

        'Lato:400,700,400italic,700italic' => 'Lato',
        'Lora:400,700,400italic,700italic' => 'Lora',
        'Lobster' => 'Lobster',
        'Libre+Baskerville:400,700,400italic' => 'Libre Baskerville',

        'Maven+Pro:400,700' => 'Maven Pro',
        'Merriweather:900,700' => 'Merriweather',
        'Montserrat:400,700' => 'Montserrat',
        'Muli:400,400italic' => 'Muli',

        'Noto+Sans:400,700,400italic,700italic' => 'Noto Sanas',
        'Nunito:400,300,700' => 'Nunito',
        
        'Open+Sans:400italic,700italic,400,700' => 'Open Sans',
        'Oswald:400,700' => 'Oswald',
        'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
        'Oxygen:400,300,700' => 'Oxygen',
        
        'Pacifico' => 'Pacifico',
        'Play:400,700' => 'Play',
        'PT Sans:400,700,400italic,700italic' => 'PT Sans',
        'PT+Sans+Narrow:400,700' => 'PT Sans Narrow',
        'Playfair+Display:400,700' => 'Playfair Display',
        'Poiret+One' => 'Poiret One',

        'Raleway:400,700' => 'Raleway',
        'Roboto:400,400italic,700,700italic' => 'Roboto',
        'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
        'Roboto Slab:400,700' => 'Roboto Slab',
        'Rokkitt:400' => 'Rokkitt',

        'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
        'Slabo+27px;' => 'Slabo',
        'Shadows+Into+Light' => 'Shadows Into Light',
        'Signika:700,400' => 'Signika',

        'Titillium+Web:400,300,400italic,700' => 'Titillium Web',

        'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
        'Ubuntu+Condensed' => 'Ubuntu',

        'Vollkorn:400italic,400,700' => 'Vollkorn',

        'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
      );
    
    $wp_customize->add_setting(
      'ocomedrev_heading_fonts',
      array(
        'sanitize_callback' => 'ocomedrev_sanitize_fonts',
      )
    );
    
    $wp_customize->add_control(
      'ocomedrev_heading_fonts',
      array(
        'type' => 'select',
        'priority'    => 10,
        'label' => __('Select your desired font for the heading', 'ocomedrev'),
        'section' => 'ocomedrev_typography',
        'choices' => $font_choices
      )
    );

	$wp_customize->add_setting(
      'ocomedrev_body_fonts',
      array(
        'sanitize_callback' => 'ocomedrev_sanitize_fonts',
      )
    );
    
    $wp_customize->add_control(
      'ocomedrev_body_fonts',
      array(
        'type' => 'select',
        'priority'    => 10,
        'label' => __('Select your desired font for the body', 'ocomedrev'),
        'section' => 'ocomedrev_typography',
        'choices' => $font_choices
      )
    );

	/* Styles
	/*--------------------------------------*/
	$color_choices = array("default" => __('Default', 'ocomedrev'),
					"green-light" => __('Green Light', 'ocomedrev'),
					"red-light" => __('Red Light', 'ocomedrev'),
					"blue-light" => __('Blue Light', 'ocomedrev'),
					"gold-light" => __('Gold Light', 'ocomedrev'),
					"red" => __('Red', 'ocomedrev'),
					"pastel" => __('Pastel', 'ocomedrev'),
					"green" => __('Dark Green', 'ocomedrev')
					);

	$wp_customize->add_setting(
      'ocomedrev_color_scheme',
      array(
        'sanitize_callback' => 'ocomedrev_sanitize_colors',
      )
    );
    
    $wp_customize->add_control(
      'ocomedrev_color_scheme',
      array(
        'type' => 'select',
        'label' => __('Select your desired color schema', 'ocomedrev'),
        'section' => 'colors',
        'choices' => $color_choices,
		'priority' => '1',
      )
    );
}
add_action( 'customize_register', 'ocomedrev_customize_register' );

/* Fonts sanitization
/*----------------------------------*/
function ocomedrev_sanitize_fonts( $input ) {
    $valid = array(
       'Arimo:400,700,400italic,700italic' => 'Arimo',
        'Arvo:400,700,400italic,700italic' => 'Arvo',
        'Abel' => 'Abel',

        'Cabin:400,700' => 'Cabin',
        'Cuprum:400,400italic,700' => 'Cuprum',

        'Bitter:400,700,400italic' => 'Bitter',
        'Bree+Serif' => 'Bree Serif',

        'Dancing+Script:400,700' => 'Dancing Script',
        'Droid Sans:400,700' => 'Droid Sans',
        'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
        'Dosis:300,400,700' => 'Dosis',
      
        'Fira Sans:400,700,400italic,700italic' => 'Fira Sans',

        'Indie+Flower' => 'Indie Flower',
        'Inconsolata:400,700' => 'Inconsolata',

        'Josefin+Sans:400,700' => 'Josefin Sans',

        'Fjalla+One' => 'Fjalla One',

        'Karla:700,400,400italic' => 'Karla',

        'Lato:400,700,400italic,700italic' => 'Lato',
        'Lora:400,700,400italic,700italic' => 'Lora',
        'Lobster' => 'Lobster',
        'Libre+Baskerville:400,700,400italic' => 'Libre Baskerville',

        'Maven+Pro:400,700' => 'Maven Pro',
        'Merriweather:900,700' => 'Merriweather',
        'Montserrat:400,700' => 'Montserrat',
        'Muli:400,400italic' => 'Muli',

        'Noto+Sans:400,700,400italic,700italic' => 'Noto Sanas',
        'Nunito:400,300,700' => 'Nunito',
        
        'Open+Sans:400italic,700italic,400,700' => 'Open Sans',
        'Oswald:400,700' => 'Oswald',
        'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
        'Oxygen:400,300,700' => 'Oxygen',
        
        'Pacifico' => 'Pacifico',
        'Play:400,700' => 'Play',
        'PT Sans:400,700,400italic,700italic' => 'PT Sans',
        'PT+Sans+Narrow:400,700' => 'PT Sans Narrow',
        'Playfair+Display:400,700' => 'Playfair Display',
        'Poiret+One' => 'Poiret One',

        'Raleway:400,700' => 'Raleway',
        'Roboto:400,400italic,700,700italic' => 'Roboto',
        'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
        'Roboto Slab:400,700' => 'Roboto Slab',
        'Rokkitt:400' => 'Rokkitt',

        'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
        'Slabo+27px;' => 'Slabo',
        'Shadows+Into+Light' => 'Shadows Into Light',
        'Signika:700,400' => 'Signika',

        'Titillium+Web:400,300,400italic,700' => 'Titillium Web',

        'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
        'Ubuntu+Condensed' => 'Ubuntu',

        'Vollkorn:400italic,400,700' => 'Vollkorn',

        'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}

/* Fonts sanitization
/*----------------------------------*/
function ocomedrev_sanitize_colors( $input ) {
    $valid = array("default" => __('Default', 'ocomedrev'),
					"green-light" => __('Green Light', 'ocomedrev'),
					"red-light" => __('Red Light', 'ocomedrev'),
					"blue-light" => __('Blue Light', 'ocomedrev'),
					"gold-light" => __('Gold Light', 'ocomedrev'),
					"red" => __('Red', 'ocomedrev'),
					"pastel" => __('Pastel', 'ocomedrev'),
					"green" => __('Dark Green', 'ocomedrev')
					);
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ocomedrev_customize_preview_js() {
	wp_enqueue_script( 'ocomedrev_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'ocomedrev_customize_preview_js' );

/**
 * Get user saved styles and uses them
 */
function ocomedrev_cutomize_saved_styles(){
	echo "<style>";
	if(is_admin_bar_showing()){
		echo "#site-navigation{margin-top:2em;}";
	}
	$headings_font = esc_attr(get_theme_mod('ocomedrev_heading_fonts', "font-family: 'Open Sans', sans-serif"));
	$body_font = esc_attr(get_theme_mod('ocomedrev_body_fonts', "font-family: 'Open Sans', sans-serif"));
	$headings_font = explode(":", $headings_font);
	$body_font = explode(":", $body_font);
	
	echo "body{
			font-family: $body_font[0];
		}
		#masthead{
			font-family: $headings_font[0];
		}
		</style>";

}
add_action('wp_head', 'ocomedrev_cutomize_saved_styles', 100);