<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package ocomedrev
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<!--[if lt IE 9]>
<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
<![endif]-->
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'ocomedrev' ); ?></a>

	<header id="masthead" class="site-header" role="banner">

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<div id="open-menu"><a href="#"><?php echo __('Menu', 'ocomedrev'); ?></a></div><!--Responsive Menu Link-->
			<?php			
			if(has_nav_menu('primary')){
				wp_nav_menu(array( 'theme_location' => 'primary', 'container' => 'nav', 'container_class' => false, 'container_id' => 'menu-principal', 'fallback_cb' => false)); 
			}else{
				echo "<nav><div id='menu-principal'>";
				wp_nav_menu();
				echo "</div></nav>";
			}
			?>
		</nav><!-- #site-navigation -->

		<div id="masthead-head">

			<?php if ( get_header_image() ) : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
					<img id="header-image" src="<?php header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="">
				</a>
			<?php endif; // End header image check. ?>
	
			<?php if(display_header_text()) : ?>
				<?php $style = sprintf( ' style="color:#%s;"', get_header_textcolor() ); ?>
				<div id="site-branding">
					<h1 class="site-title" <?php echo $style; ?> ><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<h2 class="site-description"<?php echo $style; ?> ><?php bloginfo( 'description' ); ?></h2>
				</div><!-- .site-branding -->
			<?php endif; //End header text check ?>

			<div id="top-icon-right">
				<a href="#" id="open-search"><i class="icon ion-search"></i></a>
			</div>

		</div>
	
		<div id="top-search">
			<?php get_search_form() ?>
		</div>

	</header><!-- #masthead -->

<!-- Up buttom when scrolled --> 
<div id="up_buttom">
     <a href="#"><i class="icon ion-chevron-up"></i></a>
</div>

	<div id="content" class="site-content">