<?php
/**
 * ocomedrev functions and definitions
 *
 * @package ocomedrev
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'ocomedrev_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function ocomedrev_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on ocomedrev, use a find and replace
	 * to change 'ocomedrev' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'ocomedrev', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'ocomedrev' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'ocomedrev_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif; // ocomedrev_setup
add_action( 'after_setup_theme', 'ocomedrev_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function ocomedrev_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'ocomedrev' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'ocomedrev_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ocomedrev_scripts() {

	wp_enqueue_style( 'ocomedrev-style', get_stylesheet_uri() );

	$color_schema = esc_attr(get_theme_mod('ocomedrev_color_scheme'));
	if(!$color_schema){
		wp_enqueue_style( 'ocomedrev-color-schema',  get_template_directory_uri() . '/css/styles-default.css' );
	}else{
		wp_enqueue_style( 'ocomedrev-color-schema',  get_template_directory_uri() . '/css/styles-' . $color_schema . '.css' );
	}
	

	wp_enqueue_script( 'ocomedrev-navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '20120206', true );
	wp_enqueue_script('masonry');

	wp_enqueue_script( 'ocomedrev-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );
	
	$headings_font = esc_html(get_theme_mod('ocomedrev_heading_fonts'));
	$body_font = esc_html(get_theme_mod('ocomedrev_body_fonts'));
	if( $headings_font ) {
		wp_enqueue_style( 'ocomedrev-headings-fonts', '//fonts.googleapis.com/css?family='. $headings_font );	
	}
	if($headings_font != $body_font){
		if( $body_font ) {
			wp_enqueue_style( 'ocomedrev-body-fonts', '//fonts.googleapis.com/css?family='. $body_font );	
		}
	}

	wp_enqueue_style('ionicons', get_template_directory_uri() . '/fonts/ionicons/css/ionicons.min.css');

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ocomedrev_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
