<?php
/**
 * @package ocomedrev
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class("post-index"); ?>>

	<?php if(has_post_thumbnail()) : ?>

		<header class="entry-header">

		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php the_post_thumbnail('large', array("class" => "post-thumbnail-index")); ?>

		</header><!-- .entry-header -->
	
	<?php else : ?>

		<header class="entry-header">

			<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

			<?php if ( 'post' == get_post_type() ) : ?>
			<div class="entry-meta">
				<?php ocomedrev_posted_on(); ?>
			</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->
	
	
		<div class="entry-content">
			<?php the_excerpt(); ?>
	
			<?php ocomedrev_keep_reading(); ?>
	
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'ocomedrev' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->

	<?php endif; ?>

	<footer class="entry-footer">
		<?php ocomedrev_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->