<?php

if ( ! function_exists( 'nysu_magazine_options_general_style' ) ) {
	function nysu_magazine_options_general_style() {
		$nysu_magazine_options_general_style = array('-nyma-sk-white' => esc_html__('White Skin', 'nysu-magazine'), '-nyma-sk-black' => esc_html__('Black Skin', 'nysu-magazine'));
		if(has_filter('nysu_magazine_options_general_style_filter')) {
			$nysu_magazine_options_general_style = apply_filters('nysu_magazine_options_general_style_filter', $nysu_magazine_options_general_style);
		}
		return $nysu_magazine_options_general_style;
	}
}

if ( ! function_exists( 'nysu_magazine_customize_register' ) ) {
  function nysu_magazine_customize_register( $wp_customize ) {
	
	class NYSU_MAGAZINE_Upsell_Section_Pro extends WP_Customize_Section {
		public $type = 'nysu_magazine_upsell';

		/**
		 * Custom button text to output.
		 *
		 * @since  1.0.0
		 * @access public
		 * @var    string
		 */
		public $pro_text = '';

		/**
		 * Custom pro button URL.
		 *
		 * @since  1.0.0
		 * @access public
		 * @var    string
		 */
		public $pro_url = '';

		/**
		 * Add custom parameters to pass to the JS via JSON.
		 *
		 * @since  1.0.0
		 * @access public
		 * @return void
		 */
		public function json() {
			$json = parent::json();

			$json['pro_text'] = $this->pro_text;
			$json['pro_url']  = esc_url( $this->pro_url );

			return $json;
		}

		/**
		 * Outputs the Underscore.js template.
		 *
		 * @since  1.0.0
		 * @access public
		 * @return void
		 */
		protected function render_template() { ?>

			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

				<h3 class="accordion-section-title">
					{{ data.title }}

					<# if ( data.pro_text && data.pro_url ) { #>
						<a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
					<# } #>
				</h3>
			</li>
		<?php }
	}


	/***** Register Custom Controls *****/
	// Multiple Category
	class NYSU_Magazine_Multiple_Select extends WP_Customize_Control {

		/**
		 * The type of customize control being rendered.
		 */
		public $type = 'multiple-select';

		/**
		 * Displays the multiple select on the customize screen.
		 */
		public function render_content() {

		if ( empty( $this->choices ) )
			return;
			?>
				<label>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<select <?php $this->link(); ?> multiple="multiple" style="height: 100%;">
						<?php
							foreach ( $this->choices as $value => $label ) {
								$selected = ( in_array( $value, $this->value() ) ) ? selected( 1, 1, false ) : '';
								echo '<option value="' . esc_attr( $value ) . '"' . esc_attr( $selected ) . '>' . wp_kses_post( $label ) . '</option>';
							}
						?>
					</select>
					<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
				</label>
		<?php }
	}
	
	
	
	
	// Upgrade Class
	class NYSU_MAGAZINE_Upgrade extends WP_Customize_Control {
        public function render_content() {  ?>
 
			<p class="nyma-button">
				<a href="http://wpamanuke.com/nysu-magazine-wordpress-theme/" target="_blank" class="button button-secondary">
					<?php esc_html_e('Theme Documentation', 'nysu-magazine'); ?>
				</a>
			</p>
			<p class="nyma-button">
				<a href="http://wpamanuke.com/contact" target="_blank" class="button button-secondary">
					<?php esc_html_e('Support Forum', 'nysu-magazine'); ?>
				</a>
			</p>
			<p class="nyma-button">
				<a href="https://wordpress.org/support/theme/nysu-magazine/reviews/#new-post/" target="_blank" class="button button-secondary">
					<?php esc_html_e('Leave a review', 'nysu-magazine'); ?>
				</a>
			</p>
			<?php
        }
    }
	
		
    /***** Add Panels *****/

	$wp_customize->add_panel('nysu_theme_options', array('title' => esc_html__('Theme Options', 'nysu-magazine'), 'description' => '', 'capability' => 'edit_theme_options', 'theme_supports' => '', 'priority' => 2));

	/***** Add Sections *****/

	$wp_customize->add_section('nysu_magazine_general', array('title' => esc_html__('General', 'nysu-magazine'), 'priority' => 1, 'panel' => 'nysu_theme_options'));
	$wp_customize->add_section('nysu_magazine_layout', array('title' => esc_html__('Layout', 'nysu-magazine'), 'priority' => 2, 'panel' => 'nysu_theme_options'));
	$wp_customize->add_section('nysu_magazine_header', array('title' => esc_html__('Header', 'nysu-magazine'), 'priority' => 3, 'panel' => 'nysu_theme_options'));
	$wp_customize->add_section('nysu_magazine_single', array('title' => esc_html__('Single', 'nysu-magazine'), 'priority' => 4, 'panel' => 'nysu_theme_options'));
	$wp_customize->add_section('nysu_magazine_homepage', array('title' => esc_html__('Magazine Template', 'nysu-magazine'), 'priority' => 5, 'panel' => 'nysu_theme_options'));
	
	$wp_customize->add_section('nysu_magazine_upgrade', array('title' => esc_html__('More Features &amp; Options', 'nysu-magazine'), 'priority' => 6, 'panel' => 'nysu_theme_options'));

    /***** Add Settings *****/
	
	// General
	$wp_customize->add_setting('nysu_magazine_options[general_style]', array('default' => '-nyma-sk-white', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
    $wp_customize->add_setting('nysu_magazine_options[general_excerpt_length]', array('default' => 25, 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_integer'));
    $wp_customize->add_setting('nysu_magazine_options[general_excerpt_more]', array('default' => '[...]', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_text'));
	$wp_customize->add_setting('nysu_magazine_options[general_ticker_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[general_ticker_cat]', array('default' => array(0), 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_multiple'));
	$wp_customize->add_setting('nysu_magazine_options[general_ticker_post_count]', array('default' => '6', 'type' => 'option', 'sanitize_callback' => 'absint'));
    // Layout
    $wp_customize->add_setting('nysu_magazine_options[layout_theme]', array('default' => 'nyma-box', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[layout_column]', array('default' => '2', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
 	// Header
	$wp_customize->add_setting('nysu_magazine_options[header_style]', array('default' => '', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[header_image_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[header_image_src]',array('default' => '','type' => 'option', 'transport' => 'refresh','sanitize_callback' => 'absint'));
	$wp_customize->add_setting('nysu_magazine_options[header_image_link]', array('default' => '','type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_url') );
	
	// Single
	$wp_customize->add_setting('nysu_magazine_options[single_breadcrumb_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[single_image_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[single_post_nav_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[single_related_post_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	
	// Homepage Magazine Template
	$wp_customize->add_setting('nysu_magazine_options[magazine_slider_show]', array('default' => 'enable', 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_select'));
	$wp_customize->add_setting('nysu_magazine_options[magazine_slider_cat]', array('default' => array(0), 'type' => 'option', 'sanitize_callback' => 'nysu_magazine_sanitize_multiple'));
	$wp_customize->add_setting('nysu_magazine_options[magazine_slider_post_count]', array('default' => '6', 'type' => 'option', 'sanitize_callback' => 'absint'));
	
	// Upgrade
	$wp_customize->add_setting('nysu_magazine_options[premium_version_upgrade]', array('default' => '', 'type' => 'option', 'sanitize_callback' => 'esc_attr'));
	
	
    /***** Add Controls *****/
	
	// General
	$wp_customize->add_control('general_style', array('label' => esc_html__('CSS Skin', 'nysu-magazine'), 'section' => 'nysu_magazine_general', 'settings' => 'nysu_magazine_options[general_style]', 'priority' => 1, 'type' => 'select', 'choices' => nysu_magazine_options_general_style() ) );
    $wp_customize->add_control('general_excerpt_length', array('label' => esc_html__('Custom excerpt length in words', 'nysu-magazine'), 'section' => 'nysu_magazine_general', 'settings' => 'nysu_magazine_options[general_excerpt_length]', 'priority' => 2, 'type' => 'text'));
    $wp_customize->add_control('general_excerpt_more', array('label' => esc_html__('Custom excerpt more text', 'nysu-magazine'), 'section' => 'nysu_magazine_general', 'settings' => 'nysu_magazine_options[general_excerpt_more]', 'priority' => 3, 'type' => 'text'));
	$wp_customize->add_control('general_ticker_show', array('label' => esc_html__('Ticker News', 'nysu-magazine'), 'section' => 'nysu_magazine_general', 'settings' => 'nysu_magazine_options[general_ticker_show]', 'priority' => 4, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control(
		new NYSU_Magazine_Multiple_Select (
			$wp_customize,
			'general_ticker_cat',
			array(
				'settings' => 'nysu_magazine_options[general_ticker_cat]',
				'label'    => 'Ticker News Category',
				'section'  => 'nysu_magazine_general', // Enter the name of your own section
				'type'     => 'multiple-select', // The $type in our class
				'choices' =>nysu_magazine_cats(),
				'description' => 'Hold Ctrl ( to select multiple categories ) ',
				 'priority' => 5
			)
		)
	);
	$wp_customize->add_control('general_ticker_post_count', array('label' => esc_html__('Ticker Post Count', 'nysu-magazine'), 'section' => 'nysu_magazine_general', 'settings' => 'nysu_magazine_options[general_ticker_post_count]', 'priority' => 5, 'type' => 'text'));
  
  
    // Layout
	$wp_customize->add_control('layout_theme', array('label' => esc_html__('Layout Type', 'nysu-magazine'), 'section' => 'nysu_magazine_layout', 'settings' => 'nysu_magazine_options[layout_theme]', 'priority' => 1, 'type' => 'select', 'choices' => array('nyma-full' => esc_html__('Full Width', 'nysu-magazine'), 'nyma-box' => esc_html__('Boxed', 'nysu-magazine'))));
    $wp_customize->add_control('layout_column', array('label' => esc_html__('Layout Column', 'nysu-magazine'), 'section' => 'nysu_magazine_layout', 'settings' => 'nysu_magazine_options[layout_column]', 'priority' => 2, 'type' => 'select', 'choices' => array('1' => esc_html__('1 Column', 'nysu-magazine'), '2' => esc_html__('2 Column', 'nysu-magazine'))));
	// Header
	$wp_customize->add_control('header_style', array('label' => esc_html__('Header Style', 'nysu-magazine'), 'section' => 'nysu_magazine_header', 'settings' => 'nysu_magazine_options[header_style]', 'priority' => 1, 'type' => 'select', 'choices' => array('' => esc_html__('Default', 'nysu-magazine'), 'center' => esc_html__('Center', 'nysu-magazine'))));
	$wp_customize->add_control('header_image_show', array('label' => esc_html__('Header Image', 'nysu-magazine'), 'section' => 'nysu_magazine_header', 'settings' => 'nysu_magazine_options[header_image_show]', 'priority' => 2, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control( new WP_Customize_Cropped_Image_Control( $wp_customize, 'header_image_src',
	   array(
		  'label' => esc_html__('Header Image Ads', 'nysu-magazine'),
		  'description' => esc_html__( 'Header Image Ads (728x90)','nysu-magazine' ),
		  'section' => 'nysu_magazine_header',
		  'settings' => 'nysu_magazine_options[header_image_src]',
		  'flex_width' => false, // Optional. Default: false
		  'flex_height' => false, // Optional. Default: false
          'width' => 728, // Optional. Default: 150
          'height' => 90, // Optional. Default: 150
		  'button_labels' => array( // Optional.
			 'select' => esc_html__('Select Image', 'nysu-magazine'),
			 'change' => esc_html__('Change Image', 'nysu-magazine'),
			 'remove' => esc_html__('Remove Image', 'nysu-magazine'),
			 'default' => esc_html__('Default', 'nysu-magazine'),
			 'placeholder' => esc_html__('No Image Selected', 'nysu-magazine'),
			 'frame_title' => esc_html__('Select Image', 'nysu-magazine'),
			 'frame_button' => esc_html__('Choose Image', 'nysu-magazine'),
		  ),
		  'priority' => 3
	   )
	) );
	$wp_customize->add_control( 'header_image_link', array(
	  'type' => 'text',
	  'section' => 'nysu_magazine_header', // Add a default or your own section
	  'settings' => 'nysu_magazine_options[header_image_link]',
	  'label' => esc_html__('Header Image Link', 'nysu-magazine'),	  
	  'description' => esc_html__('Custom URL', 'nysu-magazine'),
	  'input_attrs' => array(
		'placeholder' =>esc_html__('http://www.wpamanuke.com', 'nysu-magazine'),
	  ),
	  'priority' => 4
	) );
	
	// Single
	$wp_customize->add_control('single_breadcrumb_show', array('label' => esc_html__('Breadcrumb', 'nysu-magazine'), 'section' => 'nysu_magazine_single', 'settings' => 'nysu_magazine_options[single_breadcrumb_show]', 'priority' => 1, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control('single_image_show', array('label' => esc_html__('Featured Image on Single', 'nysu-magazine'), 'section' => 'nysu_magazine_single', 'settings' => 'nysu_magazine_options[single_image_show]', 'priority' => 2, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control('single_post_nav_show', array('label' => esc_html__('Post Next Previous', 'nysu-magazine'), 'section' => 'nysu_magazine_single', 'settings' => 'nysu_magazine_options[single_post_nav_show]', 'priority' => 3, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control('single_related_post_show', array('label' => esc_html__('Related Post', 'nysu-magazine'), 'section' => 'nysu_magazine_single', 'settings' => 'nysu_magazine_options[single_related_post_show]', 'priority' => 4, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	
	// Homepage Magazine Template
	$wp_customize->add_control('magazine_slider_show', array('label' => esc_html__('Header Slider', 'nysu-magazine'), 'section' => 'nysu_magazine_homepage', 'settings' => 'nysu_magazine_options[magazine_slider_show]', 'priority' => 1, 'type' => 'select', 'choices' => array('enable' => esc_html__('Enable', 'nysu-magazine'), 'disable' => esc_html__('Disable', 'nysu-magazine'))));
	$wp_customize->add_control(
		new NYSU_Magazine_Multiple_Select (
			$wp_customize,
			'magazine_slider_cat',
			array(
				'settings' => 'nysu_magazine_options[magazine_slider_cat]',
				'label'    => 'Slider Category',
				'section'  => 'nysu_magazine_homepage', // Enter the name of your own section
				'type'     => 'multiple-select', // The $type in our class
				'choices' => nysu_magazine_cats(),
				'description' => 'Hold Ctrl ( to select multiple categories ) ',
				 'priority' => 2
			)
		)
	);
	$wp_customize->add_control('magazine_slider_post_count', array('label' => esc_html__('Slider Post Count', 'nysu-magazine'), 'section' => 'nysu_magazine_homepage', 'settings' => 'nysu_magazine_options[magazine_slider_post_count]', 'priority' => 3, 'type' => 'text','description' => 'Fill 3 , 6 , 9 , 12 '));
	
	// Upgrade
	$wp_customize->add_control(new NYSU_Magazine_Upgrade($wp_customize, 'premium_version_upgrade', array('section' => 'nysu_magazine_upgrade', 'settings' => 'nysu_magazine_options[premium_version_upgrade]', 'priority' => 1)));
	
	
  }
}
add_action('customize_register', 'nysu_magazine_customize_register');

/***** Data Sanitization *****/
if (!function_exists('nysu_magazine_sanitize_text')) {
	function nysu_magazine_sanitize_text($input) {
		return wp_kses_post(force_balance_tags($input));
	}
}

if (!function_exists('nysu_magazine_sanitize_integer')) {
	function nysu_magazine_sanitize_integer($input) {
		return strip_tags($input);
	}
}

if (!function_exists('nysu_magazine_sanitize_checkbox')) {
	function nysu_magazine_sanitize_checkbox($input) {
		if ($input == 1) {
			return 1;
		} else {
			return '';
		}
	}
}

if (!function_exists('nysu_magazine_sanitize_select')) {
	function nysu_magazine_sanitize_select($input) {
		return wp_filter_nohtml_kses( $input );
	}
}

if (!function_exists('nysu_magazine_sanitize_url')) {
	function nysu_magazine_sanitize_url( $url ) {
	  return esc_url_raw( $url );
	}
}

if (!function_exists('nysu_magazine_sanitize_multiple')) {
	function nysu_magazine_sanitize_multiple( $input ) {
		$multi_values = !is_array( $input ) ? explode( ',', $input ) : $input;

		return !empty( $multi_values ) ? array_map( 'sanitize_text_field', $multi_values ) : array();
	}
}

if (!function_exists('nysu_magazine_cats')) {
	function nysu_magazine_cats() {
	  $cats = array();
	  $cats[0] = "All";
	  foreach ( get_categories() as $categories => $category ) {
		$cats[$category->term_id] = $category->name;
	  }
	  return $cats;
	}
}

/***** Return Theme Options / Set Default Options *****/
// load data

if (!function_exists('nysu_magazine_theme_options')) {
	function nysu_magazine_theme_options() {
		$nysu_magazine_options = get_option('nysu_magazine_options');
		$theme_options = wp_parse_args(
			$nysu_magazine_options,
			nysu_magazine_default_options()
		);
		return $theme_options;
	}
}

if (!function_exists('nysu_magazine_default_options')) {
	function nysu_magazine_default_options() {
		$default_options = array(
			'general_style' => '-nyma-sk-white',
			'general_excerpt_length' => '35',
			'general_excerpt_more' => '[..]',
			'general_ticker_show' => 'enable',
			'general_ticker_cat' => array(0),
			'general_ticker_post_count' => 6,
			'layout_theme' => 'nyma-box',
			'layout_column' => '2',
			'header_style' => '',
			'header_image_show' => 'enable',
			'header_image_src' => '',
			'header_image_link' => '',
			'single_breadcrumb_show' => 'enable',
			'single_image_show' => 'enable',
			'single_post_nav' => 'enable',
			'single_related_post_show' => 'enable',
			'magazine_slider_show' => 'enable',
			'magazine_slider_cat' => array(0),
			'magazine_slider_post_count' => 6
		);
		return $default_options;
	}
}

// get data key
if (!function_exists('nysu_magazine_data')) {
	function nysu_magazine_data($key,$default='') {
		$data = nysu_magazine_theme_options();
		if ($data) {
			if (isset($data[$key])) {
				return $data[$key];
			}
		}
		return $default;
	}
}

if (!function_exists('nysu_magazine_echo_data')) {
	function nysu_magazine_echo_data() {
		print_r(nysu_magazine_theme_options());
	}
}
if (!function_exists('nysu_magazine_reset_data')) {
	function nysu_magazine_reset_data() {
		update_option('nysu_magazine_options','');
	}
}


?>