<?php

/***** Date *****/
if ( ! function_exists( 'nysu_magazine_current_time' ) ) {
	function nysu_magazine_current_time(  $format = 'd F Y') {
		$current_timestamp = current_time( 'timestamp' , 0 );
		return date( $format, $current_timestamp );
	}
}
/***** Post Meta *****/
if (!function_exists('nysu_magazine_post_format_icon')) {
	function nysu_magazine_post_format_icon() {
		switch ( get_post_format() ) {
			case 'audio': $icon = 'fa-volume-up'; break;
			case 'aside' : $icon = 'fa-sticky-note'; break;
			case 'chat' : $icon = 'fa-list-alt'; break;
			case 'image': $icon = 'fa-camera-retro'; break;
			case 'link' : $icon = 'fa-link	'; break;
			case 'gallery': $icon = 'fa-newspaper-o'; break;
			case 'status' : $icon = 'fa-commenting'; break;
			case 'video': $icon = 'fa-file-video-o'; break;
			case 'quote': $icon = 'fa-quote-left'; break;
			default: $icon = 'fa-pencil-square-o'; break;
		}
		return '<i class="fa ' . $icon . '"></i>';
	}
}

if ( ! function_exists( 'nysu_magazine_post_meta' )) {
	function nysu_magazine_post_meta( $args , $separator='<span class="entry-meta-separator">|</span>' ) {
		
		if ( in_array('cat',$args) ) {
			$meta['cat'] = '<span class="entry-meta-categories">' .  get_the_category_list(', ', '') . '</span>' . "\n";
		}
		if ( in_array('cat-icon',$args) ) {
			$meta['cat-icon'] = '<span class="entry-meta-categories">' . nysu_magazine_post_format_icon()  . get_the_category_list(', ', '') . '</span>' . "\n";
		}
		if ( in_array('date',$args) ) {
			$meta['date'] =  '<span class="entry-meta-date updated" datetime="'. esc_attr(get_the_modified_time( 'c' )) .'">'. get_the_date() . '</span>' . "\n";
		}
		if ( in_array('date-link',$args) ) {
			$meta['date-link'] =  '<span class="entry-meta-date updated" datetime="'. esc_attr(get_the_modified_time( 'c' )) .'"><a href="' . esc_url( get_month_link( get_the_time('Y') , get_the_time('m') ) ) . '">' . get_the_date() . '</a></span>' . "\n";
		}
		if ( in_array('author',$args) ) {
			$meta['author'] = '<span class="entry-meta-author author vcard" >by <a class="url fn n" href="' . esc_url( get_author_posts_url ( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>' . "\n";
		}
		if ( in_array('comment',$args) ) {
			$meta['comment'] = '<span class="entry-meta-comments"><i class="fa fa-comment-o"></i><a class="nyma-comment-scroll" href="' . esc_url( get_permalink() . '#nyma-comments' ) . '">' . absint(get_comments_number()) . '</a></span>' . "\n";
		}
		echo '<div class="nyma-meta entry-meta">' . "\n";
		
		$numItems = count($args);
		$i = 0;
		foreach( $args as $item ) {
			echo wp_kses_post( $meta[$item] );
			if ( ++$i!=$numItems ) {
				echo wp_kses_post( $separator );
			}
		}
		echo '</div>' . "\n";
	}
}

if ( ! function_exists( 'nysu_magazine_the_post_thumbnail' ) ) {
	function nysu_magazine_the_post_thumbnail( $size='nysu-magazine-medium' , $filename='placeholder-medium.png' ) {
		echo '<figure class="post-thumbnail">';
		nysu_magazine_post_thumbnail( $size , $filename ); 
		echo '</figure>';
	}
}
	
/***** Custom Excerpts *****/
if ( ! function_exists( 'nysu_magazine_excerpt_length' ) ) {
	function nysu_magazine_excerpt_length( $length ) {
		
		$excerpt_length = nysu_magazine_data( 'general_excerpt_length' , 35 );
		return $excerpt_length;
	}
}
add_filter( 'excerpt_length' , 'nysu_magazine_excerpt_length' , 999 );

if ( ! function_exists( 'nysu_magazine_excerpt_more' ) ) {
	function nysu_magazine_excerpt_more( $more ) {		
		return ' ' . nysu_magazine_data( 'general_excerpt_more' , '' );
	}
}
add_filter( 'excerpt_more' , 'nysu_magazine_excerpt_more' );

if ( !function_exists( 'nysu_magazine_excerpt_markup' ) ) {
	function nysu_magazine_excerpt_markup( $excerpt ) {
		$markup = '<div class="nyma-excerpt">' . $excerpt . '</div>';
		return $markup;
	}
}
add_filter( 'the_excerpt' , 'nysu_magazine_excerpt_markup' );


/* Last POST */
if ( ! function_exists( 'nysu_magazine_more_posts' ) ) {
		function nysu_magazine_more_posts() {
		  global $wp_query;
		  return $wp_query->current_post + 1 < $wp_query->post_count;
		}
	}

/* Block SPACE */
if ( ! function_exists( 'nysu_magazine_block_space' ) ) {
	function nysu_magazine_block_space() {
		echo '<div class="nyma-block-space"></div>';
	}
}

if ( ! function_exists( 'nysu_magazine_header_style' ) ) :
	function nysu_magazine_header_style() {
		$header_text_color = get_header_textcolor();
		if ( get_theme_support( 'custom-header', 'default-text-color' ) != $header_text_color ) {
			?>
			<style type="text/css" id="nysu-magazine-header-textcolor-css">
				.site-title a {
					color: #<?php echo esc_attr( $header_text_color ); ?>;
				}
			</style>
			<?php
		}
		$header_image = get_header_image();

		// If no custom options for text are set, let's bail.
		if ( empty( $header_image ) ) {
			return;
		}

		// If we get this far, we have custom styles. Let's do this.
		?>
		<style type="text/css" id="nysu-magazine-header-css">
		<?php
		
			if ( ! empty( $header_image ) ) :
		?>
			#site-header {

				/*
				 * No shorthand so the Customizer can override individual properties.
				 * @see https://core.trac.wordpress.org/ticket/31460
				 */
				background-image: url(<?php header_image(); ?>);
				background-repeat: no-repeat;
				background-position: 50% 50%;
				-webkit-background-size: cover;
				-moz-background-size:    cover;
				-o-background-size:      cover;
				background-size:         cover;
			}

			
		<?php
			endif;
		?>
		</style>
		<?php
	}
endif; 


// Footer Widget

if ( ! function_exists( 'nysu_magazine_footer_widgets' ) ) {
	function nysu_magazine_footer_widgets() {
		$footer_1 = ''; $footer_2 = ''; $footer_3 = '';  $footer_columns = 0; $footer_class = 'col-md-4';
		if ( is_active_sidebar( 'footer-1') ) {
			$footer_1 = 1; $footer_columns++;
		}
		if ( is_active_sidebar( 'footer-2' ) ) {
			$footer_2 = 1; $footer_columns++;
		}
		if ( is_active_sidebar( 'footer-3') ) {
			$footer_3 = 1; $footer_columns++;
		}
		
		if ( $footer_columns == 1 ) {
			$footer_class = 'col-md-12';
		} 
		
		if ( $footer_1 || $footer_2 || $footer_3 ) {
			echo '<div id="footer" class="footer-white -color-footer">';
				echo '<div class="container">';
					echo '<div class="row">';
						if ( $footer_1 ) {
							echo '<div class="' . esc_attr( $footer_class ) . '">' . "\n";
								dynamic_sidebar( 'footer-1' );
							echo '</div>' . "\n";
							
							if ($footer_columns == 2) {
								$footer_class = 'col-md-8';
							}
						}
						if ($footer_2) {
							echo '<div class="' . esc_attr( $footer_class ) . '">' . "\n";
								dynamic_sidebar( 'footer-2' );
							echo '</div>' . "\n";
							if ($footer_columns == 2) {
								$footer_class = 'col-md-8';
							}
						}
						if ($footer_3) {
							echo '<div class="' . esc_attr( $footer_class ) . '">' . "\n";
								dynamic_sidebar( 'footer-3' );
							echo '</div>' . "\n";
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}
	}
}

// handle siteorigin pagebuilder excerpt problem for php 5.3 > using Closure and php 5.2 Using create_function (using additional plugin) 
// cause the_excerpt in widget will loop when using Page Builder by SiteOrigin so we need custom the_excerpt
if ( ! function_exists( 'nysu_magazine_the_excerpt' ) ) {
	function nysu_magazine_the_excerpt() { 
		the_excerpt(); 		
	}
}

/***** Custom Commentlist *****/

if (!function_exists('nysu_magazine_comments')) {
	function nysu_magazine_comments( $comment , $args, $depth ) { ?>
		<li id="comment-<?php comment_ID() ?>" <?php comment_class( 'nyma-comment-item' ); ?>>
			<article id="div-comment-<?php comment_ID(); ?>" class="nyma-comment-body"  itemscope itemtype="http://schema.org/Comment">
				<footer class="nyma-comment-footer nyma-clearfix">
					<div class="nyma-comment-meta">
						<div class="vcard author nyma-comment-meta-author">
							<span class="fn"><a class="comment-author-link" href="<?php comment_author_url(); ?>" itemprop="author"><?php comment_author(); ?></a></span>
						</div>
						<a class="nyma-comment-meta-date"  datetime="<?php comment_date( 'Y-m-d' ) ?>T<?php comment_time( 'H:iP' ) ?>" itemprop="datePublished" href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>">
							<?php
								/* get comment date and time */
								printf('%1$s at %2$s', esc_html( get_comment_date() ),  esc_html( get_comment_time() )); 
							?>
						</a>
					</div>
					<figure class="nyma-comment-gravatar">
						<?php echo get_avatar( $comment->comment_author_email , 60 ); ?>
					</figure>
					
				</footer>
				<?php if ( $comment->comment_approved == '0') { ?>
					<div class="nyma-comment-info">
						<?php esc_html_e( 'Your comment is awaiting moderation.', 'nysu-magazine' ) ?>
					</div>
				<?php } ?>
				<div class="entry-content nyma-comment-content"  itemprop="text">
					<?php comment_text() ?>
				</div>
				<div class="nyma-meta nyma-comment-meta-links"><?php
					edit_comment_link( esc_html__( 'Edit' , 'nysu-magazine' ), '  ', '');
					if (comments_open() && $args['max_depth'] != $depth) {
						comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth'])));
					} ?>
                </div>
			</article><?php
	}
}

/***** Custom Comment Fields *****/

if ( ! function_exists( 'nysu_magazine_comment_fields' ) ) {
	function nysu_magazine_comment_fields( $fields ) {
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ($req ? " aria-required='true'" : '');
		$fields =  array(
			'author'	=>	'<p class="comment-form-author"><label for="author">' . esc_html__('Name ', 'nysu-magazine') . '</label>' . ($req ? '<span class="required">*</span>' : '') . '<br/><input id="author" name="author" type="text"  value="' . esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' /></p>',
			'email' 	=>	'<p class="comment-form-email"><label for="email">' . esc_html__('Email ', 'nysu-magazine') . '</label>' . ($req ? '<span class="required">*</span>' : '' ) . '<br/><input id="email" name="email" type="text"  value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' /></p>',
			'url' 		=>	'<p class="comment-form-url"><label for="url">' . esc_html__('Website', 'nysu-magazine') . '</label><br/><input id="url" name="url" type="text" value="' . esc_attr($commenter['comment_author_url']) . '" size="30" /></p>'
		);
		return $fields;
	}
}
add_filter( 'comment_form_default_fields' , 'nysu_magazine_comment_fields' );

/***** Comment Count Output *****/

if ( ! function_exists( 'nysu_magazine_comment_count' ) ) {
	function nysu_magazine_comment_count() {
		echo '<a class="nyma-comment-count-link" href="' . esc_url( get_permalink() . '#nyma-comments' ) . '">' . absint( get_comments_number() ) . '</a>';
	}
}


/***** Post / Attachment Navigation *****/

if ( ! function_exists( 'nysu_magazine_next_post_link_attributes' ) ) {
	function nysu_magazine_next_post_link_attributes($output) {
		$code = 'class="post-next"';
		return str_replace('<a href=', '<a '.$code.' href=', $output);
	}
}
add_filter('next_post_link', 'nysu_magazine_next_post_link_attributes');

if (!function_exists('nysu_magazine_previous_post_link_attributes')) {
	function nysu_magazine_previous_post_link_attributes($output) {
		$code = 'class="post-previous"';
		return str_replace('<a href=', '<a '.$code.' href=', $output);
	}
}
add_filter('previous_post_link', 'nysu_magazine_previous_post_link_attributes');

if ( ! function_exists( 'nysu_magazine_single_postnav' ) ) {
	function nysu_magazine_single_postnav() {
		
		if ( 'enable' === nysu_magazine_data( 'single_post_nav_show' , 'enable' ) ) {
			get_template_part( 'template-parts/single/prev' , 'next' );
			nysu_magazine_block_space();
		}
	}
}
add_action('nysu_magazine_after_post_content', 'nysu_magazine_single_postnav');

if ( ! function_exists( 'nysu_magazine_single_related_post' ) ) {
	function nysu_magazine_single_related_post() {
		if ( nysu_magazine_data( 'single_related_post_show' ) == 'enable' ) {
			get_template_part( 'template-parts/single/related' , 'post' );
			nysu_magazine_block_space();
		}
	}
}
add_action('nysu_magazine_after_post_content', 'nysu_magazine_single_related_post');
/***** Pagination for paginated Posts *****/

if ( ! function_exists( 'nysu_magazine_paginated_posts' ) ) {
	function nysu_magazine_paginated_posts( $content ) {
		if ( is_singular() && in_the_loop() ) {
			$content .= wp_link_pages( array( 'before' => '<div class="pagination clearfix">', 'after' => '</div>', 'link_before' => '<span class="pagelink">', 'link_after' => '</span>', 'nextpagelink' => esc_html__('&raquo;', 'nysu-magazine'), 'previouspagelink' => esc_html__('&laquo;', 'nysu-magazine'), 'pagelink' => '%', 'echo' => 0));
		}
		return $content;
	}
}
add_filter('the_content', 'nysu_magazine_paginated_posts', 1);


/** Post Thumbnail **/
if (!function_exists('nysu_magazine_post_thumbnail')) {
	function nysu_magazine_post_thumbnail($size='',$file_img='') {
		
			echo '<a href="'. esc_url( get_the_permalink() ) .'" title="'. the_title_attribute(array('echo'=>false)) .'">';
			if ( has_post_thumbnail() ) { 
				the_post_thumbnail($size);
			} else {
				echo '<img class="nyma-image-placeholder" src="' . esc_url( get_template_directory_uri() . '/public/images/'. $file_img ) . '" alt="" />';
			}
			echo '<span class="overlay">'. wp_kses_post( nysu_magazine_post_format_icon() ) .'</span>';
			echo '</a>';
		
	}
}


/** breadcrumb **/
function nysu_magazine_the_breadcrumb( $str_start='' , $str_end='') {
	$show = nysu_magazine_data( 'single_breadcrumb_show' );
	if ( $show == 'enable' ) {
		echo wp_kses_post( $str_start );
		$sep = '<li> > </li>';

		if (!is_front_page()) {
		
		// Start the breadcrumb with a link to your homepage
			echo '<ul itemscope itemtype="http://schema.org/BreadcrumbList" class="breadcrumbs">';
			echo '<li><a itemprop="url" title="" href="';
			echo esc_url( home_url( '/' ) );
			echo '"><i class="fa fa-home"></i> ';
			bloginfo('name');
			echo '</a></li>' . wp_kses_post( $sep );
		
		// Check if the current page is a category, an archive or a single page. If so show the category or archive name.
			if ( is_category() || is_single() ){
				echo '<li itemprop="itemListElement" itemscope
		  itemtype="http://schema.org/ListItem">';
				//the_category(' , ');
				global $post;
				$cats = get_the_category( $post->ID );
				$count = count( $cats );
				$i = 0;
				foreach ( $cats as $cat ){
					$i++;
					echo '<a itemprop="url" href="'. esc_url( get_category_link( $cat->term_id ) )  .'" title="">'. esc_html( $cat->cat_name ) . '</a>';
					if ( $i < $count ) {
						echo '  ,  ';
					}
				}
				echo '</li>';
			} elseif ( is_archive() || is_single() ){
				
			}
		
		// If the current page is a single post, show its title with the separator
			if ( is_single() ) {
				
				echo wp_kses_post($sep);
				echo '<li itemprop="itemListElement" itemscope
		  itemtype="http://schema.org/ListItem">';
				the_title();
				echo '</li>';
			}
		
		// If the current page is a static page, show its title.
			if (is_page()) {
				echo '<li itemprop="itemListElement" itemscope
		  itemtype="http://schema.org/ListItem">';
				echo the_title();
				echo '</li>';
			}
		
				
			echo '</ul>';
			echo '<div class="clearfix"></div>';
			echo wp_kses_post( $str_end );
		}
    }
}


/* Header Slider */
if (!function_exists('nysu_magazine_header_slider')) {
	function nysu_magazine_header_slider() { 
		if (is_page_template( 'templates/template-magazine.php' )) {
			$show = nysu_magazine_data( 'magazine_slider_show' );
			if ( $show == 'enable' ) {
				get_template_part( 'template-parts/header/header' , 'slider' ); 
			}
		}
	}
}
add_action( 'nysu_magazine_after_header' , 'nysu_magazine_header_slider' );

/* News Ticker */
if ( ! function_exists( 'nysu_magazine_general_ticker' ) ) {
	function nysu_magazine_general_ticker() { 
		$show = nysu_magazine_data( 'general_ticker_show' );
		if ( $show == 'enable' ) {
			get_template_part( 'template-parts/header/header' , 'ticker-news' );
		}
	}
}
add_action( 'nysu_magazine_after_header' , 'nysu_magazine_general_ticker' );



// Change Atts for Schema Organizations
if ( ! function_exists( 'nysu_magazine_add_menu_atts' ) ) {
	function nysu_magazine_add_menu_atts( $atts, $item, $args ) {

	  $atts['itemprop'] = 'url';
	  if( $args->theme_location == 'socialmenu' ) {
		   $atts['itemprop'] = 'sameAs';
		   $atts['rel'] = 'external';
	  } 
	  return $atts;
	}
}
add_filter( 'nav_menu_link_attributes', 'nysu_magazine_add_menu_atts', 10, 3 );


// Create Body ID 
if ( ! function_exists( 'nysu_magazine_get_body_id' ) ) {
	function nysu_magazine_get_body_id( $id = '' ) {
		global $wp_query;
		// Fallbacks
		if ( is_front_page() )  $id = 'front-page';
		if ( is_home() )        $id = 'blog';
		if ( is_search() )      $id = 'search';
		if ( is_404() )         $id = 'error404';
			
		// If it's an Archive Page
		if ( is_archive() ) {
			if ( is_author() ) {
				$author = $wp_query->get_queried_object();
				$id = 'archive-author-' . sanitize_html_class( $author->user_nicename , $author->ID );
			} elseif ( is_category() ) {
				$cat = $wp_query->get_queried_object();
				$id = 'archive-category-' . sanitize_html_class( $cat->slug, $cat->cat_ID );
			} elseif ( is_date() ) {
					if ( is_day() ) {
						$date = get_the_time('F jS Y');
						$id = 'archive-day-' . str_replace(' ', '-', strtolower($date) );
					} elseif ( is_month() ) {
						$date = get_the_time('F Y');
						$id = 'date-' . str_replace(' ', '-', strtolower($date) );   
					} elseif ( is_year() ) {
						$date = get_the_time('Y');
						$id = 'date-' . strtolower($date);
					} else {
						$id = 'archive-date';
					}
			} elseif ( is_tag() ) {
				$tags = $wp_query->get_queried_object();
				$id = 'archive-tag-' . sanitize_html_class( $tags->slug, $tags->term_id );
			} else {
				$id = 'archive';
			}
		}
		
		// If it's a Single Post
		if ( is_single() ) {
			if ( is_attachment() ) {
				$id = 'attachment-'.$wp_query->queried_object->post_name;
			} else {
				$id = 'single-'.$wp_query->queried_object->post_name;
			}
		}
		// If it's a Page
		if ( is_page() ) {
			$id = 'page-'.$wp_query->queried_object->post_name;
			if ('' == $id ) {
				$id = 'page';
			}
		}
		
		// If $id still doesn't have a value, attempt to assign it the Page's name
		if ('' == $id ) {
			$id = $wp_query->queried_object->post_name;
		}
			
		$id = preg_replace('/\s+/', ' ', $id);
		$id = str_replace(' ', '-', strtolower($id) );
		
		// Let other plugins modify the function
		return apply_filters( 'nysu_magazine_get_body_id', $id );    
	}
}
/**
 * Print a dynamic id on body elements
 *
 */
if ( ! function_exists( 'nysu_magazine_body_id' ) ) {
	function nysu_magazine_body_id( $id = '' ) {
		if ( '' == $id ) {
			$id = nysu_magazine_get_body_id();
		}
		
		$id = preg_replace( '/\s+/', ' ', $id );
		$id = str_replace( ' ' , '-' , strtolower($id) );
		$id = apply_filters( 'nysu_magazine_body_id' , $id );

		echo ( '' != $id ) ? 'id="'. esc_attr( $id ) . '"' : '' ;
	}
 }

// get create time of post
if ( ! function_exists( 'nysu_magazine_the_time' ) ) {
	function nysu_magazine_the_time( $d = '' ) {
		echo esc_attr( apply_filters( 'the_time', get_the_time( $d ), $d ) );
	}
}

// get latest update time of post
if ( ! function_exists( 'nysu_magazine_the_modified_time' ) ) {
	function nysu_magazine_the_modified_time( $d = '' ) {
		echo esc_attr( apply_filters( 'the_modified_time', get_the_modified_time($d), $d ) );
	}
}

// custom logo with prop
if ( ! function_exists( 'nysu_magazine_get_custom_logo' ) ) {
// Filter the output of logo to fix Googles Error about itemprop logo
	function nysu_magazine_get_custom_logo() {
		$custom_logo_id = get_theme_mod( 'custom_logo' );
		$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
				esc_url( home_url( '/' ) ),
				wp_get_attachment_image( $custom_logo_id, 'full', false, array(
					'class'    => 'custom-logo',
					'itemprop' => 'logo'
				) )
			);
		return $html;   
	}
}
add_filter( 'get_custom_logo', 'nysu_magazine_get_custom_logo' );

?>