<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class NYSU_MAGAZINE_Upsell {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		

		// Register custom section types.
		$manager->register_section_type( 'NYSU_MAGAZINE_Upsell_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new NYSU_MAGAZINE_Upsell_Section_Pro(
				$manager,
				'nysu_magazine_upsell',
				array(
					'title'    => esc_html__( 'NYSU Magazine Pro', 'nysu-magazine' ),
					'pro_text' => esc_html__( 'Go Pro',         'nysu-magazine' ),
					'pro_url'  => esc_url( __( 'http://wpamanuke.com' , 'nysu-magazine' )),
					'priority'  => 1,
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'nysu-magazine-upsell-js', trailingslashit( get_template_directory_uri() ) . 'includes/upsell/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'nysu-magazine-upsell-style', trailingslashit( get_template_directory_uri() ) . 'includes/upsell/customize-controls.css' );
	}
}

// Doing this customizer thang!
NYSU_MAGAZINE_Upsell::get_instance();
