<?php

/***** Fetch Theme Data & Options *****/

$nysu_magazine_data = wp_get_theme('nysu-magazine');
$nysu_magazine_version = $nysu_magazine_data['Version'];


/***** Custom Hooks *****/
if (!function_exists('nysu_magazine_before_header')) {
	function nysu_magazine_before_header() {
		do_action('nysu_magazine_before_header');
	}
}
if (!function_exists('nysu_magazine_after_header')) {
	function nysu_magazine_after_header() {
		do_action('nysu_magazine_after_header');
	}
}

if (!function_exists('nysu_magazine_before_post_content')) {
	function nysu_magazine_before_post_content() {
		do_action('nysu_magazine_before_post_content');
	}
}

if (!function_exists('nysu_magazine_after_post_content')) {	
	function nysu_magazine_after_post_content() {
		do_action('nysu_magazine_after_post_content');
	}
}		

if (!function_exists('nysu_magazine_before_footer')) {
	function nysu_magazine_before_footer() {
		do_action('nysu_magazine_before_footer');
	}
}
if (!function_exists('nysu_magazine_after_footer')) {
	function nysu_magazine_after_footer() {
		do_action('nysu_magazine_after_footer');
	}
}

/***** Theme Setup *****/

if (!function_exists('nysu_magazine_setup')) {
	function nysu_magazine_setup() {
		// Translation
		load_theme_textdomain('nysu-magazine', get_template_directory() . '/languages');
		add_theme_support('automatic-feed-links');
		/* Wordpress Title */
		add_theme_support( 'title-tag' );
		/* post format */
		add_theme_support( 'post-formats', array( 'aside','gallery', 'link', 'image','quote','status','video','audio','chat' ) );
		//add_filter('use_default_gallery_style', '__return_false');
		add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption'));
		add_theme_support('post-thumbnails', array( 'post' ));
		add_theme_support('custom-background', array('default-color' => '005ba0'));
		add_theme_support('custom-header', array('default-image' => '', 'default-text-color' => '404040', 'width' => 1200, 'height' => 250, 'flex-width' => true, 'flex-height' => true,'wp-head-callback'       => 'nysu_magazine_header_style'));
		add_theme_support('custom-logo', array('width' => 370, 'height' => 90, 'flex-width' => true, 'flex-height' => true));
		add_theme_support('customize-selective-refresh-widgets');
		/* Menus */
		register_nav_menu('primary', esc_html__('Primary Menu', 'nysu-magazine'));
		register_nav_menu('top', esc_html__('Top Menu', 'nysu-magazine'));
		register_nav_menu('social', esc_html__('Social Network Menu', 'nysu-magazine'));
		/* Style For WP Editor */
		add_editor_style();
	}
}
add_action('after_setup_theme', 'nysu_magazine_setup');


/***** Add Custom Image Sizes *****/

if (!function_exists('nysu_magazine_image_sizes')) {
	function nysu_magazine_image_sizes() {
		add_image_size('nysu-magazine-biggest', 1140, 500, true);
		add_image_size('nysu-magazine-gallery', 280, 280, true);
		add_image_size('nysu-magazine-large', 760, 500, true);
		add_image_size('nysu-magazine-medium', 380, 250, true);
		add_image_size('nysu-magazine-small', 60, 60, true);
	}
}
add_action('after_setup_theme', 'nysu_magazine_image_sizes');


/***** Set Content Width *****/

if (!function_exists('nysu_magazine_content_width')) {
	function nysu_magazine_content_width() {
		global $content_width;
		if (!isset($content_width)) {
			$content_width = 760;
		}
	}
}
add_action('template_redirect', 'nysu_magazine_content_width');


/***** Load CSS & JavaScript *****/

if (!function_exists('nysu_magazine_scripts')) {
	function nysu_magazine_scripts() {
		global $nysu_magazine_version;
		// GOOGLE FONTS
		wp_enqueue_style('nysu-magazine-google-opensans', 'https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i', array(), null);
		wp_enqueue_style('nysu-magazine-google-raleway', 'https://fonts.googleapis.com/css?family=Raleway:400,400i,500,500i,600,600i,700,700i', array(), null);
		
		// CSS
		wp_enqueue_style('font-awesome', get_template_directory_uri() . '/public/css/font-awesome.min.css', array(), null);	
		wp_enqueue_style('nysu-magazine-style', get_stylesheet_uri(), false, $nysu_magazine_version);
		
		// SCRIPT JS
		wp_enqueue_script("jquery");
		wp_enqueue_script('jquery-owlcarousel', get_template_directory_uri() . '/public/js/owlcarousel/owl.carousel.min.js', array('jquery'), $nysu_magazine_version);
		wp_enqueue_script('jquery-marquee', get_template_directory_uri() . '/public/js/jquery.marquee.js', array('jquery'), $nysu_magazine_version);
		wp_enqueue_script('nysu-magazine-scripts', get_template_directory_uri() . '/public/js/scripts.js', array('jquery'), $nysu_magazine_version);
		if (is_singular() && comments_open() && get_option('thread_comments') == 1) {
			wp_enqueue_script('comment-reply');
		}
	}
}
add_action('wp_enqueue_scripts', 'nysu_magazine_scripts');

if (!function_exists('nysu_magazine_admin_scripts')) {
	function nysu_magazine_admin_scripts($hook) {
		if ('appearance_page_magazine' === $hook || 'widgets.php' === $hook) {
			wp_enqueue_style('nysu-magazine-admin', get_template_directory_uri() . '/public/admin/admin.css');
		}
	}
}
add_action('admin_enqueue_scripts', 'nysu_magazine_admin_scripts');

/***** Include Several Functions *****/

/***** Register Widget Areas / Sidebars	*****/

if (!function_exists('nysu_magazine_widgets_init')) {
	function nysu_magazine_widgets_init() {
		
		
		
		register_sidebar(array('name' => esc_html__('Sidebar (4/12)', 'nysu-magazine'), 'id' => 'sidebar-1', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		register_sidebar(array('name' => esc_html__('Header Ads', 'nysu-magazine'), 'id' => 'header-ads', 'description' => esc_html__('Header Ads ( Just put your adsense code here using Custom HTML Widget )', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-header-widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-header-widget-title"><span class="nyma-header-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		register_sidebar(array('name' => esc_html__('Footer 1', 'nysu-magazine'), 'id' => 'footer-1', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-footer %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-footer-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		register_sidebar(array('name' => esc_html__('Footer 2', 'nysu-magazine'), 'id' => 'footer-2', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-footer %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-footer-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		register_sidebar(array('name' => esc_html__('Footer 3', 'nysu-magazine'), 'id' => 'footer-3', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-footer %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-footer-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		register_sidebar(array('name' => esc_html__('Mag (12/12) A', 'nysu-magazine'), 'id' => 'mag-a-12-12', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		register_sidebar(array('name' => esc_html__('Mag (8/12) B', 'nysu-magazine'), 'id' => 'mag-b-8-12', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		register_sidebar(array('name' => esc_html__('Mag (4/12) B', 'nysu-magazine'), 'id' => 'mag-b-4-12', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget  nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		register_sidebar(array('name' => esc_html__('Mag (4/12) C-1', 'nysu-magazine'), 'id' => 'mag-c-4-12-1', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget  nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		register_sidebar(array('name' => esc_html__('Mag (4/12) C-2', 'nysu-magazine'), 'id' => 'mag-c-4-12-2', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		register_sidebar(array('name' => esc_html__('Mag (4/12) C-3', 'nysu-magazine'), 'id' => 'mag-c-4-12-3', 'description' => esc_html__('Widget area (sidebar left/right) on single posts, pages and archives.', 'nysu-magazine'), 'before_widget' => '<div id="%1$s" class="widget nyma-widget-mag %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="nyma-widget-mag-title"><span class="nyma-widget-title-inner">', 'after_title' => '</span></h4>'));
		
		
	}
}
add_action('widgets_init', 'nysu_magazine_widgets_init');


/***** Register Widgets *****/

function nysu_magazine_register_widgets() {
	register_widget('nysu_magazine_block_1_widget');
	register_widget('nysu_magazine_block_2_widget');
	register_widget('nysu_magazine_block_3_widget');
	register_widget('nysu_magazine_block_4_widget');
	register_widget('nysu_magazine_block_5_widget');
	register_widget('nysu_magazine_stack_1_widget');
	register_widget('nysu_magazine_gallery_1_widget');
	register_widget('nysu_magazine_slider_1_widget');
	register_widget('nysu_magazine_slider_2_widget');
	register_widget('nysu_magazine_slider_3_widget');
}
add_action('widgets_init', 'nysu_magazine_register_widgets');




/******** include function custom ***********/


require_once get_template_directory() .'/includes/nysu-customizer.php';
require_once get_template_directory() .'/includes/nysu-custom-functions.php';
// require_once get_template_directory() .'/includes/upsell/class-customize.php';

/***** Include Widgets *****/
require_once get_template_directory() .'/includes/widgets/nysu-block-1.php';
require_once get_template_directory() .'/includes/widgets/nysu-block-2.php';
require_once get_template_directory() .'/includes/widgets/nysu-block-3.php';
require_once get_template_directory() .'/includes/widgets/nysu-block-4.php';
require_once get_template_directory() .'/includes/widgets/nysu-block-5.php';
require_once get_template_directory() .'/includes/widgets/nysu-gallery-1.php';
require_once get_template_directory() .'/includes/widgets/nysu-stack-1.php';
require_once get_template_directory() .'/includes/widgets/nysu-slider-1.php';
require_once get_template_directory() .'/includes/widgets/nysu-slider-2.php';
require_once get_template_directory() .'/includes/widgets/nysu-slider-3.php';
