<?php /* Comments Template */
	if (post_password_required()) {
		return;
	}
	if (have_comments()) {
?>
<div class="nyma-comment">
	<div  class="nyma-comment-normal">
		<?php
			$comments_by_type = separate_comments($comments);
			if ( ! empty( $comments_by_type['comment'] ) ) {
				$comment_count = count( $comments_by_type['comment'] ); ?>
				<div id="nyma-comments" class="nyma-comments-wrap">
					<h4 class="nyma-comments-title">
						<span class="nyma-comments-title-inner">
							<?php 
								/* translators: 1: number of comments */
								printf( esc_html( _n( '%d Comment' , '%d Comments' , $comment_count , 'nysu-magazine' )), esc_html ( number_format_i18n( $comment_count ) ) ); 
							?>
						</span>
					</h4>
					<ol class="commentlist nyma-comment-list">
						<?php echo wp_list_comments( 'callback=nysu_magazine_comments&type=comment' ); ?>
					</ol>
				</div><?php
			}
			if ( get_comments_number() > get_option( 'comments_per_page' ) ) { ?>
				<nav class="nyma-comments-pagination">
					<?php paginate_comments_links( array( 'prev_text' => esc_html__('&laquo;', 'nysu-magazine'), 'next_text' => esc_html__('&raquo;', 'nysu-magazine') )); ?>
				</nav><?php
			}
			if ( !empty( $comments_by_type['pings'] ) ) {
				$pings = $comments_by_type['pings'];
				$ping_count = count( $comments_by_type['pings'] ); ?>
				<h4 class="nyma-commentst-title">
					<span class="nyma-comments-title-inner">
						<?php 
							/* translators: 1: number of Pingbacks  */
							printf( esc_html( _n( '%d Trackback / Pingback' , '%d Trackbacks / Pingbacks' , $ping_count , 'nysu-magazine' ) ), esc_html ( number_format_i18n( $ping_count ) ) ); 
						?>
					</span>
				</h4>
				<ol class="pinglist nyma-ping-list">
					<?php foreach ($pings as $ping) { ?>
						<li id="comment-<?php comment_ID() ?>" <?php comment_class( 'nyma-ping-item' ); ?>>
							<?php echo '<i class="fa fa-link"></i>' . get_comment_author_link( $ping ); ?>
						</li>
					<?php } ?>
				</ol><?php
			}
			if (!comments_open()) { ?>
				<p class="nyma-no-comments">
					<?php esc_html_e('Comments are closed.', 'nysu-magazine'); ?>
				</p><?php
			}
			if (comments_open()) {
				comment_form(array(
					'title_reply' => esc_html__( 'Leave a Reply' , 'nysu-magazine' ),
					'comment_notes_before' => ' <p class="comment-notes">' . esc_html__( 'Your email address will not be published.' , 'nysu-magazine' ) . '</p>',
					'comment_notes_after'  => '',
					'comment_field' => '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Comment' , 'nysu-magazine' ) . '</label><br/><textarea id="comment" name="comment" cols="45" rows="5" aria-required="true"></textarea></p>'
				));
			}
		?>
	</div>
</div>
<?php
} else {
	if (comments_open()) { ?>
		<div class="nyma-comment">
			<div  class="nyma-comment-normal">
				<h4 id="nyma-comments" class="nyma-widget-title nyma-comment-form-title">
					<span class="nyma-widget-title-inner">
						<?php esc_html_e('Be the first to comment', 'nysu-magazine'); ?>
					</span>
				</h4>
				<?php
				 comment_form(array(
					'title_reply' => esc_html__( 'Leave a Reply' , 'nysu-magazine' ),
					'comment_notes_before' => '<p class="comment-notes">' . esc_html__( 'Your email address will not be published.' , 'nysu-magazine' ) . '</p>',
					'comment_notes_after'  => '',
					'comment_field' => '<p class="comment-form-comment"><label for="comment">' . esc_html__('Comment', 'nysu-magazine') . '</label><br/><textarea id="comment" name="comment" cols="45" rows="5" aria-required="true"></textarea></p>'
				));
				?>
			</div>
		</div>
		<?php
	}
}
?>
	