<?php

  /**
   *This code iclude any elements of Twenty Twelve theme.
   *Code of Twenty Twelve just like all other code is licensed under the GPL.
   **/       
  
	function nuvio_new_excerpt_more($more) {
		return ' ';
	}
	add_filter('excerpt_more', 'nuvio_new_excerpt_more');
	function nuvio_new_excerpt_length($length) {
		return 75;
	}
	add_filter('excerpt_length', 'nuvio_new_excerpt_length');
	
	
	register_nav_menus();

		register_sidebar(array(
		'name' => 'Sidebar below thme menu',
    'id' => 'sidebar-1',
		'before_widget' => '<div class="widget">', 
		'after_widget' => '</div>', 
		'before_title' => '<h4 class="title">', 
		'after_title' => '</h4>', 
	));
  
  	register_sidebar(array(
		'name' => 'Sidebar above thme menu',
    'id' => 'sidebar-2',
		'before_widget' => '<div class="widget">', 
		'after_widget' => '</div>', 
		'before_title' => '<h4 class="title">', 
		'after_title' => '</h4>', 
	));
	//wp_enqueue_script('jquery');
  
  
  /**
 * Extend the default WordPress body classes.
 *
 * Adds body classes to denote:
 * 1. Single or multiple authors.
 * 2. Active widgets in the sidebar to change the layout and spacing.
 * 3. When avatars are disabled in discussion settings.
 *
 * @param array $classes A list of existing body class values.
 * @return array The filtered body class list.
 * 
 *  This code is taken from Twenty Twelve theme  
 */
function nuvio_body_class( $classes ) {
	if ( ! is_multi_author() )
		$classes[] = 'single-author';

	if ( is_active_sidebar( 'sidebar-2' ) && ! is_attachment() && ! is_404() )
		$classes[] = 'sidebar';

	if ( ! get_option( 'show_avatars' ) )
		$classes[] = 'no-avatars';

	return $classes;
}
add_filter( 'body_class', 'nuvio_body_class' );

  
 
 function nuvio_scripts_styles() {
	global $wp_styles; 
  
  	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	// Loads stylesheet
  
  wp_enqueue_style( 'nuviotemplates-mainstyle',  get_template_directory_uri() . '/color-style/one/css/main.css', false, false, 'screen and (min-width: 951px)' );
  wp_enqueue_style( 'nuviotemplates-mainstyle-800',  get_template_directory_uri() . '/color-style/one/css/main800.css', false, false, 'screen and (max-width: 950px)' );
  wp_enqueue_style( 'nuviotemplates-mainstyle-700',  get_template_directory_uri() . '/color-style/one/css/main700.css', false, false, 'only screen and (max-width: 770px)' );
 
  wp_enqueue_style( 'scheme',  get_template_directory_uri() . '/color-style/one/css/scheme.css', false, false, 'screen,projection' );
  wp_enqueue_style( 'print',  get_template_directory_uri() . '/color-style/one/css/print.css', false, false, 'print' );

  	// Loads our style.css.
	wp_enqueue_style( 'stylesheet', get_stylesheet_uri(), false, false, 'screen,projection' );

}


  
  
  
  
  function nuvio_entry_meta() {
	// Translators: used between list items, there is a space after the comma.
	$categories_list = get_the_category_list( __( ', ', 'nuviotemplates' ) );

	// Translators: used between list items, there is a space after the comma.
	$tag_list = get_the_tag_list( '', __( ', ', 'nuviotemplates' ) );

	$date = sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a>',
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() )
	);

	$author = sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_attr( sprintf( __( 'View all posts by %s', 'nuviotemplates' ), get_the_author() ) ),
		get_the_author()
	);

	// Translators: 1 is category, 2 is tag, 3 is the date and 4 is the author's name.
	if ( $tag_list ) {
		$utility_text = __( 'Posted in %1$s and tagged %2$s on %3$s<span class="by-author"> by %4$s</span>.', 'nuviotemplates' );
	} elseif ( $categories_list ) {
		$utility_text = __( 'Posted in %1$s on %3$s<span class="by-author"> by %4$s</span>.', 'nuviotemplates' );
	} else {
		$utility_text = __( 'Posted on %3$s<span class="by-author"> by %4$s</span>.', 'nuviotemplates' );
	}

	printf(
		$utility_text,
		$categories_list,
		$tag_list,
		$date,
		$author
	);
}
add_action( 'nuvio_entry_meta_action', 'nuvio_entry_meta' );

/**
Return the title of the post
*/
function nuvio_return_post ($content)
{
   $content .= 'Total '.str_word_count($content).' words';
   return $content;
}


function nuvio_setup() {
	/*
	 * Makes NuvioTemplates.com available for translation.
	 *
	 * Translations can be added to the /languages/ directory.
	 * If you're building a theme based on NuvioTemplates.com, use a find and
	 * replace to change 'nuviotemplates' to the name of your theme in all
	 * template files. 
	 */
	load_theme_textdomain( 'nuviotemplates', get_template_directory() . '/languages' ); 
  
  add_theme_support( 'post-thumbnails');          
	set_post_thumbnail_size( 200, 150 );
  
  // Adds RSS feed links to <head> for posts and comments.
	add_theme_support( 'automatic-feed-links' );
  
  register_nav_menus( array(
		'primary'   => __( 'Primary menu on the right', 'nuviodarkside' ),  		
	) );
  
  }
  
  
function nuviodarkside_content_width() {
	if ( is_attachment() && wp_attachment_is_image() ) {
		$GLOBALS['content_width'] = 980;
	}
}

add_action( 'template_redirect', 'nuviodarkside_content_width' );
add_action( 'after_setup_theme', 'nuvio_setup' );
add_action('wp_enqueue_scripts', 'nuvio_scripts_styles'); // Add Theme Stylesheet

?>