<?php // Do not delete these lines
	if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

        /*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
	return;
?>
    <?php
		/* This variable is for alternating comment background */
		$oddcomment = 'alt';
?>

<!-- You can start editing here. -->

<?php if ($comments) : ?>
	<h2 class="responses" id="comments"><?php comments_number('No Responses', 'One Response', '% Responses' );?> to &#8220;<?php the_title(); ?>&#8221;</h2> 

	<ol class="commentlist">

	<?php foreach ($comments as $comment) : ?>

		<li class="<?php echo $oddcomment; ?>" id="comment-<?php comment_ID() ?>">
			<div class="comment-avatar"><?php echo get_avatar( $comment, 45 ); ?></div>
			<div class="comment-bg">
				<p class="authorcom"><span><?php comment_author_link() ?></span> on <span><?php comment_date('F jS, Y') ?></span> said:</p>
				<div class="commentcontent">
					<?php comment_text() ?><br />
					<?php if ($comment->comment_approved == '0') : ?>
						<em>Your comment is awaiting moderation.</em>
					<?php endif; ?>
				</div>
			</div>
		</li>

	<?php /* Changes every other comment to a different class */	
		if ('alt' == $oddcomment) $oddcomment = '';
		else $oddcomment = 'alt';
	?>

	<?php endforeach; /* end for each comment */ ?>

	</ol>

 <?php else : // this is displayed if there are no comments so far ?>

  <?php if ('open' == $post->comment_status) : ?> 
		<!-- If comments are open, but there are no comments. -->
		
	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments"></p>
		
	<?php endif; ?>
<?php endif; ?>


<?php if ('open' == $post->comment_status) : ?>
<?php echo('<ul class="noscreen">') ?>
<?php wp_list_comments(); ?>
<?php echo('</ul>') ?>
<?php comment_form(); ?>
<?php paginate_comments_links() ?>


<?php endif; // if you delete this the sky will fall on your head ?>
