<?php
/**
 * Support Panel.
 *
 * @package Numinous
 */
?>
<!-- Support panel -->
<div id="support-panel" class="panel-left">
	<div class="toggle-block active">
		<h3 class="toggle-title"><?php esc_html_e( 'What is the difference between Free and Pro?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php esc_html_e( 'Both the Free and Pro version of the themes are coded well and are developed with best coding practices. However, the Pro version of the theme comes with extended features and dedicated support team to help you solve your queries. The Pro theme comes with multiple layouts to help you create a unique and attractive website. Also, the Pro themes are fully compatible with Polylang and WPML plugin to help you create a multilingual blog and get wide reach.', 'numinous' ); ?></p>
			<p><?php esc_html_e( 'Overall, you will have more control over the customization and editing of your website with the Pro version.', 'numinous' ); ?></p>
		</div>
	</div>

	<div class="toggle-block">
		<h3 class="toggle-title"><?php esc_html_e( 'What are the perks of upgrading to the Premium version?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php esc_html_e( 'Along with the additional features and regular updates, you get dedicated and quick support with the premium theme. If you run into any issue while creating a website with the premium theme, you will get a quicker response compared to the free support.', 'numinous' ); ?></p>
		</div>
	</div>	

	<div class="toggle-block">
		<h3 class="toggle-title"><?php esc_html_e( 'Upgrading to the Pro version- will I lose my changes?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php esc_html_e( 'When you upgrade to the Pro theme, your posts, pages, media, categories, and other data will remain intact-- all your data is saved.', 'numinous' ); ?></p>
			<p><?php esc_html_e( 'However, since the Pro version comes with added features and settings, you will need to set up the additional features in the customizer. This process is simple and only takes a few minutes.', 'numinous' ); ?></p>
			<p><?php esc_html_e( 'The Pro version is built with lots of flexibility in mind for future upgrades. Therefore, it is slightly different than the free theme but extremely flexible and easy-to-use.', 'numinous' ); ?></p>
		</div>
	</div>

	<div class="toggle-block">
		<h3 class="toggle-title"><?php esc_html_e( 'How do I change the copyright text?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php printf( __( 'You can change the copyright text going to %1$sAppearance > Customize > Footer Settings%2$s. However, if you want to hide the author credit text, please %3$supgrade to the Pro version%4$s.', 'numinous' ), '<b>', '</b>', '<a href="'. esc_url( 'https://rarathemes.com/wordpress-themes/numinous-pro/' ) .'" target="_blank">', '</a>' ); ?></p>
		</div>
	</div>

	<div class="toggle-block">
		<h3 class="toggle-title"><?php esc_html_e( 'Why is my theme not working well?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php esc_html_e( 'If your customizer is not loading properly or you are having issues with the theme, it might be due to the plugin conflict.', 'numinous' ); ?></p>
			<p><?php printf( __( 'To solve the issue, deactivate all the plugins first, except the ones recommended by the theme. Then, hard reload your website using %1$s"Ctrl+Shift+R"%2$s on Windows and %1$s"Cmd+Shift+R"%2$s on Mac. If the issues are fixed, start activating the plugins one by one, and reload and check your site each time. This will help you find out the plugin that is causing the problem.', 'numinous' ), '<b>', '</b>' ); ?></p>
			<p><?php printf( __( 'If this didn\'t help, please contact us via our %1$sSupport Ticket%2$s.', 'numinous' ), '<a href="'. esc_url( 'https://rarathemes.com/support-ticket/' ) .'" target="_blank">', '</a>' ); ?></p>
		</div>
	</div>

	<div class="toggle-block">
		<h3 class="toggle-title"><?php esc_html_e( 'How can I solve my issues quickly and get faster support?', 'numinous' ); ?></h3>
		<div class="toggle-content">
			<p><?php esc_html_e( 'Please ensure that you have updated to the latest version of the theme before you submit a support ticket for any issue. We might have already fixed the bug in the previous theme update.', 'numinous' ); ?></p>
			<p><?php esc_html_e( 'Also, when you submit the support ticket, please try to provide maximum details so that we can look into your issue in detail and solve it in minimum time. We recommend you to send us a screenshot(s) with issues explained and your website\'s address (URL).', 'numinous' ); ?></p>
		</div>
	</div>	
</div><!-- .panel-left support -->