<?php
function numerology_css() {
	$parent_style = 'astrocare-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'numerology-style', get_stylesheet_uri(), array( $parent_style ));
	wp_enqueue_script('numerology-custom-js', get_stylesheet_directory_uri() . '/assets/js/numerology-custom.js', array('jquery'), false, true);
	wp_enqueue_script('numerology-typed', get_stylesheet_directory_uri() . '/assets/js/numerology-typed.js', array(), true);
}
add_action( 'wp_enqueue_scripts', 'numerology_css',999);

/**
 * Import Options From Parent Theme
 *
 */
function numerology_parent_theme_options() {
	$astrocare_mods = get_option( 'theme_mods_astrocare' );
	if ( ! empty( $astrocare_mods ) ) {
		foreach ( $astrocare_mods as $astrocare_mod_k => $astrocare_mod_v ) {
			set_theme_mod( $astrocare_mod_k, $astrocare_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'numerology_parent_theme_options' );

function numerology_dynamic_style_override() {
	$numerology_brd_bg	= get_theme_mod('breadcrumb_bg_img',get_stylesheet_directory_uri() .'/assets/images/breadcrumbs-bg.png'); 
	$numerology_brd_heading	= get_theme_mod('breadcrumb_heading_img',get_stylesheet_directory_uri() .'/assets/images/breadcrumbs-heading.png');
	$numerology_output_css = "
	section.breadcrumb-area {
		background-image: url(" . esc_url($numerology_brd_bg) . ");
	}
	.breadcrumb-content {
		background-image: url(" . esc_url($numerology_brd_heading) . ");
	}";
	wp_add_inline_style( 'astrocare-style', $numerology_output_css );
}
add_action( 'wp_enqueue_scripts', 'numerology_dynamic_style_override', 20 );

add_action( 'after_setup_theme', function() {
	remove_action('astrocare_title_img_seprator','astrocare_title_img_seprator');
	add_action('astrocare_title_img_seprator','numerology_title_img_seprator');
});
function numerology_title_img_seprator(){
	$numerology_ge_title_img  = get_theme_mod('ge_title_img',get_stylesheet_directory_uri() .'/assets/images/earth-num.png');
	?>
	<img src="<?php echo esc_url($numerology_ge_title_img); ?>" alt="<?php esc_attr_e( 'Earth', 'numerology' ); ?>">
	<?php
}
require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');