<?php
$numerology_footer_copyright= get_theme_mod('footer_copyright','Copyright &copy; [current_year] [site_title] | Powered by [theme_author]');
$numerology_foo_right_desc	= get_theme_mod('footer_right_description','Privacy Policy - Terms & Conditions');
$numerology_foo_top_logo    = get_theme_mod('footer_top_logo',get_stylesheet_directory_uri() .'/assets/images/footer-logo.png');
?>
<footer class="ast_section ast_footer_wrapper bubbles_wrap">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12 col-12">
				<div class="ast_footer_top">
					<div class="ast_footer_logo footer_top_left">
						<?php if ( ! empty( $numerology_foo_top_logo ) ) : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<img src="<?php echo esc_url($numerology_foo_top_logo); ?>" alt="<?php esc_attr_e('Numerology','numerology'); ?>">
							</a>
						<?php endif; ?>
						<div class="ast_ft_copyright">
							<?php if ( ! empty( $numerology_footer_copyright ) ){ 
								$numerology_copyright_allowed_tags = array(
									'[current_year]' => date_i18n('Y'),
									'[site_title]'   => get_bloginfo('name'),
									'[theme_author]' => sprintf(
										'<a href="%s">%s</a>',
										esc_url('https://burgerthemes.com/'),
										wp_kses_post(__('Burger Software', 'numerology'))
									),
								);
								?>                          
								<div class="copyright-text">
									<?php
									echo apply_filters('numerology_footer_copyright', wp_kses_post(astrocare_str_replace_assoc($numerology_copyright_allowed_tags, $numerology_footer_copyright)));
									?>
								</div>
							<?php } ?>
						</div>
					</div>
					<div class="footer_top_right">
						<?php do_action( 'astrocare_footer_social_icon'); ?>
						<div class="ast_ft_policy">
							<?php if ( ! empty( $numerology_foo_right_desc ) ) : ?>
								<p class="py_policy"><?php echo wp_kses_post($numerology_foo_right_desc); ?></p>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>	
		</div>
		<?php if ( is_active_sidebar( 'astrocare-footer-widget-area' ) ) : ?>
			<div class="row row-cols-1 row-cols-lg-4 row-cols-md-2">
				<?php dynamic_sidebar( 'astrocare-footer-widget-area' ); ?>
			</div>
		<?php endif; ?>

		<div class="row">
			<div class="col-lg-4 col-md-12 col-12 ml-lg-auto">
				<?php do_action( 'astrocare_footer_payment_method'); ?>
			</div>
		</div>
	</div>
	<div class="footer-animation footer-animation-one">
		<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/footer-round-shape.png" alt="<?php esc_attr_e('footer-round','numerology')?>">
	</div>
	<div class="footer-animation footer-animation-two">
		<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/footer-star.png" alt="<?php esc_attr_e('footer-star','numerology')?>">
	</div>
	<div class="footer-animation footer-animation-three">
		<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/footer-shap.png" alt="<?php esc_attr_e('footer-shape','numerology')?>">
	</div>
	<div class="footer-animation-four footer-animation">
		<div class="bubbles">
			<?php for ( $numerology_foo_i = 1; $numerology_foo_i <= 70; $numerology_foo_i++ ) : 
				$numerology_size     = rand(20, 60) / 10 . 'rem';   
				$numerology_distance = rand(60, 100) / 10 . 'rem';  
				$numerology_position = rand(0, 105) . '%';          
				$numerology_time     = rand(50, 80) / 10 . 's';     
				$numerology_delay    = '-' . rand(20, 40) / 10 . 's';
				?>
				<div class="bubble" 
				style="--size:<?php echo esc_attr($numerology_size); ?>; 
				--distance:<?php echo esc_attr($numerology_distance); ?>; 
				--position:<?php echo esc_attr($numerology_position); ?>; 
				--time:<?php echo esc_attr($numerology_time); ?>; 
				--delay:<?php echo esc_attr($numerology_delay); ?>;">
				<?php echo esc_html($numerology_foo_i); ?>
			</div>
		<?php endfor; ?>
	</div>
</div>
</footer>
<button class="back-to-top" type="button"><i class="fa fa-chevron-up"></i></button>
<div class="AstroAPI-loader-body">
	<div class="AstroAPI-loader-body-inner">
		<div class="loader loader-1">
			<div class="loader-outter"></div>
			<div class="loader-inner"></div>
		</div>
	</div>
</div>
</div>
<?php wp_footer(); ?>
</body>
</html>