document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll('.ityped').forEach(el => {
    el.innerHTML = '';

    const stringsData = el.getAttribute('data-ityped-strings');
    let stringsArray = [];

    try {
      stringsArray = JSON.parse(stringsData);
    } catch (error) {
      console.error('Invalid ityped strings JSON:', error);
    }
    if (window.ityped && typeof window.ityped.init === 'function') {
      window.ityped.init(el, {
        strings: stringsArray,
        loop: true,
        typeSpeed: 100,
        backSpeed: 50,
        startDelay: 500,
        backDelay: 1000,
        showCursor: true
      });
    } else {
      console.warn('ityped is not loaded.');
    }
  });
});
