<?php

/**
 * Index posts
 */
function nuwhite_index_posts_style() {
	global $nuwhite_theme_options_settings;
   	$options = $nuwhite_theme_options_settings;
	$index_posts = $options['index_posts'];
	
	if ('show-excerpt' == $index_posts) {
	?>
		<div class="entry-content">
		<?php
				if( has_post_thumbnail() && ( is_archive() || is_home() || is_search() ) ) {
				$image = '';        			
        		$title_attribute = apply_filters( 'the_title', get_the_title() );
				$image .= '<div class="post-featured-image">';
				$image .= '<a href="' . get_permalink() . '" title="'.__( 'Permalink to ', 'nuwhite' ).the_title( '', '', false ).'">';
				$image .= get_the_post_thumbnail( get_the_ID(), 'featured-medium', array( 'title' => esc_attr( $title_attribute ), 'alt' => esc_attr( $title_attribute ) ) ).'</a>';
				$image .= '</div>';
				echo $image; 
			}
				the_excerpt();
			?>
		</div>
		<?php
	}
	
	if ('show-full-post' == $index_posts) {
	?>
	<div class="entry-content"> 
	<?php
		the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'nuwhite' ) );
	?>
	</div>
	<?php
	}
} 
add_action ('nuwhite_get_index_posts_style', 'nuwhite_index_posts_style', 10, 1);

/**
 * Custom header logo
 */
function nuwhite_custom_logo() {
	global $nuwhite_theme_options_settings;
   	$options = $nuwhite_theme_options_settings;
	$custom_logo = $options['custom_logo'];

	if ( !empty ($custom_logo) ) { ?>
		<h1 class="custom-logo-title"> 
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
				<img src="<?php echo $options[ 'custom_logo' ]; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
			</a>
		</h1>
	<?php
	} else { ?>
		<h1 class="site-title">
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>	 		
   		</h1>
	<?php 
	}

}
add_action ('nuwhite_get_custom_logo', 'nuwhite_custom_logo', 10, 1);

/**
 * Enqueue the styles for color scheme.
 */
function nuwhite_enqueue_color_scheme() {
	global $nuwhite_theme_options_settings;
   	$options = $nuwhite_theme_options_settings;
	$color_scheme = $options['color_scheme'];
	
	if ( 'white-scheme' == $color_scheme ) { 
		
	}
	
	if ( 'gray-scheme' == $color_scheme ) { 
		wp_enqueue_style( 'gray', get_template_directory_uri() . '/css/scheme/gray.css', array(), null );
	}

	if ( 'blue-scheme' == $color_scheme ) {
		wp_enqueue_style( 'blue', get_template_directory_uri() . '/css/scheme/blue.css', array(), null );
	}
		
	do_action( 'nuwhite_enqueue_color_scheme', $color_scheme );
}
add_action( 'wp_enqueue_scripts', 'nuwhite_enqueue_color_scheme' );

/**
 * Get social links
 */
function social_links() {
	global $nuwhite_theme_options_settings;
	$options = $nuwhite_theme_options_settings;
	$nuwhite_socialnetworks = '';
	$nuwhite_socialnetworks .= '<div class="social-profiles clearfix"><ul>';

	$social_links = array(); 
	$social_links_name = array();
	$social_links_name = array( __( 'Facebook', 'nuwhite' ),
								__( 'Twitter', 'nuwhite' ),
								__( 'Google Plus', 'nuwhite' ),
								__( 'Pinterest', 'nuwhite' ),
								__( 'Linkedin', 'nuwhite' ),
								__( 'Youtube', 'nuwhite' ),
								__( 'RSS', 'nuwhite' )
								);
	$social_links = array( 	'Facebook' 		=> 'social_facebook',
									'Twitter' 		=> 'social_twitter',
									'Google-Plus'	=> 'social_googleplus',
									'Pinterest'		=> 'social_pinterest',
									'Linkedin'		=> 'social_linkedin',
									'Youtube'		=> 'social_youtube',
									'RSS'				=> 'social_rss'  
								);
	
	$i=0;
	foreach( $social_links as $key => $value ) {
		if ( !empty( $options[ $value ] ) ) {
			$nuwhite_socialnetworks .=
				'<li class="'.strtolower($key).'"><a href="'. esc_url( $options[ $value ] ) .'" title="'.sprintf( esc_attr__( '%1$s on %2$s', 'nuwhite' ), get_bloginfo( 'name' ), $social_links_name[$i] ).'" target="_blank"></a></li>';
		}
		$i++;
	}		

	$nuwhite_socialnetworks .= '</ul></div> <!-- Social links -->';
	echo $nuwhite_socialnetworks;
}
add_action ('nuwhite_get_social_links', 'social_links', 10, 1);


/**
 * Google site verification
 */
function nuwhite_googlesite() { 
    
	$nuwhite_googlesite = '';
	global $nuwhite_theme_options_settings;
	$options = $nuwhite_theme_options_settings;
		if ( !empty( $options['google_verification'] ) ) {  
		$nuwhite_googlesite .= '<meta name="google-site-verification" content='.  $options[ 'google_verification' ].'>' ;
		}
	echo $nuwhite_googlesite;
}
add_action('wp_head', 'nuwhite_googlesite');

/**
 * Bing site verification
 */
function nuwhite_bingsite() { 
    
	$nuwhite_bingsite = '';
	global $nuwhite_theme_options_settings;
	$options = $nuwhite_theme_options_settings;
		if ( !empty( $options['bing_verification'] ) ) {  
		$nuwhite_bingsite .= '<meta name="ms.validate01" content='.  $options[ 'bing_verification' ].'>' ;
		}
	echo $nuwhite_bingsite;
}
add_action('wp_head', 'nuwhite_bingsite');

/**
 * Header Analytics Code
 */
function nuwhite_headercode() { 
    
	$nuwhite_headercode = '';
	global $nuwhite_theme_options_settings;
	$options = $nuwhite_theme_options_settings;
		if ( !empty( $options['header_analytics'] ) ) {  
		$nuwhite_headercode .=  $options[ 'header_analytics' ] ;
		}
	echo $nuwhite_headercode;
}
add_action('wp_head', 'nuwhite_headercode');


/**
 * Footer Analytics Code
 */
function nuwhite_footercode() { 
    
	$nuwhite_footercode = '';
	global $nuwhite_theme_options_settings;
	$options = $nuwhite_theme_options_settings;
		if ( !empty( $options['footer_analytics'] ) ) {  
		$nuwhite_footercode .=  $options[ 'footer_analytics' ] ;
		}
	echo $nuwhite_footercode;
}
add_action('wp_footer', 'nuwhite_footercode');