<?php
/**
 * The Header for Nu White theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package nuwhite
 * @since nuwhite 1.0
 */
?><!DOCTYPE html>
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/ie.css" />
<![endif]-->
	<?php wp_head(); ?>
</head>
 
<body <?php body_class(); ?>>

<div id="page" class="hfeed">
<div id="masthead" class="site-header" role="banner">

   <hgroup>
   		<?php do_action ('nuwhite_get_custom_logo'); ?>
   		<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
   </hgroup>
   <?php
		do_action ( 'nuwhite_get_social_links' ); /* Get social links from action hook */
	?>
	<?php $header_image = get_header_image();
		if( !empty( $header_image ) ) :?>
		<div class="nuwhite-header-image">
			<img src="<?php echo esc_url( $header_image ); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
		</div>
	<?php endif; ?>	
   
</div><!-- #masthead .site-header -->

   <nav role="navigation" id="access" class="site-navigation main-navigation">
   	<h5 class="menu-toggle"><a id="toggling" href="#"><?php _e( 'Menu', 'nuwhite' ); ?></a></h5>
		<div class="assistive-text skip-link"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'nuwhite' ); ?>"><?php _e( 'Skip to content', 'nuwhite' ); ?></a></div>
		<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'menu', 'menu_class' => 'menu' ) ); ?>
   </nav><!-- .site-navigation .main-navigation -->
   
<div id="main" class="site-main">