<?php
// Display on selected pages only
$wc_condition = null;
if ( current_theme_supports( 'woocommerce' ) ) {
	    if ( is_shop()         ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'shop'     );
	elseif ( is_product()      ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'product'  );
	elseif ( is_cart()         ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'cart'     );
	elseif ( is_checkout()     ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'checkout' );
	elseif ( is_account_page() ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'account'  );
	elseif ( is_product_category() || is_product_tag() ) $wc_condition = ! hoot_getchecked( 'below_sitehead_display', 'shoparchive' );
}
if ( $wc_condition !== null ) {
	if ( $wc_condition ) { return; }
} elseif (
	( ! hoot_getchecked( 'below_sitehead_display', 'home' )     && is_front_page()       ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'blog' )     && is_home()             ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'archive' )  && is_archive()          ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'posts' )    && is_singular( 'post' ) ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'pages' )    && is_singular( 'page' ) ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'search' )   && is_search()           ) ||
	( ! hoot_getchecked( 'below_sitehead_display', 'notfound' ) && is_404()              )
) { return; }

// Get Content
global $hoot_data;
hoot_set_data( 'below_sitehead_left', is_active_sidebar( 'hoot-below-sitehead-left' ) );
hoot_set_data( 'below_sitehead_right', is_active_sidebar( 'hoot-below-sitehead-right' ) );

// Template modification Hook
do_action( 'nirvata_before_below_sitehead' );

// Display Below sitehead
$hoot_below_sitehead_left = hoot_data()->below_sitehead_left || hoot_data()->below_sitehead_right;
$hoot_below_sitehead_right = hoot_data()->below_sitehead_left || hoot_data()->below_sitehead_right;
if ( !empty( $hoot_below_sitehead_left ) || !empty( $hoot_below_sitehead_right ) ) :

	$below_sitehead_grid = ( hoot_get_mod( 'below_sitehead_grid' ) == 'stretch' ) ? ' below-sitehead-stretch' : ' below-sitehead-boxed'; ?>
	<div <?php hoot_attr( 'below-sitehead', '', 'inline-nav js-search' . $below_sitehead_grid ); ?>>
		<div class="hgrid">
			<div class="hgrid-span-12">

				<div class="below-sitehead-inner<?php if ( !empty( $hoot_below_sitehead_left ) && !empty( $hoot_below_sitehead_right ) ) echo ' below-sitehead-parts'; ?>">
					<?php
					if ( $hoot_below_sitehead_left ):
						$below_siteheadid = ( $hoot_below_sitehead_right ) ? 'left' : 'center';

						// Template modification Hook
						do_action( 'nirvata_sidebar_start', 'below-sitehead-left', $below_siteheadid );
						?>

						<div id="below-sitehead-<?php echo $below_siteheadid; ?>" class="below-sitehead-part">
							<?php dynamic_sidebar( 'hoot-below-sitehead-left' ); ?>
						</div>

						<?php
						// Template modification Hook
						do_action( 'nirvata_sidebar_end', 'below-sitehead-left', $below_siteheadid );

					endif;
					?>

					<?php
					if ( $hoot_below_sitehead_right ):
						$below_siteheadid = ( $hoot_below_sitehead_left ) ? 'right' : 'center';

						// Template modification Hook
						do_action( 'nirvata_sidebar_start', 'below-sitehead-right', $below_siteheadid );
						?>

						<div id="below-sitehead-<?php echo $below_siteheadid; ?>" class="below-sitehead-part">
							<?php dynamic_sidebar( 'hoot-below-sitehead-right' ); ?>
						</div>

						<?php
						// Template modification Hook
						do_action( 'nirvata_sidebar_end', 'below-sitehead-right', $below_siteheadid );

					endif;
					?>
				</div>

			</div>
		</div>
	</div>
	<?php

endif;

// Template modification Hook
do_action( 'nirvata_after_below_sitehead' );