<?php
// Template modification Hook
do_action( 'nirvata_before_footer' );

// Get Footer Columns
$columns = nirvata_get_footer_columns();
$alphas = range('a', 'z');
$structure = nirvata_footer_structure();
$footercols = array();
$footerdisplay = array();
for ( $i=0; $i < $columns; $i++ ) {
	$footercols[ 'hoot-footer-' . $alphas[ $i ] ] = !empty( $structure[ $i ] ) ? $structure[ $i ] : '12';
	if ( is_active_sidebar( 'hoot-footer-' . $alphas[ $i ] ) )
		$footerdisplay[ 'hoot-footer-' . $alphas[ $i ] ] = true;
}
$inline_nav = ( $columns == 1 ) ? 'inlineblock-nav' : 'inlineblock-nav';

$flexstretch = hoot_get_mod( 'footer_flexstretch' );
$flexstretch = $flexstretch ? ' flexstretch-cols' : '';
$footerstyle = 'footercols-' . hoot_get_mod( 'footer' );
if ( is_customize_preview() ) :
?>

<footer <?php hoot_attr( 'footer', '', "footer hgrid-stretch {$footerstyle} {$inline_nav}{$flexstretch}" ); ?>>
	<div class="hgrid">
		<?php foreach ( array( 'hoot-footer-a', 'hoot-footer-b', 'hoot-footer-c', 'hoot-footer-d', 'hoot-footer-e', 'hoot-footer-f' ) as $check ) { ?>
			<?php $span = ( isset( $footercols[$check] ) ) ? $footercols[$check] : '12'; ?>
			<div class="<?php echo sanitize_html_class( 'hgrid-span-' . $span ) ?> footer-column" <?php if ( ! isset( $footercols[$check] ) ) echo 'style="display:none;"'; ?>>
				<?php
				if ( !empty( $footercols[$check] ) ) {
					dynamic_sidebar( $check );
				} else {
					echo '<p style="background:#eee;padding:2px 5px;border:dashed 1px;font-size:14px;line-height:20px;">';
					/* Translators: The %s are placeholders for link, so the order can't be changed. */
					echo sprintf( esc_html__('This footer column will appear once you add widgets to %1$sFooter %5$s Column%2$s in %3$swp-admin > Appearance > Widgets.%4$s', 'nirvata'), '<strong>', '</strong>', '<a href="' . esc_url( admin_url('widgets.php') ) . '" target="_blank" style="color:inherit;text-decoration:underline;font-weight:bold;">', '</a>', ucfirst( substr( $check, -1 ) ) );
					echo '</p>';
				} ?>
			</div>
		<?php } ?>
	</div>
</footer><!-- #footer -->

<?php
// Dont display if nothing to show
elseif ( !empty( $footerdisplay ) ) :
?>

<footer <?php hoot_attr( 'footer', '', "footer hgrid-stretch {$footerstyle} {$inline_nav}{$flexstretch}" ); ?>>
	<div class="hgrid">
		<?php foreach ( $footercols as $key => $span ) { ?>
			<div class="<?php echo sanitize_html_class( 'hgrid-span-' . $span ); ?> footer-column">
				<?php dynamic_sidebar( $key ); ?>
			</div>
		<?php } ?>
	</div>
</footer><!-- #footer -->

<?php
endif;

// Template modification Hook
do_action( 'nirvata_after_footer' );