<?php
/**
 * Customize for Toggle (bettertoggle), extend the WP customizer
 */

/**
 * Better Toggle Control Class extends the WP customizer
 * @property string $label
 * @property string $description
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Bettertoggle_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'bettertoggle';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Define variable to whitelist inverttoggle parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $inverttoggle = false;

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'bettertoggle' :

				hoot_customize_ctrlbox_start( $this->boxdivi, 'hoot-toggle-ctrlbox' );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs"><?php

					$value = $this->value();
					?>
					<div class="bettertogglebox">
						<input type="checkbox" value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); checked( $value ); ?> />
						<span class="<?php echo ( $this->inverttoggle ? 'bettertoggle-invert' : 'bettertoggle' ); ?>"></span>
					</div>
				</div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_bettertoggle_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'bettertoggle' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Bettertoggle_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_bettertoggle_control_interface', 10, 3 );
endif;

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_bettertoggle_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'bettertoggle' ) {
		$callback = 'hoot_sanitize_checkbox';
	}
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_bettertoggle_callback', 5, 4 );

