<?php
/**
 * Customize for Spacings, extend the WP customizer
 */

/**
 * Spacings Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string input_attrs()
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Spacings_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'spacings';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Define variable to whitelist parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $spaces = 'trbl';
	public $showlocation = true;
	public $showreset = '';
	public $allowlink = true;
	public $defaultlinked = true;
	public $allowneg = true;
	public $mediaquery = '';

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'spacings' :

				$value = $this->value();

				hoot_customize_ctrlbox_start( $this->boxdivi );

				hoot_customize_betterlabels_mediaquery(
					'spacings',
					$value,
					$this->mediaquery,
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs spacings-box" <?php if ( $this->mediaquery ) { echo 'data-multidevicevalues="true"'; } ?>><?php
					hoot_customize_betterinputs_mediaquery(
						$value,
						$this->mediaquery,
						array( $this, 'spacings_control' )
					);
					?>
					<input type="hidden" class="spacings-input" value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); ?> />
				</div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function spacings_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		// 1. Create values
		$defval = array( 't'=>'', 'r'=>'', 'b'=>'', 'l'=>'', 'linked'=>!empty($this->defaultlinked) );
		$value = $media === 'allmedia' && is_string( $value ) ? json_decode( $value, true ) : $value;
		$value = is_array( $value ) ? $value : array();
		$value = array_intersect_key( $value, $defval ); // only allow keys in defval
		$value = array_replace( $defval, $value ); // fill in missing keys with default values

		// 2. Create displayunits
		$displayunits = array(
			't' => __( 'Top', 'nirvata' ),
			'r' => __( 'Right', 'nirvata' ),
			'b' => __( 'Bottom', 'nirvata' ),
			'l' => __( 'Left', 'nirvata' ),
			'linked' => __( 'Linked', 'nirvata' ),
		);
		if ( empty( $this->showlocation ) ) {
			foreach ( $displayunits as $k => $v )
				$displayunits[$k] = '';
		} elseif ( is_array( $this->showlocation ) ) {
			foreach ( $displayunits as $k => $v )
				if ( ! empty( $this->showlocation[$k] ) && is_string( $this->showlocation[$k] ) ) $displayunits[$k] = $this->showlocation[$k];
		}

		// 3. Create reset value - non mediaquery ranges (single range)
		$showreset = isset( $this->showreset ) && is_array( $this->showreset ) ? $this->showreset : array();
		if ( ! empty( $mediaquery ) ) {
			$showreset = isset( $showreset[ $media ] ) && is_array( $showreset[ $media ] ) ? $showreset[ $media ] : array();
		}
		$showresetlinked = isset( $showreset['linked'] ) ? array( 'linked'=>$showreset['linked'] ) : array();

		// 1.2.3. minispacings
		if ( $this->spaces === 'tb' ) {
			unset( $displayunits['r'] );
			unset( $displayunits['l'] );
			unset( $value['r'] );
			unset( $value['l'] );
			$showreset = isset($showreset['t']) && isset($showreset['b']) ? array('t'=>$showreset['t'], 'b'=>$showreset['b']) : array();
		} elseif ( $this->spaces === 'rl' ) {
			unset( $displayunits['t'] );
			unset( $displayunits['b'] );
			unset( $value['t'] );
			unset( $value['b'] );
			$showreset = isset($showreset['r']) && isset($showreset['l']) ? array('r'=>$showreset['r'], 'l'=>$showreset['l']) : array();
		} else {
			$showreset = isset($showreset['t']) && isset($showreset['r']) && isset($showreset['b']) && isset($showreset['l']) ? array( 't'=>$showreset['t'], 'r'=>$showreset['r'], 'b'=>$showreset['b'], 'l'=>$showreset['l'] ) : array();
		}
		$showreset = array_merge( $showreset, $showresetlinked ); // add linked value if exists
		// 1.2. not linked
		if ( ! $this->allowlink ) {
			unset( $displayunits['linked'] );
			unset( $value['linked'] );
		}

		foreach ( $displayunits as $key => $label ) {
			$unitvalue = $value[$key];
			if ( $key == 'linked' ) {
				$checked = ! empty( $unitvalue ); ?>
				<label class="spacings-label spacings-linked">
					<input type="checkbox" value="1" <?php checked( $checked ); ?> data-space="<?php echo esc_attr( $key ); ?>" id="<?php echo sanitize_html_class("{$this->id}-{$media}-{$key}"); ?>" />
					<span class="hooticonhelp <?php if ( ! empty( $mediaquery ) ) echo 'hooticonhelp--below'; ?> dashicons dashicons-admin-links"><span class="hooticonhelptip"><span><?php esc_html_e( 'Link Values', 'nirvata' ); ?></span></span></span>
				</label>
				<?php
				continue;
			} ?>
			<label class="spacings-label spacings-<?php echo esc_attr( $key ); ?>">
				<input class="spacings-unit" type="number" value="<?php echo intval( $unitvalue ); ?>" data-space="<?php echo esc_attr( $key ); ?>" data-linkspace="<?php if ($key == 't') echo 'b'; elseif ($key == 'r') echo 'l'; elseif ($key == 'b') echo 't'; elseif ($key == 'l') echo 'r'; ?>" <?php if ( $this->allowneg ) echo 'data-allowneg="true"'; else echo 'min="0"'; ?> />
				<?php if ( ! empty( $label ) ) echo ' <span class="spacings-labeltext">' . esc_html( $label ) .'</span>'; ?>
			</label>
			<?php
		}

		if ( is_array( $showreset ) && !empty( $showreset ) ) : ?>
			<span class="better-reset hooticonhelp <?php if ( ! empty( $mediaquery ) ) echo 'hooticonhelp--below'; ?> dashicons dashicons-update" data-resetval="<?php echo esc_attr( json_encode( $showreset ) ) ?>"><span class="hooticonhelptip"><span><?php esc_html_e( 'Reset', 'nirvata' ); ?></span></span></span><?php
		endif;
	}

}
endif;

/**
 * Modify the settings array and prepare sortlist settings
 */
function hoot_customize_prepare_spacings_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'spacings':
			if ( isset( $setting['default'] ) && is_array( $setting['default'] ) )
				$setting['default'] = json_encode( $setting['default'] );
			$value[ $key ] = $setting;
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'spacings' ) ) ) {
							if ( isset( $varray['default'] ) && is_array( $varray['default'] ) )
								$value[$vkey]['default'] = json_encode( $varray['default'] );
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_spacings_settings', 15, 4 );

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_spacings_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'spacings' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Spacings_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_spacings_control_interface', 10, 3 );
endif;

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_spacings_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'spacings' ) {
		$callback = 'hoot_sanitize_jsonstring';
	}
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_spacings_callback', 5, 4 );

/**
 * Utility function to create css strig
 * Formatted for use by Hoot_Style_Builder->add_cssvars()
 * @return array|string
 */
function hoot_spacings_css( $rawvalue ) {
	$rawvalue = is_string( $rawvalue ) ? json_decode( $rawvalue, true ) : $rawvalue;
	$rawvalue = is_array( $rawvalue ) ? $rawvalue : array();
	// default fallback (if not explicitly set to 'on') is always 'off' i.e. seperate medias
	$alldevices = empty( $rawvalue['alldevices'] ) || $rawvalue['alldevices'] !== 'on' ? 'off' : 'on';

	if ( isset( $rawvalue['desktop'] ) || isset( $rawvalue['tablet'] ) || isset( $rawvalue['mobile'] ) ) {
		$css = array();
		foreach ( $rawvalue as $device => $valarray ) { if ( is_array( $valarray ) ) {
			$value = '';
			foreach ( array( 't','r','b','l' ) as $k ) {
				$value .= isset( $valarray[$k] ) ? intval( $valarray[$k] ) . 'px ' : '0 ';
			}
			$css[ $device ] = $value;
		} }
		if ( $alldevices === 'on' ) {
			$css = isset( $css['desktop'] ) ? $css['desktop'] : '';
		}
	} else {
		$css = '';
			foreach ( array( 't','r','b','l' ) as $k ) {
				$css .= isset( $valarray[$k] ) ? intval( $valarray[$k] ) . 'px ' : '0 ';
			}
	}
	return $css;
}
