<?php
/**
 * Customize for Range (betterrange), extend the WP customizer
 */

/**
 * Better Range Control Class extends the WP customizer
 * @property string $label
 * @property string $description
 * @method string input_attrs()
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Betterrange_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'betterrange';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Define variable to whitelist parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $displaysuffix = '';
	public $showreset = '';
	public $mediaquery = '';
	public $input_attrs = array();

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'betterrange' :

				$value = $this->value();

				hoot_customize_ctrlbox_start( $this->boxdivi );

				hoot_customize_betterlabels_mediaquery(
					'betterrange',
					$value,
					$this->mediaquery,
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs betterrange-box"><?php
					hoot_customize_betterinputs_mediaquery(
						$value,
						$this->mediaquery,
						array( $this, 'betterrange_control' )
					);
					?>
					<input type="hidden" class="betterrange-input" value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); ?> />
				</div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function betterrange_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		// Create reset value - non mediaquery ranges (single range)
		$showreset = isset( $this->showreset ) ? $this->showreset : false;
		// Create reset value - mediaquery ranges (desktop, tablet, mobile)
		if ( ! empty( $mediaquery ) ) {
			$showreset = is_array( $showreset ) && isset( $showreset[ $media ] ) ? $showreset[ $media ] : false;
		}
		?>
		<input class="betterrange-range" type="range" value="<?php echo esc_attr( $value ); ?>" <?php $this->input_attrs(); ?> />
		<input class="betterrange-number" type="number" value="<?php echo esc_attr( $value ); ?>" <?php
			if ( !empty( $this->input_attrs ) && is_array( $this->input_attrs ) )
				foreach ( array( 'step' ) as $attr )
					if ( isset( $this->input_attrs[ $attr ] ) )
						echo $attr . '="' . esc_attr( $this->input_attrs[ $attr ] ) . '" ';
			?> />
		<?php if ( ! empty( $this->displaysuffix ) ) echo ' <span class="betterrange-suffix">' . esc_html( $this->displaysuffix ) .'</span>'; ?>
		<?php if ( is_numeric( $showreset )  ) : ?>
			<span class="better-reset hooticonhelp <?php if ( ! empty( $mediaquery ) ) echo 'hooticonhelp--below'; ?> dashicons dashicons-update" data-resetval="<?php echo esc_attr( floatval( $showreset ) ) ?>"><span class="hooticonhelptip"><span><?php esc_html_e( 'Reset', 'nirvata' ); ?></span></span></span>
		<?php endif; ?>
		<?php
	}

}
endif;

/**
 * Modify the settings array and prepare sortlist settings
 */
function hoot_customize_prepare_betterrange_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'betterrange':
			if ( isset( $setting['default'] ) && is_array( $setting['default'] ) )
				$setting['default'] = json_encode( $setting['default'] );
			$value[ $key ] = $setting;
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'betterrange' ) ) ) {
							if ( isset( $varray['default'] ) && is_array( $varray['default'] ) )
								$value[$vkey]['default'] = json_encode( $varray['default'] );
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_betterrange_settings', 15, 4 );

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_betterrange_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'betterrange' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Betterrange_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_betterrange_control_interface', 10, 3 );
endif;

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_betterrange_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'betterrange' ) {
		$callback = !empty( $setting['mediaquery'] ) ? 'hoot_sanitize_jsonstring' : 'hoot_sanitize_range';
	}
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_betterrange_callback', 5, 4 );

/**
 * Utility function to create css strig
 * Formatted for use by Hoot_Style_Builder->add_cssvars()
 * @return array|string
 */
function hoot_betterrange_css( $rawvalue, $suffix='' ) {
	$rawvalue = is_string( $rawvalue ) ? json_decode( $rawvalue, true ) : $rawvalue;
	$rawvalue = is_array( $rawvalue ) ? $rawvalue : array();
	// default fallback (if not explicitly set to 'on') is always 'off' i.e. seperate medias
	$alldevices = empty( $rawvalue['alldevices'] ) || $rawvalue['alldevices'] !== 'on' ? 'off' : 'on';

	if ( isset( $rawvalue['desktop'] ) || isset( $rawvalue['tablet'] ) || isset( $rawvalue['mobile'] ) ) {
		$css = array();
		foreach ( $rawvalue as $device => $value ) {
			if ( $device === 'alldevices' ) continue;
			$value = floatval( $value );
			$css[ $device ] = $value || $value == 0 ? $value . $suffix : '';
		}
		if ( $alldevices === 'on' ) {
			$css = isset( $css['desktop'] ) ? $css['desktop'] : '';
		}
	} else {
		// This function does not handle non mediaquery values
		$css = '';
	}
	return $css;
}
