<?php
/**
 * Customize for Preset Patterns (betterbackground), extend the WP customizer
 */

/**
 * Betterbackground Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Betterbackground_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'betterbackground';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Define variable to whitelist background parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $background = '';

	/**
	 * Define variable to whitelist identifier parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $identifier = '';

	/**
	 * Define variable to whitelist options parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $options = '';

	/**
	 * Renders the control wrapper and calls $this->render_content() for the internals.
	 * Add extra class names
	 *
	 * @since 3.0.0
	 */
	protected function render() {
		$id    = 'customize-control-' . str_replace( array( '[', ']' ), array( '-', '' ), $this->id );
		$class = 'customize-control customize-control-' . $this->type . ' hoot-customize-control-' . $this->type . $this->background;
		if ( !empty( $this->identifier ) )
			$class .= ' hoot-control-id-' . $this->identifier;

		printf( '<li id="%s" class="%s">', esc_attr( $id ), esc_attr( $class ) );
		$this->render_content();
		echo '</li>';
	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'betterbackground' :

				switch ( $this->background ) {

					case 'button' :
						if (
							empty( $this->options ) ||
							( is_array( $this->options ) && in_array( 'image', $this->options ) && in_array( 'pattern', $this->options ) )
							):
							?><div class="hoot-betterinputs"><?php

								$value = $this->value();
								$value = ( empty( $value ) ) ? 'predefined' : $value;
								?>
								<div class="hoot-betterbackground-buttons">
									<span class="button hoot-betterbackground-button hoot-betterbackground-button-predefined <?php if ( 'predefined' == $this->value() ) echo 'selected'; else echo 'deactive'; ?>" data-value="predefined"><?php esc_html_e( 'Pattern', 'nirvata' ); ?></span><span class="button hoot-betterbackground-button hoot-betterbackground-button-custom <?php if ( 'custom' == $this->value() ) echo 'selected'; else echo 'deactive'; ?>" data-value="custom"><?php esc_html_e( 'Custom Image', 'nirvata' ); ?></span>
								</div>
								<input class="hoot-customize-control-betterbackground" value="<?php echo esc_attr( $this->value() ) ?>" <?php $this->link(); ?> type="hidden"/>
							</div><?php
						endif;
					break;

					case 'start' :

						hoot_customize_ctrlbox_start( $this->boxdivi );

						hoot_customize_betterlabels_mediaquery(
							$this->type,
							'', // value
							false, // mediaquery
							$this->label,
							$this->description,
							$this->betooltip
						);

						hoot_customize_ctrlbox_end();

					break;

					case 'end' :
					break;

				}

				break;

		}

	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_betterbackground_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'betterbackground' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Betterbackground_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_betterbackground_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array and prepare betterbackground settings for Customizer Library Interface functions
 *
 * @since 3.0.0
 * @param array $value
 * @param string $key
 * @param array $setting
 * @param int $count
 * @return void
 */
function hoot_customize_prepare_betterbackground_settings( $value, $key, $setting, $count ) {

	if ( $setting['type'] == 'betterbackground' ) {

		$setting = wp_parse_args( $setting, array(
			'label'       => '',
			'boxdivi'     => true,
			'betooltip'   => '',
			'section'     => '',
			'priority'    => '',
			'choices'     => hoot_enum_background_pattern(),
			'default'     => array(),
			'description' => '',
			'options'     => array( 'image', 'color', 'repeat', 'position', 'attachment', 'pattern', 'size' ),
			'overlay'     => false,
			'overlayblend'=> true,
			'identifier'  => $key,
			) );
		$setting['default'] = wp_parse_args( $setting['default'], array(
			'type'       => 'predefined',
			'color'      => '',
			'image'      => '',
			'repeat'     => 'repeat',
			'position'   => 'top center',
			'attachment' => 'scroll',
			'pattern'    => '0',
			'size'       => 'original',
			'overlay'    => '#ffffff00', // default transparent
			'overlayblend' => 1,
			) );

		if ( is_array( $setting['options'] ) && !empty( $setting['options'] ) ):
			$color = in_array( 'color', $setting['options'] );
			$image = in_array( 'image', $setting['options'] );
			$repeat = in_array( 'repeat', $setting['options'] );
			$position = in_array( 'position', $setting['options'] );
			$attachment = in_array( 'attachment', $setting['options'] );
			$pattern = ( in_array( 'pattern', $setting['options'] ) && !empty( $setting['choices'] ) );
			$size = in_array( 'size', $setting['options'] );
			$overlay = !empty( $setting['overlay'] ) ? true : false;
			$overlayblend = !empty( $setting['overlayblend'] ) ? true : false;
			$acb = isset( $setting['active_callback'] ) ? $setting['active_callback'] : false;
			$transport = isset( $setting['transport'] ) ? $setting['transport'] : false;

			$colorattop = $color && ( !isset( $setting['circleswatch'] ) || !empty( $setting['circleswatch'] ) ) ? true : false;
			$colorattop = false;

			if ( $color || $image || $pattern ):

				// Betterbackground Start
				$value[ "betterbackground-{$count}" ] = ! $colorattop ? array(
					'label'       => $setting['label'],
					'betooltip'   => $setting['betooltip'],
					'description' => $setting['description'],
				) : array();
				$value[ "betterbackground-{$count}" ] = array_merge( $value[ "betterbackground-{$count}" ], array(
					'boxdivi'     => $setting['boxdivi'],
					'section'     => $setting['section'],
					'type'        => 'betterbackground',
					'priority'    => $setting['priority'],
					'identifier'  => $setting['identifier'],
					'background'  => 'start',
				) );
				if ( $acb ) { $value[ "betterbackground-{$count}" ]['active_callback'] = $acb; }

				// Background Color :: (priority & section same as betterbackground)
				if ( $color ) :
					$value[ "{$key}-color" ] = $colorattop ? array(
						'label'       => $setting['label'],
						'betooltip'   => $setting['betooltip'],
						'description' => $setting['description'],
					) : array(
						'label'       => __( 'Background Color', 'nirvata' ),
					);
					$value[ "{$key}-color" ] = array_merge( $value[ "{$key}-color" ], array(
						'boxdivi'     => false,
						'section'     => $setting['section'],
						'type'        => 'bettercolor',
						'circleswatch'=> isset( $setting['circleswatch'] ) ? $setting['circleswatch'] : true,
						'hasalpha'    => isset( $setting['hasalpha'] ) ? $setting['hasalpha'] : false,
						'priority'    => $setting['priority'],
						'default'     => $setting['default']['color'],
					) );
					if ( $acb ) { $value[ "{$key}-color" ]['active_callback'] = $acb; }
					if ( $transport ) { $value[ "{$key}-color" ]['transport'] = $transport; }

				endif;

				// Background Type Button
				if ( $image && $pattern ) :

					$value[ "{$key}-type" ] = array(
						'section'     => $setting['section'],
						'type'        => 'betterbackground',
						'priority'    => $setting['priority'],
						'default'     => $setting['default']['type'],
						'identifier'  => $setting['identifier'],
						'background'  => 'button',
					);
					if ( $acb ) { $value[ "{$key}-type" ]['active_callback'] = $acb; }
					if ( $transport ) { $value[ "{$key}-type" ]['transport'] = $transport; }

				endif;

				// Background Image :: (priority & section same as betterbackground)
				if ( $image ) :

					$value[ "{$key}-image" ] = array(
						'section'     => $setting['section'],
						'type'        => 'image',
						'priority'    => $setting['priority'],
						'default'     => $setting['default']['image'],
					);
					if ( $acb ) { $value[ "{$key}-image" ]['active_callback'] = $acb; }
					if ( $transport ) { $value[ "{$key}-image" ]['transport'] = $transport; }

					if ( $size ) {
						$value[ "{$key}-size" ] = array(
							'boxdivi'     => false,
							'section'     => $setting['section'],
							'type'        => 'select',
							'priority'    => $setting['priority'],
							'choices'     => hoot_enum_background_size(),
							'default'     => $setting['default']['size'],
						);
						if ( $acb ) { $value[ "{$key}-size" ]['active_callback'] = $acb; }
						if ( $transport ) { $value[ "{$key}-size" ]['transport'] = $transport; }
					}

					if ( $attachment ) {
						$value[ "{$key}-attachment" ] = array(
							'boxdivi'     => false,
							'section'     => $setting['section'],
							'type'        => 'select',
							'priority'    => $setting['priority'],
							'choices'     => hoot_enum_background_attachment(),
							'default'     => $setting['default']['attachment'],
						);
						if ( $acb ) { $value[ "{$key}-attachment" ]['active_callback'] = $acb; }
						if ( $transport ) { $value[ "{$key}-attachment" ]['transport'] = $transport; }
					}

					if ( $repeat ) {
						$value[ "{$key}-repeat" ] = array(
							'boxdivi'     => false,
							'section'     => $setting['section'],
							'type'        => 'select',
							'priority'    => $setting['priority'],
							'choices'     => hoot_enum_background_repeat(),
							'default'     => $setting['default']['repeat'],
						);
						if ( $acb ) { $value[ "{$key}-repeat" ]['active_callback'] = $acb; }
						if ( $transport ) { $value[ "{$key}-repeat" ]['transport'] = $transport; }
					}

					if ( $position ) {
						$value[ "{$key}-position" ] = array(
							'boxdivi'     => false,
							'section'     => $setting['section'],
							'type'        => 'select',
							'priority'    => $setting['priority'],
							'choices'     => hoot_enum_background_position(),
							'default'     => $setting['default']['position'],
						);
						if ( $acb ) { $value[ "{$key}-position" ]['active_callback'] = $acb; }
						if ( $transport ) { $value[ "{$key}-position" ]['transport'] = $transport; }
					}

				endif;

				// Background Patterns :: (priority & section same as betterbackground)
				if ( $pattern ) :

					// Group Start
					$value[ "group-{$count}-p" ] = array(
						'boxdivi'     => false,
						'section'     => $setting['section'],
						'type'        => 'group',
						'priority'    => $setting['priority'],
						'button'      => '<span class="hoot-betterbackground-button-pattern"></span>' . __( 'Select Pattern', 'nirvata' ),
						'identifier'  => $key . '-patterns',
						'group'       => 'start',
					);
					if ( $acb ) { $value[ "group-{$count}-p" ]['active_callback'] = $acb; }

					// Pattern Images
					$value[ "{$key}-pattern" ] = array(
						'boxdivi'     => false,
						'section'     => $setting['section'],
						'type'        => 'radioimage',
						'priority'    => $setting['priority'],
						'choices'     => $setting['choices'],
						'default'     => $setting['default']['pattern'],
					);
					if ( $acb ) { $value[ "{$key}-pattern" ]['active_callback'] = $acb; }
					if ( $transport ) { $value[ "{$key}-pattern" ]['transport'] = $transport; }
					if ( apply_filters( 'hoot_customize_pattern_pnote', false ) ) {
						$value[ "{$key}-pnote" ] = array(
							'section'     => $setting['section'],
							'type'        => 'content',
							'class'       => 'hootnote hootnote--us',
							'priority'    => $setting['priority'],
							'content'     => esc_html__( 'Premium version comes with a much bigger curated collection of patterns.', 'nirvata' ),
						);
					}

					// Group End
					$value[ "group-{$count}-p-end" ] = array(
						'section'     => $setting['section'],
						'type'        => 'group',
						'priority'    => $setting['priority'],
						'identifier'  => $key . '-patterns',
						'group'       => 'end',
					);
					if ( $acb ) { $value[ "group-{$count}-p-end" ]['active_callback'] = $acb; }

				endif;

				if ( $overlay ) :
					$olysettings = is_array( $setting['overlay'] ) ? $setting['overlay'] : array();
					$value[ "{$key}-overlay" ] = array(
						'label' => isset( $olysettings['label'] ) ? $olysettings['label'] : __( 'Image Overlay Color', 'nirvata' ),
						'boxdivi'     => isset( $olysettings['boxdivi'] ) ? $olysettings['boxdivi'] : false,
						'betooltip'   => isset( $olysettings['betooltip'] ) ? $olysettings['betooltip'] : sprintf( __( 'Select an overlay color for the background image or pattern.%1$sUse opacity to adjust its intensity.', 'nirvata' ), '<hr>' ),
						'description' => isset( $olysettings['description'] ) ? $olysettings['description'] : '',
						'section'     => $setting['section'],
						'type'        => 'color',
						'circleswatch'=> isset( $olysettings['circleswatch'] ) ? $olysettings['circleswatch'] : true,
						'hasalpha'    => true,
						'priority'    => $setting['priority'],
						'default'     => $setting['default']['overlay'],
					);
					if ( $acb ) { $value[ "{$key}-overlay" ]['active_callback'] = $acb; }
					if ( $transport ) { $value[ "{$key}-overlay" ]['transport'] = $transport; }
					if ( $overlayblend ) :
						$value[ "{$key}-overlayblend" ] = array(
							'label' => __( 'Blend Overlay Color', 'nirvata' ),
							'betooltip'   => sprintf( __( '%1$sTIP:%2$s Color blending would %1$snot%2$s work for pure black/white colors!', 'nirvata' ), '<strong>', '</strong>' ),
							'boxdivi'     => 'div-ve10',
							'section'     => $setting['section'],
							'type'        => 'checkbox',
							'priority'    => $setting['priority'],
							'default'     => $setting['default']['overlayblend'],
						);
						if ( $acb ) { $value[ "{$key}-overlayblend" ]['active_callback'] = $acb; }
						if ( $transport ) { $value[ "{$key}-overlayblend" ]['transport'] = $transport; }
					endif;
				endif;

				// Betterbackground End
				$value[ "betterbackground-{$count}-end" ] = array(
					'section'     => $setting['section'],
					'type'        => 'betterbackground',
					'priority'    => $setting['priority'],
					'identifier'  => $setting['identifier'],
					'background'  => 'end',
				);
				if ( $acb ) { $value[ "betterbackground-{$count}-end" ]['active_callback'] = $acb; }

			endif;
		endif;

	}

	return $value;

}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_betterbackground_settings', 10, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_betterbackground_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'betterbackground' && isset( $setting['background'] ) && $setting['background'] == 'button' )
		$callback = 'hoot_sanitize_background_type';
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_betterbackground_callback', 5, 4 );