<?php
/**
 * General function to display helper elements
 */

if ( ! function_exists( 'hoot_customize_display_help' ) ) :
function hoot_customize_display_help( $help, $betooltip = '' ) {
	if ( is_string( $help ) && ! empty( $help ) ) {
		echo '<span class="description customize-control-description">';
			echo wp_kses_post( $help );
			if ( function_exists( 'hoot_customize_display_betooltip' ) && !empty( $betooltip ) ) { hoot_customize_display_betooltip( $betooltip ); }
		echo '</span>';
	}
}
endif;

if ( ! function_exists( 'hoot_customize_display_betooltip' ) ) :
function hoot_customize_display_betooltip( $betooltip ) {
	if ( empty( $betooltip ) )
		return;
	$icon = '';
	$text = '';
	$class = '';
	$desctip = '';
	if ( is_string( $betooltip ) ) {
		$text = $betooltip;
	} elseif ( is_array( $betooltip ) ) {
		$icon  = !empty( $betooltip[0] ) && is_string( $betooltip[0] ) ? $betooltip[0] : '';
		$text  = !empty( $betooltip[1] ) && is_string( $betooltip[1] ) ? $betooltip[1] : '';
		$class = !empty( $betooltip['invert'] ) ? ' hoot-betooltip-boxinvert ' : '';
		$desctip = !empty( $betooltip['desctip'] ) && is_string( $betooltip['desctip'] ) ? $betooltip['desctip'] : '';
	}
	if ( ! empty( $text ) ) {
		$icon = in_array( $icon, array( 'info', 'help', 'tip', 'alert' ) ) ? $icon : 'info';
		echo '<span class="hoot-betooltip-box hoot-betooltip-' . esc_attr( $icon ) . ' ' . hoot_sanitize_html_classes( $class ) . '">';
			if ( $icon === 'alert' ) {
				echo '<span class="hoot-betooltip-icon dashicons dashicons-bell"></span> ';
			} elseif ( $icon === 'tip' ) {
				echo '<span class="hoot-betooltip-icon dashicons dashicons-edit-page"></span> ';
			} else {
				echo '<span class="hoot-betooltip-icon dashicons dashicons-editor-help"></span> ';
			}
			echo '<span class="hoot-betooltip' . ( esc_html( $text ) !== $text ? ' hoot-betooltip-interactive' : '' ) . '"><span class="hoot-betooltip-text">' . wp_kses_post( $text ) . '</span></span>';
		echo '</span>';
	} elseif ( ! empty( $desctip ) ) {
		if ( $desctip === 'info' || $desctip === 'help' ) {
			echo '<span class="hoot-bedesctip hoot-bedesctip-info">' . ucfirst( $desctip ) . '</span> ';
		}
	}
}
endif;

if ( ! function_exists( 'hoot_customize_ctrlbox_start' ) ) :
function hoot_customize_ctrlbox_start( $boxdivi = true, $classes = '', $atts = array() ) {
	$classes = !empty( $classes ) && is_string( $classes ) ? $classes : '';
	$boxdivi = $boxdivi === true ? 'divstd' : $boxdivi;
	$boxdivi = in_array( $boxdivi, array( 'divbig', 'divstd', 'div-ve10', 'div-ve15', 'div-ve20' ) ) ? 'hoot-' . $boxdivi : '';
	$atts_html = '';
	if ( is_array( $atts ) && ! empty( $atts ) ) {
		foreach ( $atts as $att => $val ) {
			$atts_html .= is_string( $att ) && ! empty( $att ) && is_string( $val ) && ! empty( $val ) ? ' ' . esc_attr( $att ) . '="' . esc_attr( $val ) . '"' : '';
		}
	}
	if ( $classes )
		echo '<div class="hoot-ctrlbox ' . esc_attr($boxdivi) . ' ' . hoot_sanitize_html_classes( $classes ) . '"' . $atts_html . '>';
	else
		echo '<div class="hoot-ctrlbox ' . esc_attr($boxdivi) . '"' . $atts_html . '>';
}
endif;

if ( ! function_exists( 'hoot_customize_ctrlbox_end' ) ) :
function hoot_customize_ctrlbox_end() {
	echo '<div class="clear"></div>';
	echo '</div>';
}
endif;

if ( ! function_exists( 'hoot_customize_mediaquery' ) ) :
function hoot_customize_mediaquery( $value ) {
		$mediavalues = is_string( $value ) ? json_decode( $value, true ) : $value;
		$mediavalues = is_array( $mediavalues ) ? $mediavalues : array();
		// default fallback (if not explicitly set to 'on') is always 'off' i.e. seperate medias
		$alldevices = empty( $mediavalues['alldevices'] ) || $mediavalues['alldevices'] !== 'on' ? 'off' : 'on';

	$alldeviceschecked = checked( 'on', $alldevices, false );
	$return = '';
	$return .= '<span class="hoot-mediaswitcher hoot-has-alldevices hoot-alldevices-' . ( $alldeviceschecked ? 'on' : 'off' ) . '">';
		$return .= '<i title="' . esc_attr__( 'Desktop', 'nirvata' ) . '" data-alldevices="' . ( $alldeviceschecked ? 'on' : 'off' ) . '" data-device="desktop" class="dashicons dashicons-desktop hootactive"></i>';
		$return .= '<i title="' . esc_attr__( 'Tablet', 'nirvata' ) .  '" data-alldevices="' . ( $alldeviceschecked ? 'on' : 'off' ) . '" data-device="tablet"  class="dashicons dashicons-tablet"></i>';
		$return .= '<i title="' . esc_attr__( 'Mobile', 'nirvata' ) .  '" data-alldevices="' . ( $alldeviceschecked ? 'on' : 'off' ) . '" data-device="mobile"  class="dashicons dashicons-smartphone"></i>';
		$return .= '<input class="hoot-mediaquery-alldevices-checkbox" type="checkbox" value="on" ' . $alldeviceschecked . ' />';
		$return .= '<i title="' . esc_attr__( 'All Devices', 'nirvata' ) .  '" class="hoot-mediaquery-alldevices-btn dashicons hooticonhelp">' . '<span class="hooticonhelptip hoot-mediaquery-alldevices-offtip"><span>' . esc_html__( 'Cancel to use the same value on all devices', 'nirvata' ) . '</span></span>' . '<span class="hooticonhelptip hoot-mediaquery-alldevices-ontip"><span>' . esc_html__( 'Use different values for mobile view', 'nirvata' ) . '</span></span>' . '</i>';
	$return .= '</span>';
	return $return;
}
endif;

if ( ! function_exists( 'hoot_customize_betterlabels_mediaquery' ) ) :
function hoot_customize_betterlabels_mediaquery( $context, $value, $mediaquery, $label='', $description='', $betooltip=array() ) {
	$haslabel = ! empty( $label );
	$hasdesc = ! empty( $description ) ;
	$hasmediaquery = ! empty( $mediaquery ) ? hoot_customize_mediaquery( $value ) : false;

	if ( $haslabel || $hasdesc || $hasmediaquery ) :
		?><div class="hoot-betterlabels<?php if ( $hasmediaquery ) echo ' hoot-labels-mediaquery-wrap'; ?>"><?php
			if ( $haslabel ) {
				if ( $hasmediaquery ) echo '<div class="hoot-control-mediaquery-wrap">';
					if ( $haslabel ) :
						echo '<span class="customize-control-title">';
							echo esc_html( $label );
							if ( function_exists( 'hoot_customize_display_betooltip' ) && !empty( $betooltip ) ) { hoot_customize_display_betooltip( $betooltip ); }
						echo '</span>';
					endif;
					if ( $hasmediaquery ) echo $hasmediaquery;
				if ( $hasmediaquery ) echo '</div>';
			}

			if ( $hasdesc ) {
				if ( $hasmediaquery && ! $haslabel ) echo '<div class="hoot-control-mediaquery-wrap">';
					$betooltip = !$haslabel ? $betooltip : '';
					if ( function_exists( 'hoot_customize_display_help' ) && !empty( $description ) ) { hoot_customize_display_help( $description, $betooltip ); }
					if ( $hasmediaquery && ! $haslabel ) echo $hasmediaquery;
				if ( $hasmediaquery && ! $haslabel ) echo '</div>';
			}

			if ( ! $haslabel && ! $hasdesc && $hasmediaquery ) {
				echo '<div class="hoot-control-mediaquery-wrap"><span></span>';
				echo $hasmediaquery;
				echo '</div>';
			}
		?></div><?php
	endif;
}
endif;

if ( ! function_exists( 'hoot_customize_betterinputs_mediaquery' ) ) :
function hoot_customize_betterinputs_mediaquery( $value, $mediaquery, $callback, $args=array(), $wrapsingle=true ) {
	if ( ! empty( $mediaquery ) ) {
		$looparray = array( 'desktop', 'tablet', 'mobile' );
		$mediavalues = is_string( $value ) ? json_decode( $value, true ) : $value;
		$mediavalues = is_array( $mediavalues ) ? $mediavalues : array();
		// default fallback (if not explicitly set to 'on') is always 'off' i.e. seperate medias
		$alldevices = empty( $mediavalues['alldevices'] ) || $mediavalues['alldevices'] !== 'on' ? 'off' : 'on';

		foreach ( $looparray as $media ) {
			$mediavalue = isset( $mediavalues[ $media ] ) ? $mediavalues[ $media ] : '';
			$boxdisplay = $media === 'desktop' ? '' : 'display:none';
			echo '<div class="hoot-mcallwrap hoot-mediabox" style="' . esc_attr( $boxdisplay ) . '" data-device="' . esc_attr( $media ) . '" data-alldevices="' . esc_attr( $alldevices ) . '">';
				$callback( $mediavalue, $media, $mediaquery, $args );
			echo '</div>';
		}

	} else {
		if ( $wrapsingle ) echo '<div class="hoot-mcallwrap hoot-singlemedia">';
			$callback( $value, 'allmedia', false, $args );
		if ( $wrapsingle ) echo '</div>';
	}

}
endif;
