<?php
/**
 * Customize for Betterfontgroup, extend the WP customizer
 */

if ( ! apply_filters( 'hoot_support_customize_control_betterfont', true ) ) return;

/**
 * Betterfontgroup Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Betterfontgroup_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'betterfontgroup';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;
	public $defaultvalue = array();
	public $showenable = true;
	public $options = array();
	public $showreset = array();

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'betterfontgroup':
				$options   = is_array( $this->options )   ? $this->options   : array();
				$showreset = is_array( $this->showreset ) ? $this->showreset : array();

				$this->showreset = array();
				$this->defaultvalue = is_array( $this->defaultvalue ) ? $this->defaultvalue : array();
				foreach ( $showreset as $key ) {
					if ( isset( $this->defaultvalue[$key] ) )
						$this->showreset[$key] = $this->defaultvalue[$key];
				}

				$rawvalue = $this->value();
				$value = is_string( $rawvalue ) ? json_decode( $rawvalue, true ) : $rawvalue;
				$value = is_array( $value ) ? $value : array();

				$class = 'hoot-betterfontgroup-ctrlbox';
				$class .= $this->showenable ? ' hoot-toggle-ctrlbox' : '';
				hoot_customize_ctrlbox_start( $this->boxdivi, $class );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				if ( $this->showenable ) :
					$ctrlval = ! empty( $value['enable'] );
					?><div class="hoot-betterinputs">
						<div class="bettertogglebox">
							<input type="checkbox" value="1" name="enable" <?php checked( $ctrlval ); ?> />
							<span class="bettertoggle"></span>
						</div>
					</div><?php
				endif;

				?><input type="hidden" class="betterfontgroup-input" value="<?php echo esc_attr( $rawvalue ); ?>" <?php $this->link(); ?> /><?php

				hoot_customize_ctrlbox_end();

				echo '<div class="hoot-betterfontgroup-popup">';

				foreach ( $options as $opid => $opsettings ) {
					$opvalue = isset( $value[$opid] ) ? $value[$opid] : '';
					$choices = isset( $opsettings['choices'] ) && is_array( $opsettings['choices'] ) ? $opsettings['choices'] : array();

					foreach ( array( 'size' ) as $ctrl ) {
						if ( in_array( $ctrl, $choices ) ):
							$mediaquery = !empty( $opsettings['mediaquery'] );
							$ctrlval = isset( $opvalue[$ctrl] ) ? $opvalue[$ctrl] : '';
							$ctrllabel = '';
							$ctrldescription = '';
							$ctrlbetooltip = '';
							if ( isset( $opsettings['labels'] ) && is_array( $opsettings['labels'] ) ) {
								$ctrllabel = isset( $opsettings['labels'][0] ) ? $opsettings['labels'][0] : '';
								$ctrldescription = isset( $opsettings['labels'][1] ) ? $opsettings['labels'][1] : '';
								$ctrlbetooltip = isset( $opsettings['labels'][2] ) ? $opsettings['labels'][2] : '';
							} elseif ( isset( $opsettings['labels'] ) && is_string( $opsettings['labels'] ) ) {
								$ctrllabel = $opsettings['labels'];
							}
							$displaysuffix = 'px';
							$min = 5; $max = 125; $step = 1;
							hoot_customize_ctrlbox_start( false, 'betterfontgroup-range-ctrlbox' );
							hoot_customize_betterlabels_mediaquery(
								'betterfontgroup-' . $ctrl,
								$ctrlval,
								$mediaquery,
								$ctrllabel,
								$ctrldescription,
								$ctrlbetooltip
							);
							?><div class="hoot-betterinputs betterrange-box"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									$mediaquery,
									array( $this, 'betterrange_control' ),
									array( 'ctrl' => $ctrl, 'opid' => $opid, 'displaysuffix' => $displaysuffix, 'min' => $min, 'max' => $max, 'step' => $step )
								);
								?>
								<input type="hidden" class="betterrange-input betterfontgroup-range-input" value="<?php echo esc_attr( json_encode( $ctrlval ) ); ?>" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>" data-opid="<?php echo esc_attr( $opid ); ?>" />
							</div><?php
							hoot_customize_ctrlbox_end();
						endif;
					}
				}

				echo '</div>'; // .hoot-betterfontgroup-popup

			break;

		}

	}

	/**
	 * Render betterrange
	 * @since 3.0.0
	 * @return void
	 */
	public function betterrange_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;
		$opid = !empty( $args['opid'] ) && is_string( $args['opid'] ) ? $args['opid'] : '';
		if ( empty( $opid ) ) return;

		// Create reset value - non mediaquery ranges (single range)
		$showreset = is_array( $this->showreset ) && isset( $this->showreset[ $opid ] ) && is_array( $this->showreset[ $opid ] ) && isset( $this->showreset[ $opid ][ $ctrl ] ) ? $this->showreset[ $opid ][ $ctrl ] : false;
		// Create reset value - mediaquery ranges (desktop, tablet, mobile)
		if ( ! empty( $mediaquery ) ) {
			$showreset = is_array( $showreset ) && isset( $showreset[ $media ] ) ? $showreset[ $media ] : false;
		}

		$value = is_scalar( $value ) ? $value : '';
		?>
		<input class="betterrange-range" type="range" value="<?php echo esc_attr( $value ); ?>" <?php
			foreach ( array( 'min', 'max', 'step' ) as $attr )
				if ( isset( $args[ $attr ] ) )
					echo $attr . '="' . esc_attr( $args[ $attr ] ) . '" ';
			?> />
		<input class="betterrange-number" type="number" value="<?php echo esc_attr( $value ); ?>" <?php
			foreach ( array( 'step' ) as $attr )
				if ( isset( $args[ $attr ] ) )
					echo $attr . '="' . esc_attr( $args[ $attr ] ) . '" ';
			?> />
		<?php if ( ! empty( $args['displaysuffix'] ) ) echo ' <span class="betterrange-suffix">' . esc_html( $args['displaysuffix'] ) .'</span>'; ?>
		<?php if ( is_numeric( $showreset )  ) : ?>
			<span class="better-reset hooticonhelp <?php if ( ! empty( $mediaquery ) ) echo 'hooticonhelp--below'; ?> dashicons dashicons-update" data-resetval="<?php echo esc_attr( floatval( $showreset ) ) ?>"><span class="hooticonhelptip"><span><?php esc_html_e( 'Reset', 'nirvata' ); ?></span></span></span>
		<?php endif; ?>
		<?php
	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_betterfontgroup_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'betterfontgroup' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Betterfontgroup_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_betterfontgroup_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array and prepare typography settings for Customizer Library Interface functions
 *
 * @since 3.0.0
 * @param array $value
 * @param string $key
 * @param array $setting
 * @param int $count
 * @return void
 */
function hoot_customize_prepare_betterfontgroup_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'betterfontgroup':
			if ( isset( $setting['default'] ) && is_array( $setting['default'] ) ) {
				$setting['defaultvalue'] = $setting['default'];
				$setting['default'] = json_encode( $setting['default'] );
			}
			$value[ $key ] = $setting;
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'betterfontgroup' ) ) ) {
							if ( isset( $varray['default'] ) && is_array( $varray['default'] ) ) {
								$value[$vkey]['defaultvalue'] = $varray['default'];
								$value[$vkey]['default'] = json_encode( $varray['default'] );
							}
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_betterfontgroup_settings', 15, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_betterfontgroup_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'betterfontgroup' )
		$callback = 'hoot_sanitize_jsonstring';
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_betterfontgroup_callback', 5, 4 );

