<?php
/**
 * Customize for Betterfont, extend the WP customizer
 */

if ( ! apply_filters( 'hoot_support_customize_control_betterfont', true ) ) return;

/**
 * Betterfont Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Betterfont_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'betterfont';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;
	public $defaultvalue = array();
	public $choices = array();
	public $options = array();
	public $showreset = array();

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'betterfont' :
				$choices   = is_array( $this->choices )   ? $this->choices   : array();
				$options   = is_array( $this->options )   ? $this->options   : array();
				$showreset = is_array( $this->showreset ) ? $this->showreset : array();

				$this->showreset = array();
				$this->defaultvalue = is_array( $this->defaultvalue ) ? $this->defaultvalue : array();
				foreach ( $showreset as $key ) {
					if ( isset( $this->defaultvalue[$key] ) )
						$this->showreset[$key] = $this->defaultvalue[$key];
					elseif ( $key === 'all' )
						$this->showreset['all'] = $this->defaultvalue;
				}

				$rawvalue = $this->value();
				$value = is_string( $rawvalue ) ? json_decode( $rawvalue, true ) : $rawvalue;
				$value = is_array( $value ) ? $value : array();

				hoot_customize_ctrlbox_start( $this->boxdivi, 'hoot-betterfont-ctrlbox' );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterfont-btn"><span class="dashicons dashicons-edit"></span></div>

				<input type="hidden" class="betterfont-input" value="<?php echo esc_attr( $rawvalue ); ?>" <?php $this->link(); ?> />

				<?php
				hoot_customize_ctrlbox_end();

				echo '<div class="hoot-betterfont-popup">';

					// > Color
					foreach ( array( 'color' ) as $ctrl ) {
						if ( in_array( $ctrl, $choices ) ):
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : '';
							$ctrloptions = isset( $options[$ctrl] ) && is_array( $options[$ctrl] ) ? $options[$ctrl] : array();
							$ctrloptions = wp_parse_args( $ctrloptions, array(
								'betooltip'     => false,
								'description'   => false,
								'cloneof'       => false,
								'circleswatch'  => true, 
								'displayinline' => false,
								'hasalpha'      => false,
							) );
							$ctrloptions['ctrl'] = $ctrl;
							$ctrloptions['defaultvalue'] = is_array( $this->defaultvalue ) && isset( $this->defaultvalue[$ctrl] ) ? $this->defaultvalue[$ctrl] : '';
							$ctrloptions['cloneof'] = !empty( $ctrloptions['cloneof'] ) && is_string( $ctrloptions['cloneof'] ) ? $ctrloptions['cloneof'] : false;
							$cloneof = $ctrloptions['cloneof'];
							if ( $cloneof ) {
								// val , hasalpha , default - from original
								$hoot_customize = Hoot_Customize::get_instance();
								$clonearray = $hoot_customize->get_options('settings', $cloneof );
								$hasalpha = false;
								$defaults = false;
								if ( !empty( $clonearray['multi'] ) && is_array( $clonearray['multi'] ) ) {
									$mkey = array_search( $cloneof, $clonearray['multi'] );
									if ( $mkey !== false ) {
										$hasalpha = !empty( $clonearray['hasalpha'] ) && is_array( $clonearray['hasalpha'] ) && isset( $clonearray['hasalpha'][$mkey] ) ? $clonearray['hasalpha'][$mkey] : $hasalpha;
										$defaults = !empty( $clonearray['defaultcolor'] ) && is_array( $clonearray['defaultcolor'] ) && isset( $clonearray['defaultcolor'][$mkey] ) ? $clonearray['defaultcolor'][$mkey] : $defaults;
									}
								} else {
									$hasalpha = !empty( $clonearray['hasalpha'] ) ? $clonearray['hasalpha'] : false;
									$defaults = !empty( $clonearray['defaultcolor'] ) ? $clonearray['defaultcolor'] : '';
								}
								$ctrloptions['hasalpha'] = $hasalpha;
								$ctrloptions['defaultvalue'] = $defaults;
								// Also update 'all' reset value
								if ( !empty( $this->showreset['all'] ) && is_array( $this->showreset['all'] ) )
									$this->showreset['all'][$ctrl] = $defaults;
								$ctrlval = get_theme_mod( $cloneof, $defaults ); // using defaults from original control
							}

							$class = 'betterfont-color-ctrlbox';
							$class .= ' hoot-color-ctrlbox';
							$class .= $ctrloptions['circleswatch'] ? ' hoot-cpicker-circle' : ' hoot-cpicker-wp';
							$class .= ' bettercolor-single';
							$class .= $ctrloptions['displayinline'] ? ' bettercolor-inline' : '';
							$class .= $ctrloptions['cloneof'] ? ' bettercolor-clone' : '';
							hoot_customize_ctrlbox_start( false, $class );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-color',
								$ctrlval,
								false, // mediaquery
								__( 'Font Color', 'nirvata' ),
								$ctrloptions['description'],
								$ctrloptions['betooltip']
							);
							?><div class="hoot-betterinputs"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									false, // mediaquery
									array( $this, 'bettercolor_control' ),
									$ctrloptions
								);
								?>
							</div><?php
							hoot_customize_ctrlbox_end();

						endif;
					}

					// > Face
					foreach ( array( 'face' ) as $ctrl ) {
						if ( in_array( $ctrl, $choices ) ):
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : 'inherit'; // default to 'inherit' if no value set
							$ctrllabel = __( 'Family', 'nirvata' );

							$catval = isset( $value['category'] ) ? $value['category'] : '';

							$showreset = is_array( $this->showreset ) && isset( $this->showreset[ $ctrl ] ) ? $this->showreset[ $ctrl ] : false;
							$description = $showreset ? '<span class="better-reset hooticonhelp dashicons dashicons-update" data-resetval="' . esc_attr( $showreset ) . '"><span class="hooticonhelptip"><span>' . esc_html__( 'Reset', 'nirvata' ) . '</span></span></span>' : '';

							$betooltip = hoot_arrayel( $options, array( $ctrl, 'betooltip' ) );
							hoot_customize_ctrlbox_start( false, 'betterfont-face-ctrlbox' );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-' . $ctrl,
								$ctrlval,
								false, // mediaquery
								$ctrllabel,
								$description,
								$betooltip
							);
							?><div class="hoot-betterinputs"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									false, // mediaquery
									array( $this, 'betterface_control' ),
									array( 'ctrl' => $ctrl )
								);
								?>
							</div>
							<input type="hidden" class="betterfont-category-input" value="<?php echo esc_attr( $catval ); ?>" data-ctrlid="category" /><?php
							hoot_customize_ctrlbox_end();

						endif;
					}

					// > Subsets
					foreach ( array( 'subsets' ) as $ctrl ) {
						if ( in_array( 'face', $choices ) && in_array( $ctrl, $choices ) ):
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : array('latin'); // default to 'latin' if no value set
							$ctrllabel = __( 'Subsets', 'nirvata' );

							$faceval = isset( $value['face'] ) ? $value['face'] : false;
							$selectops = $faceval ? hootfontography()->get_subsets( $faceval ) : array();

							$class = 'betterfont-subsets-ctrlbox';
							$class .= empty( $selectops ) ? ' hoot-disabled' : '';
							$description = hoot_arrayel( $options, array( $ctrl, 'description' ) );
							hoot_customize_ctrlbox_start( false, $class );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-' . $ctrl,
								$ctrlval,
								false, // mediaquery
								$ctrllabel,
								$description,
								__( 'Choose characters your text may need. Select \'latin\' for English only websites.', 'nirvata' )
							);
							?><div class="hoot-betterinputs"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									false, // mediaquery
									array( $this, 'bettersubsets_control' ),
									array( 'ctrl' => $ctrl, 'selectops' => $selectops )
								);
								?>
							</div><?php
							hoot_customize_ctrlbox_end();
						endif;
					}

					// > Size Range
					// > LineHeight Range
					// > LetterSpacing Range
					foreach ( array( 'size', 'lheight', 'lspace' ) as $ctrl ) {
						if ( in_array( $ctrl, $choices ) ):
							$mediaquery = $ctrl === 'size' ? hoot_arrayel( $options, array( $ctrl, 'mediaquery' ) ) : false;
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : '';
							$ctrllabel = __( 'Font Size', 'nirvata' );
							if ( $ctrl === 'lheight' ) $ctrllabel = __( 'Line Height', 'nirvata' );
							if ( $ctrl === 'lspace' )  $ctrllabel = __( 'Letter Spacing', 'nirvata' );
							$displaysuffix = 'px';
							if ( $ctrl === 'lheight' ) $displaysuffix = 'em';
							$min = 5; $max = 125; $step = 1;
							if ( $ctrl === 'lheight' ) { $min = 0.5; $max = 3; $step = 0.05; }
							if ( $ctrl === 'lspace' ) { $min = -5; $max = 15; $step = 0.5; }

							$description = hoot_arrayel( $options, array( $ctrl, 'description' ) );
							$betooltip = hoot_arrayel( $options, array( $ctrl, 'betooltip' ) );
							hoot_customize_ctrlbox_start( false, 'betterfont-range-ctrlbox' );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-' . $ctrl,
								$ctrlval,
								$mediaquery,
								$ctrllabel,
								$description,
								$betooltip
							);
							?><div class="hoot-betterinputs betterrange-box"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									$mediaquery,
									array( $this, 'betterrange_control' ),
									array( 'ctrl' => $ctrl, 'displaysuffix' => $displaysuffix, 'min' => $min, 'max' => $max, 'step' => $step )
								);
								?>
								<input type="hidden" class="betterrange-input betterfont-range-input" value="<?php echo esc_attr( json_encode( $ctrlval ) ); ?>" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>" />
							</div><?php
							hoot_customize_ctrlbox_end();

						endif;
					}

					// > Weight
					foreach ( array( 'weight' ) as $ctrl ) {
						if ( in_array( 'face', $choices ) && in_array( $ctrl, $choices ) ):
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : '0'; // default to 'inherit' if no value set
							$ctrllabel = __( 'Bold', 'nirvata' );

							$faceval = isset( $value['face'] ) ? $value['face'] : false;
							$selectops = $faceval ? hootfontography()->get_fontweights( $faceval, true ) : array();
							$selectops = !empty( $selectops ) ? $selectops : hootfontography()->get_fontweights( 'default', true );

							hoot_customize_ctrlbox_start( false, 'betterfont-weight-ctrlbox' );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-' . $ctrl,
								$ctrlval,
								false, // mediaquery
								$ctrllabel,
							);
							?><div class="hoot-betterinputs"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									false, // mediaquery
									array( $this, 'betterweight_control' ),
									array( 'ctrl' => $ctrl, 'selectops' => $selectops )
								);
								?>
							</div><?php
							hoot_customize_ctrlbox_end();
						endif;
					}

					// > FontStyle
					// > TextTransform
					// > TextDecoration
					foreach ( array( 'style', 'trans', 'deco' ) as $ctrl ) {
						if ( in_array( $ctrl, $choices ) ):
							$ctrlval = isset( $value[$ctrl] ) ? $value[$ctrl] : '';
							$ctrllabel = __( 'Italic', 'nirvata' );
							if ( $ctrl === 'trans' ) $ctrllabel = __( 'Capitalize', 'nirvata' );
							if ( $ctrl === 'deco' )  $ctrllabel = __( 'Underline', 'nirvata' );
							$selectops = array( 0 => __( 'Inherit', 'nirvata' ) );
							if ( $ctrl === 'style' ) {
								$selectops['normal']       = __( 'Normal', 'nirvata' );
								$selectops['italic']       = __( 'Italic', 'nirvata' );
							} elseif ( $ctrl === 'trans' ) {
								$selectops['none']         = __( 'None', 'nirvata' );
								$selectops['capitalize']   = __( 'Capitalize', 'nirvata' );
								$selectops['uppercase']    = __( 'Uppercase', 'nirvata' );
								$selectops['lowercase']    = __( 'Lowercase', 'nirvata' );
							} elseif ( $ctrl === 'deco' ) {
								$selectops['none']         = __( 'None', 'nirvata' );
								$selectops['underline']    = __( 'Underline', 'nirvata' );
								$selectops['overline']     = __( 'Overline', 'nirvata' );
								$selectops['line-through'] = __( 'Line Through', 'nirvata' );
							}

							$description = hoot_arrayel( $options, array( $ctrl, 'description' ) );
							$betooltip = hoot_arrayel( $options, array( $ctrl, 'betooltip' ) );
							hoot_customize_ctrlbox_start( false, 'betterfont-select-ctrlbox' );
							hoot_customize_betterlabels_mediaquery(
								'betterfont-' . $ctrl,
								$ctrlval,
								false, // mediaquery
								$ctrllabel,
								$description,
								$betooltip
							);
							?><div class="hoot-betterinputs"><?php
								hoot_customize_betterinputs_mediaquery(
									$ctrlval,
									false, // mediaquery
									array( $this, 'betterselect_control' ),
									array( 'ctrl' => $ctrl, 'selectops' => $selectops )
								);
								?>
							</div><?php
							hoot_customize_ctrlbox_end();

						endif;
					}

					// > Reset All
					if ( !empty( $this->showreset['all'] ) && is_array( $this->showreset['all'] ) ) : ?>
						<div class="hoot-betterfont-resetall hooticonhelpX" data-resetval="<?php echo esc_attr( json_encode( $this->showreset['all'] ) ); ?>">
							<span class="better-reset dashicons dashicons-update"></span>
							<?php esc_html_e( 'Reset All Values', 'nirvata' );
							?>
						</div>
						<?php
					endif;

				echo '</div>'; // .hoot-betterfont-popup

			break;

		}

	}

	/**
	 * Render betterselect
	 * @since 3.0.0
	 * @return void
	 */
	public function betterface_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;
		$label = $value;
		if ( empty( $value ) || ! is_string( $value ) ) {
			$value = 'inherit';
			$label = esc_html__( 'Inherit', 'nirvata' );
		}

		?><select class="betterfont-face-input" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>">
			<option value="<?php echo esc_attr( $value ); ?>" selected="selected"><?php echo esc_html( $label ); ?></option>
		</select><?php
	}

	/**
	 * Render betterselect
	 * @since 3.0.0
	 * @return void
	 */
	public function bettersubsets_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;

		$selectops = !empty( $args['selectops'] ) && is_array( $args['selectops'] ) ? $args['selectops'] : array();
		// multiple select, so value should be an array
		$value = is_string( $value ) ? explode( ',', $value ) : ( is_array( $value ) ? $value : array() );

		?><select class="betterfont-subsets-input" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>" multiple="multiple"><?php
		foreach ( $selectops as $opt ) :
			$is_selected = in_array( $opt, $value );
			?><option value="<?php echo esc_attr( $opt ); ?>" <?php selected( $is_selected ); ?>><?php echo esc_html( $opt ); ?></option><?php
		endforeach;
		?></select><?php
	}

	/**
	 * Render betterselect
	 * @since 3.0.0
	 * @return void
	 */
	public function betterweight_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;

		$selectops = !empty( $args['selectops'] ) && is_array( $args['selectops'] ) ? $args['selectops'] : array();
		$value = is_scalar( $value ) ? $value : '';

		?><select class="betterfont-weight-input" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>"><?php
		foreach ( $selectops as $optval => $optname ) :
			?><option value="<?php echo esc_attr( $optval ); ?>" <?php selected( $value, $optval ); ?>><?php echo esc_html( $optname ); ?></option><?php
		endforeach;
		?></select><?php
	}

	/**
	 * Render bettercolor
	 * @since 3.0.0
	 * @return void
	 */
	public function bettercolor_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;
		?>
		<input type="text" value="<?php echo esc_attr( $value ); ?>" class="hoot-color-picker"<?php
			echo ' data-skip-update-customize="true"';
			echo ' data-ctrlid="' . esc_attr( $ctrl ) . '"';

			if ( !empty( $args['hasalpha'] ) )
				echo ' data-alpha-enabled="true"';
			echo ' data-alpha-custom-width="0"';
			echo ' data-alpha-color-type="hex"';
			echo ' data-hoot-setting-link="' . esc_attr( $this->id ) . '"';
			if ( $args['cloneof'] )
				echo ' data-cloneof="' . esc_attr( $args['cloneof'] ) . '"';
			if ( !empty( $args['defaultvalue'] ) )
				echo ' data-default-color="' . esc_attr( $args['defaultvalue'] ) . '"';

			?>>
			<?php
	}

	/**
	 * Render betterselect
	 * @since 3.0.0
	 * @return void
	 */
	public function betterselect_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;
		$selectops = !empty( $args['selectops'] ) && is_array( $args['selectops'] ) ? $args['selectops'] : array();
		if ( empty( $selectops ) ) return;

		echo '<div class="hoot-customize-select">';

		?><select class="betterfont-select-input" data-ctrlid="<?php echo esc_attr( $ctrl ); ?>"><?php
		foreach ( $selectops as $optval => $optname ) :
			?>
			<option value="<?php echo esc_attr( $optval ); ?>" <?php selected( $value, $optval ); ?>><?php echo esc_html( $optname ); ?></option>
			<?php
		endforeach;
		?></select><?php
		echo '</div>';
	}

	/**
	 * Render betterrange
	 * @since 3.0.0
	 * @return void
	 */
	public function betterrange_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$ctrl = !empty( $args['ctrl'] ) && is_string( $args['ctrl'] ) ? $args['ctrl'] : '';
		if ( empty( $ctrl ) ) return;

		// Create reset value - non mediaquery ranges (single range)
		$showreset = is_array( $this->showreset ) && isset( $this->showreset[ $ctrl ] ) ? $this->showreset[ $ctrl ] : false;
		// Create reset value - mediaquery ranges (desktop, tablet, mobile)
		if ( ! empty( $mediaquery ) ) {
			$showreset = is_array( $showreset ) && isset( $showreset[ $media ] ) ? $showreset[ $media ] : false;
		}

		$value = is_scalar( $value ) ? $value : '';
		?>
		<input class="betterrange-range" type="range" value="<?php echo esc_attr( $value ); ?>" <?php
			foreach ( array( 'min', 'max', 'step' ) as $attr )
				if ( isset( $args[ $attr ] ) )
					echo $attr . '="' . esc_attr( $args[ $attr ] ) . '" ';
			?> />
		<input class="betterrange-number" type="number" value="<?php echo esc_attr( $value ); ?>" <?php
			foreach ( array( 'step' ) as $attr )
				if ( isset( $args[ $attr ] ) )
					echo $attr . '="' . esc_attr( $args[ $attr ] ) . '" ';
			?> />
		<?php if ( ! empty( $args['displaysuffix'] ) ) echo ' <span class="betterrange-suffix">' . esc_html( $args['displaysuffix'] ) .'</span>'; ?>
		<?php if ( is_numeric( $showreset )  ) : ?>
			<span class="better-reset hooticonhelp <?php if ( ! empty( $mediaquery ) ) echo 'hooticonhelp--below'; ?> dashicons dashicons-update" data-resetval="<?php echo esc_attr( floatval( $showreset ) ) ?>"><span class="hooticonhelptip"><span><?php esc_html_e( 'Reset', 'nirvata' ); ?></span></span></span>
		<?php endif; ?>
		<?php
	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_betterfont_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'betterfont' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Betterfont_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_betterfont_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array and prepare typography settings for Customizer Library Interface functions
 *
 * @since 3.0.0
 * @param array $value
 * @param string $key
 * @param array $setting
 * @param int $count
 * @return void
 */
function hoot_customize_prepare_betterfont_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'betterfont':
			if ( isset( $setting['default'] ) && is_array( $setting['default'] ) ) {
				$setting['defaultvalue'] = $setting['default'];
				$setting['default'] = json_encode( $setting['default'] );
			}
			$value[ $key ] = $setting;
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'betterfont' ) ) ) {
							if ( isset( $varray['default'] ) && is_array( $varray['default'] ) ) {
								$value[$vkey]['defaultvalue'] = $varray['default'];
								$value[$vkey]['default'] = json_encode( $varray['default'] );
							}
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_betterfont_settings', 15, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_betterfont_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'betterfont' )
		$callback = 'hoot_sanitize_jsonstring';
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_betterfont_callback', 5, 4 );

/**
 * Enqueue scripts to customizer screen
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_enqueue_betterfont_scripts() {
	$style_uri = hoot_locate_style( hoot_data()->liburi . 'css/select2' );
	wp_enqueue_style( 'select2', $style_uri, array(),  '4.0.13' );
	$script_uri = hoot_locate_script( hoot_data()->liburi . 'js/select2' );
	wp_enqueue_script( 'select2', $script_uri, array( 'jquery' ), '4.0.13', true );
	if ( hootfontography()->show_gfont_preview() ) {
		$custom_css = '.select2-dropdown:not(.hoot-select2-issearch) .select2-results__option[aria-label="Google Fonts"] li:not(.select2-results__option--highlighted):not([aria-selected="true"]):not([aria-disabled=true]):not(:hover) { background-image: url("' . esc_url( hoot_data()->liburi ) . 'css/fonts-gfonts.2509.png"); background-repeat: no-repeat; color: transparent; }';
		wp_add_inline_style( 'select2', $custom_css );
	}
}
add_action( 'customize_controls_enqueue_scripts', 'hoot_customize_enqueue_betterfont_scripts', 10 );

/**
 * Add Content to JS object passed to hoot-customize-script
 *
 * @since 3.0.0
 * @return void
 */
function hoot_customize_controls_betterfont_control_js_object( $data ) {
	$data['fonts'] = hootfontography()->get_fonts();
	$data['fontweights'] = array(
		'all'      => hootfontography()->get_fontweights( 'all',     true ), // used for getting label
		'defaults' => hootfontography()->get_fontweights( 'default', false ), // to create default options
		'inherit'  => hootfontography()->get_fontweights( '',        true ), // to add 'Inherit' option at top
	);
	$data['gfontspreview'] = hootfontography()->show_gfont_preview();
	$data['gfontsnote'] = esc_html( hootfontography()->show_gfonts_note() );
	return $data;
}
add_filter( 'hoot_customize_control_footer_js_data_object', 'hoot_customize_controls_betterfont_control_js_object' );
