<?php
/**
 * Customize for general content, extend the WP customizer
 */

/**
 * General Content Control Class extends the WP customizer
 * @property string $label
 * @property string $description
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Content_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'content';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = 0;

	/**
	 * Define variable to whitelist class parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $class = '';

	/**
	 * Define variable to whitelist content parameter
	 *
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $content = '';

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'content' :
				$boxdivi = $this->boxdivi;
				$classes = is_string( $this->class ) ? $this->class : '';
				$hasheadingclass = strpos( $classes, 'hoot-headline' ) !== false;
				$hasnoteclass = strpos( $classes, 'hootnote' ) !== false;
				if ( $boxdivi === 0 ) {
					$boxdivi = $hasheadingclass || $hasnoteclass ? false : true;
				}
				if ( $hasheadingclass ) {
					$classes .= ' hoot-nonextdivstd';
				}
				hoot_customize_ctrlbox_start( $boxdivi, $classes );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);
				if ( ! empty( $this->content ) ) : ?>
					<span class="hoot-customize-control-content-text"><?php echo wp_kses_post( $this->content ); ?></span>
				<?php endif;

				hoot_customize_ctrlbox_end();

				break;

		}

	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_content_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'content' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Content_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_content_control_interface', 10, 3 );
endif;