<?php
/**
 * Customize for Bettercolor, extend the WP customizer
 */

/**
 * Bettercolor Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @property string $default
 * @property array $settings
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Bettercolor_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'bettercolor';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;
	public $defaultcolor = '';
	public $hasalpha = false;
	public $circleswatch = true;
	public $multi = array();
	public $displayinline = false;
	public $cloneof = false;

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'bettercolor' :
				$singleid = $this->id;
				$singlevalue = $this->value();
				$multi = $this->multi;
				$ismulti = false;
				$circleswatch = $this->circleswatch;
				$hasalpha = $this->hasalpha;
				$defaults = $this->defaultcolor;
				$values = array();

				// Is this a clone
				$cloneof = !empty( $this->cloneof ) && is_string( $this->cloneof ) ? $this->cloneof : false;
				if ( $cloneof ) {
					$hoot_customize = Hoot_Customize::get_instance();
					$clonearray = $hoot_customize->get_options('settings', $cloneof );
					$origtype = is_array( $clonearray ) && isset( $clonearray['type'] ) ? $clonearray['type'] : '';
					if ( $origtype == 'bettercolor' || $origtype == 'betterfont' ) {
						$multi = false;
						$ismulti = false;
						$circleswatch = $this->circleswatch;
						$hasalpha = false;
						$defaults = false;
						if ( $origtype == 'betterfont' ) {
							$hasalpha = hoot_arrayel( $clonearray, array( 'options', 'color', 'hasalpha' ) );
							$hasalpha = $hasalpha !== null ? $hasalpha : false;
							$defaults = hoot_arrayel( $clonearray, array( 'defaultvalue', 'color' ) );
							$defaults = $defaults !== null ? $defaults : '';
						}
						// else its bettercolor - check if multi
						elseif ( !empty( $clonearray['multi'] ) && is_array( $clonearray['multi'] ) ) {
							$mkey = array_search( $cloneof, $clonearray['multi'] );
							if ( $mkey !== false ) {
								$hasalpha = !empty( $clonearray['hasalpha'] ) && is_array( $clonearray['hasalpha'] ) && isset( $clonearray['hasalpha'][$mkey] ) ? $clonearray['hasalpha'][$mkey] : $hasalpha;
								$defaults = !empty( $clonearray['defaultcolor'] ) && is_array( $clonearray['defaultcolor'] ) && isset( $clonearray['defaultcolor'][$mkey] ) ? $clonearray['defaultcolor'][$mkey] : $defaults;
							}
						}
						// else is bettercolor - single
						else {
							$hasalpha = !empty( $clonearray['hasalpha'] ) ? $clonearray['hasalpha'] : false;
							$defaults = !empty( $clonearray['defaultcolor'] ) ? $clonearray['defaultcolor'] : '';
						}
						$singleid = $this->id;
						$singlevalue = get_theme_mod( $cloneof, $defaults ); // using defaults from original control
						if ( $origtype == 'betterfont' ) {
							if ( $singlevalue !== $defaults ) {
								$singlevalue = is_string( $singlevalue ) ? json_decode( $singlevalue, true ) : $singlevalue;
								$singlevalue = is_array( $singlevalue ) ? $singlevalue : array();
								$singlevalue = isset( $singlevalue['color'] ) ? $singlevalue['color'] : $defaults;
							}
						}
					}
				}

				if ( empty( $multi ) || ! is_array( $multi ) ) {
					$multi = array( $singleid );
					$hasalpha = array( $hasalpha );
					$defaults = array( $defaults );
					$values = array( $singlevalue );
				} else {
					$ismulti = true;
					$circleswatch = true;
					$hasalpha = is_array( $hasalpha ) ? $hasalpha : array_fill( 0, count( $multi ), $hasalpha );
					$defaults = is_array( $defaults ) ? $defaults : array_fill( 0, count( $multi ), $defaults );
					foreach ( $multi as $mkey => $id ) {
						$mdefault = isset( $defaults[ $mkey ] ) ? $defaults[ $mkey ] : '';
						$values[ $mkey ] = get_theme_mod( $id, $mdefault );
					}
				}

				$class = 'hoot-color-ctrlbox';
				$class .= $circleswatch ? ' hoot-cpicker-circle' : ' hoot-cpicker-wp';
				$class .= !empty( $ismulti ) ? ' bettercolor-multi' : ' bettercolor-single';
				$class .= $this->displayinline ? ' bettercolor-inline' : '';
				$class .= $cloneof ? ' bettercolor-clone' : '';
				hoot_customize_ctrlbox_start( $this->boxdivi, $class );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs"><?php

					hoot_customize_betterinputs_mediaquery(
						$values,
						false, // mediaquery
						array( $this, 'bettercolor_control' ),
						array( 'multi' => $multi, 'hasalpha' => $hasalpha, 'defaults' => $defaults, 'cloneof' => $cloneof )
					);

				?></div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function bettercolor_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$args = is_array( $args ) ? $args : array();
		$value = is_array( $value ) ? $value : array();
		$multi    = isset( $args['multi'] )    && is_array(  $args['multi']    ) ? $args['multi']    : array();
		$hasalpha = isset( $args['hasalpha'] ) && is_array(  $args['hasalpha'] ) ? $args['hasalpha'] : array();
		$defaults = isset( $args['defaults'] ) && is_array(  $args['defaults'] ) ? $args['defaults'] : array();
		$cloneof  = isset( $args['cloneof'] )  && is_string( $args['cloneof']  ) ? $args['cloneof']  : '';

		foreach ( $multi as $mkey => $id ) :
			$singleval = isset( $value[ $mkey ]    ) ? $value[ $mkey ]    : '';
			$singledef = isset( $defaults[ $mkey ] ) ? $defaults[ $mkey ] : '';

			?><input type="text" value="<?php echo esc_attr( $singleval ); ?>" class="hoot-color-picker"<?php
				if ( !empty( $hasalpha[ $mkey ] ) )
					echo ' data-alpha-enabled="true"';
				echo ' data-alpha-custom-width="0"';
				echo ' data-alpha-color-type="hex"';
				echo ' data-hoot-setting-link="' . esc_attr( $id ) . '"';
				if ( $cloneof )
					echo ' data-cloneof="' . esc_attr( $cloneof ) . '"';
				if ( !empty( $singledef ) )
					echo ' data-default-color="' . esc_attr( $singledef ) . '"';

				?>>

		<?php endforeach;
	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_bettercolor_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'bettercolor' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Bettercolor_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_bettercolor_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array
 * @since 3.1.0
 */
function hoot_customize_prepare_bettercolor_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'color':
			if ( empty( $setting['wpctrl'] ) ) {
				$value[ $key ] = $setting;
				$value[ $key ]['type'] = 'better' . $type;
				$maybemultval = hoot_customize_prepare_bettercolor_multi( $value[ $key ] );
				if ( isset( $value[ $key ]['multi'] ) && is_array( $value[ $key ]['multi'] ) ) {
					$value = $maybemultval;
				} else {
					$value[ $key ] = $maybemultval;
				}
			}
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				$newval = array();
				foreach ( $value as $vkey => $varray ) {
					$updated = false;
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'color' ) ) ) {
							if ( empty( $varray['wpctrl'] ) ) {
								$varray['type'] = 'bettercolor';
								$maybemultval = hoot_customize_prepare_bettercolor_multi( $varray );
								if ( isset( $varray['multi'] ) && is_array( $varray['multi'] ) ) {
									$newval = array_merge( $newval, $maybemultval );
								} else {
									$newval[ $vkey ] = $maybemultval;
								}
								$updated = true;
							}
						}
					}
					if ( !$updated ) $newval[ $vkey ] = $varray; // keep as is
				}
				$value = $newval;
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_bettercolor_settings', 15, 4 );

function hoot_customize_prepare_bettercolor_multi( $setting ){
	if ( empty( $setting['multi'] ) || ! is_array( $setting['multi'] ) ) {
		if ( !empty( $setting['default'] ) )
			$setting['defaultcolor'] = $setting['default'];
		return $setting;
	}

	$value = array();
	$multi = $setting['multi'];
	$default = !empty( $setting['default'] ) ? $setting['default'] : array();
	$default = is_array( $default ) ? $default : array_fill( 0, count( $multi ), $default );
	$transport = !empty( $setting['transport'] ) ? $setting['transport'] : array();
	$transport = is_array( $transport ) ? $transport : array_fill( 0, count( $multi ), $transport );
	foreach ( $multi as $mkey => $id ) {
		$value[ $id ] = $setting;
		$value[ $id ]['default'] = isset( $default[ $mkey ] ) ? $default[ $mkey ] : '';
		$value[ $id ]['transport'] = isset( $transport[ $mkey ] ) ? $transport[ $mkey ] : '';
		$value[ $id ]['defaultcolor'] = $default;
		foreach ( array( 'default', 'transport', 'defaultcolor' ) as $key ) {
			if ( empty( $value[ $id ][ $key ] ) ) unset( $value[ $id ][ $key ] );
		}
		if ( $mkey !== 0 ) {
			$value[ $id ][ 'type' ] = 'bettercolor_multichild';
			foreach ( array( 'label', 'multi', 'hasalpha', 'defaultcolor' ) as $key ) {
				if ( isset( $value[ $id ][ $key ] ) ) unset( $value[ $id ][ $key ] );
			}
		}
	}
	return $value;
}

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_bettercolor_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'bettercolor' )
		$callback = 'hoot_sanitize_color_allowocto'; // capable of sanitizing rgb, rgba, hex, octohex
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_bettercolor_callback', 5, 4 );
