<?php
/**
 * Customize for Choices, extend the WP customizer
 */

/**
 * Choices Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Choices_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'choices';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Define variable to whitelist parameter
	 */
	public $choices = array();

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'radioimage' :
			case 'betterradio' :
			case 'betterselect' :
			case 'betterselectsmall' :
				if ( empty( $this->choices ) )
					return;

				hoot_customize_ctrlbox_start( $this->boxdivi );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs"><?php

					$cb = $this->type === 'betterselect' || $this->type === 'betterselectsmall' ? 'betterselect_control' : ( $this->type === 'radioimage' ? 'betterradioimage_control' : 'betterradio_control' );
					hoot_customize_betterinputs_mediaquery(
						$this->value(),
						false, // mediaquery
						array( $this, $cb )
					);

				?></div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function betterradio_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$name = '_customize-radio-' . $this->id;
		echo '<div class="hoot-customize-radio">';
		foreach ( $this->choices as $val => $label ) :
			$checked = checked( $value, $val, false );
			?>
			<span class="customize-inside-control-row">
				<input id="<?php echo esc_attr( $name . '-' . $val ); ?>" type="radio" value="<?php echo esc_attr( $val ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); echo $checked; ?> />
				<label for="<?php echo esc_attr( $name . '-' . $val ); ?>"><?php echo esc_html( $label ); ?></label>
			</span>
			<?php
		endforeach;
		echo '</div>';
	}
	public function betterradioimage_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$name = '_customize-radio-' . $this->id;
		echo '<div class="hoot-customize-radioimagewrap">';
		foreach ( $this->choices as $val => $image ) :
			$checked = checked( $value, $val, false );
			?>
			<label class="hoot-customize-radioimage<?php if ($checked) echo ' radiocheck' ?>">
				<input type="radio" value="<?php echo esc_attr( $val ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); echo $checked; ?> />
				<?php if ( is_string( $image ) )
					echo '<img src="' . esc_url( $image ) . '" />';
				elseif ( is_array( $image ) && !empty( $image[0] ) && is_string( $image[0] ) )
					echo '<span>' . wp_kses_post( $image[0] ) . '</span>'; ?>
			</label>
			<?php
		endforeach;
		echo '</div>';
	}
	public function betterselect_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$name = '_customize-input-' . $this->id;
		echo '<div class="hoot-customize-select">';
		?><select id="<?php echo esc_attr( $name ); ?>" <?php $this->link(); ?>><?php
		foreach ( $this->choices as $val => $label ) :
			?>
			<option value="<?php echo esc_attr( $val ); ?>" <?php selected( $value, $val ); ?>><?php echo esc_html( $label ); ?></option>
			<?php
		endforeach;
		?></select><?php
		echo '</div>';
	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_choices_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( in_array( $setting['type'], array( 'radioimage', 'betterradio', 'betterselect', 'betterselectsmall' ) ) ) {
			$wp_customize->add_control(
				new Hoot_Customize_Choices_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_choices_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array
 * @since 3.1.0
 */
function hoot_customize_prepare_choices_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'radio':
		case 'select':
		case 'selectsmall':
			if ( empty( $setting['wpctrl'] ) ) {
				$value[ $key ] = $setting;
				$value[ $key ]['type'] = 'better' . $type;
			}
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'radio', 'select', 'selectsmall' ) ) ) {
							if ( empty( $varray['wpctrl'] ) ) {
								$value[$vkey]['type'] = 'better' . $varray['type'];
							}
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_choices_settings', 15, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_choices_callback( $callback, $type, $setting, $name ) {
	if ( in_array( $setting['type'], array( 'radioimage', 'betterradio', 'betterselect' ) ) ) {
		$callback = 'hoot_sanitize_customize_enum';
	}
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_choices_callback', 5, 4 );