<?php
/**
 * Customize for Basics, extend the WP customizer
 */

/**
 * Basics Control Class extends the WP customizer
 * @property string $id
 * @property string $label
 * @property string $description
 * @method string input_attrs()
 * @method string value()
 * @method string link()
 * @since 3.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Basics_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'basics';

	/**
	 * Define variable to whitelist parameter
	 */
	public $betooltip = array();
	public $boxdivi = true;

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'bettertext' :
			case 'bettertextarea' :
			case 'betterurl' :
			case 'betternumber' :

				hoot_customize_ctrlbox_start( $this->boxdivi );

				hoot_customize_betterlabels_mediaquery(
					$this->type,
					'', // value
					false, // mediaquery
					$this->label,
					$this->description,
					$this->betooltip
				);

				?><div class="hoot-betterinputs"><?php
					$cb = $this->type === 'bettertextarea' ? 'bettertextarea_control' : 'bettertext_control';
					hoot_customize_betterinputs_mediaquery(
						$this->value(),
						false, // mediaquery
						array( $this, $cb )
					);
				?></div><?php

				hoot_customize_ctrlbox_end();

				break;

		}

	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function bettertextarea_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$name = '_customize-input-' . $this->id;
		echo '<div class="hoot-customize-textarea">';
		?>
			<textarea id="<?php echo esc_attr( $name ); ?>" rows="5" <?php $this->link(); ?>><?php echo esc_textarea( $value ); ?></textarea>
		<?php
		echo '</div>';
	}
	public function bettertext_control( $value, $media = '', $mediaquery = false, $args = array() ) {
		$name = '_customize-input-' . $this->id;
		echo '<div class="hoot-customize-text">';
			?>
			<input id="<?php echo esc_attr( $name ); ?>" type="<?php echo esc_attr( str_replace( 'better', '', $this->type) ); ?>" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); ?>>
			<?php
		echo '</div>';
	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_basics_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( in_array( $setting['type'], array( 'bettertext', 'bettertextarea', 'betterurl', 'betternumber' ) ) ) {
			$wp_customize->add_control(
				new Hoot_Customize_Basics_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_basics_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array
 * @since 3.1.0
 */
function hoot_customize_prepare_basics_settings( $value, $key, $setting, $count ) {
	$type = !empty( $setting['type'] ) ? $setting['type'] : '';
	switch ( $type ) {
		case 'text':
		case 'textarea':
		case 'url':
		case 'number':
			if ( empty( $setting['wpctrl'] ) ) {
				$value[ $key ] = $setting;
				$value[ $key ]['type'] = 'better' . $type;
			}
			break;
		case 'tabs':
		case 'bettertabs':
		case 'group':
		case 'typography':
		case 'betterbackground':
			if ( is_array( $value ) ) {
				foreach ( $value as $vkey => $varray ) {
					if ( is_array( $varray ) && !empty( $varray['type'] ) ) {
						if ( in_array( $varray['type'], array( 'text', 'textarea', 'url', 'number' ) ) ) {
							if ( empty( $varray['wpctrl'] ) ) {
								$value[$vkey]['type'] = 'better' . $varray['type'];
							}
						}
					}
				}
			}
			break;
	}
	return $value;
}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_basics_settings', 15, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_basics_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'bettertext' )
		$callback = 'hoot_sanitize_text';
	elseif ( $type == 'bettertextarea' )
		$callback = 'hoot_sanitize_textarea';
	elseif ( $type == 'betterurl' )
		$callback = 'sanitize_url';
	elseif ( $type == 'betternumber' )
		$callback = 'intval';
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_basics_callback', 5, 4 );