<?php
/**
 * Pro customizer section.
 *
 * @credit() Justin Tadlock https://github.com/justintadlock/trt-customizer-pro
 *
 * @since  1.0
 * @access public
 */
class Hoot_Theme_Customize_Section_Pro extends WP_Customize_Section {

	/**
	 * The type of customize section being rendered.
	 *
	 * @since  1.0
	 * @access public
	 * @var    string
	 */
	public $type = 'hoot-theme';

	/**
	 * Custom button text to output.
	 *
	 * @since  1.0
	 * @access public
	 * @var    string
	 */
	public $pro_text = '';

	/**
	 * Custom pro button URL.
	 *
	 * @since  1.0
	 * @access public
	 * @var    string
	 */
	public $pro_url = '';

	/**
	 * Custom values for hootkit button.
	 * @since  1.3
	 */
	public $hootkit_active = '';
	public $hootkit_url = '';
	public $hootkit_text = '';

	/**
	 * Add custom parameters to pass to the JS via JSON.
	 *
	 * @since  1.0
	 * @access public
	 * @return void
	 */
	public function json() {
		$json = parent::json();

		$json['pro_text'] = $this->pro_text;
		$json['pro_url']  = $this->pro_url;

		$json['hootkit_active'] = $this->hootkit_active ? 'yes' : 'no';
		$json['hootkit_url']  = $this->hootkit_url;
		$json['hootkit_text']  = $this->hootkit_text;

		return $json;
	}

	/**
	 * Outputs the Underscore.js template.
	 *
	 * @since  1.0
	 * @access public
	 * @return void
	 */
	protected function render_template() { ?>

		<# if ( data.hootkit_active === 'no' ) { #>
			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand hootkit-active">
				<a href="{{ data.hootkit_url }}" class="button button-secondary" target="_blank"><span class="dashicons dashicons-flag"></span> {{ data.hootkit_text }}</a>
			</li>
		<# } else if ( data.pro_text && data.pro_url ) { #>
			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand hootkit-inactive">
				<a href="{{ data.pro_url }}" class="button button-secondary" target="_blank"><span class="dashicons dashicons-superhero"></span>{{ data.pro_text }}</a>
			</li>
		<# } #>
	<?php }
}
