<?php
/**
 * Helper Functions
 * This file is loaded at after_setup_theme@10
 */

/**
 * Get dashboard
 * @return string
 */
if ( ! function_exists( 'hoot_dashboard' ) ):
function hoot_dashboard( $key, $args=array() ) {
	$val = '';
	if ( function_exists( 'nirvata_abouttag' ) ) {
		switch ( $key ) {
			case 'label': $val = nirvata_abouttag( 'dashlabel' ); break;
			case 'slug': $val = nirvata_abouttag( 'dashslug' ); break;
			case 'url': $val = nirvata_abouttag( 'dashurl' ); break;
			case 'screen': $val = nirvata_abouttag( 'dashscreen' ); break;
			default: $val = ''; break;
		}
		if ( $key === 'url' ) {
			$val = admin_url( $val );
			if ( is_array( $args ) && ! empty( $args ) ) {
				$val = add_query_arg( $args, $val );
			}
		}
	}
	return $val;
}
endif;

/**
 * Set Theme About Page Tags
 * @access public
 * @return mixed
 */
function nirvata_abouttag( $index = 'slug', $force = false ) {
	static $tags;
	if ( empty( $tags ) || $force === true ) {
		$child = hoot_data( 'childtheme_name' );
		$is_official_child = false;
		if ( $child ) {
			$checks = apply_filters( 'nirvata_theme_config_childtheme_array', array() );
			foreach ( $checks as $check ) {
				if ( stripos( $child, $check ) !== false ) {
					$is_official_child = true;
					break;
				}
			}
		}
		$defaults = $is_official_child ? array() : array(
			'slug' => 'nirvata',
			'name' => __( 'Nirvata', 'nirvata' ),
			'dashlabel' => __( 'Nirvata Dashboard', 'nirvata' ),
			'dashslug' => 'hoot-dashboard',
			'dashurl' => 'themes.php?page=hoot-dashboard',
			'dashscreen' => 'appearance_page_hoot-dashboard',
			'vers' => hoot_data( 'template_version' ),
			'shot' => ( file_exists( hoot_data()->template_dir . 'screenshot.jpg' ) ) ? hoot_data()->template_uri . 'screenshot.jpg' : (
						( file_exists( hoot_data()->template_dir . 'screenshot.png' ) ) ? hoot_data()->template_uri . 'screenshot.png' : ''
						),
			'fullshot' => ( file_exists( hoot_data()->incdir . 'admin/images/screenshot.jpg' ) ) ? hoot_data()->incuri . 'admin/images/screenshot.jpg' : (
				( file_exists( hoot_data()->incdir . 'admin/images/screenshot.png' ) ) ? hoot_data()->incuri . 'admin/images/screenshot.png' : ''
			),
			'urlhoot'    => 'https://wphoot.com/',
			'urldemo'    => 'https://demosites.wphoot.com/nirvata/',
			'urltheme'   => 'https://wphoot.com/store/nirvata/',
			'urlcdn'     => 'https://cdn.wphoot.com/',
			'urlsupport' => 'https://wphoot.com/support/',
			'urldocs'    => 'https://wphoot.com/support/nirvata/',
		);
		$defaults = apply_filters( 'nirvata_abouttags', $defaults );
		if ( ! is_array( $defaults ) ) $defaults = array();
		global $hootkitmenu;
		if ( $hootkitmenu !== true ) $hootkitmenu = false;

		$tags = array();
		foreach ( array( 'slug', 'vers', 'dashslug', 'dashscreen' ) as $key ) {
			if ( !empty( $defaults[ $key ] ) ) $tags[ $key ] = sanitize_html_class( $defaults[ $key ] );
		}
		foreach ( array( 'dashurl' ) as $key ) {
			if ( !empty( $defaults[ $key ] ) ) $tags[ $key ] = esc_attr( $defaults[ $key ] );
		}
		foreach ( array( 'name', 'dashlabel' ) as $key ) {
			if ( !empty( $defaults[ $key ] ) ) $tags[ $key ] = esc_html( $defaults[ $key ] );
		}
		foreach ( array( 'shot', 'fullshot', 'urlhoot', 'urldemo', 'urltheme', 'urlcdn', 'urlsupport', 'urldocs' ) as $key ) {
			if ( !empty( $defaults[ $key ] ) ) $tags[ $key ] = esc_url( $defaults[ $key ] );
		}
	}
	return ( $index === true ? $tags : ( ( isset( $tags[ $index ] ) ) ? $tags[ $index ] : '' ) );
}

/**
 * HootKit Wrapper function for abouttags
 *
 * @since 1.3.1
 * @param array $config
 * @return string
 */
if ( !function_exists( 'hootkit_theme_abouttags' ) ) :
function hootkit_theme_abouttags( $index = 'slug', $force = false ) {
	return nirvata_abouttag( $index, $force );
}
endif;
