<?php
/**
 * About page
 */

/**
 * Sets up the Appearance Subpage
 *
 * @since 1.0
 * @access public
 * @return void
 */
function nirvata_add_appearance_subpage() {
	global $hootkitmenu;
	if ( $hootkitmenu !== true ) {
		add_theme_page(
			esc_html( hoot_dashboard( 'label' ) ), // Page Title
			esc_html( hoot_dashboard( 'label' ) ), // Menu Title
			'edit_theme_options', // capability
			sanitize_html_class( hoot_dashboard( 'slug' ) ), // menu-slug
			'nirvata_appearance_subpage', // function name
			1 // position
			);
	}
	add_action( 'admin_enqueue_scripts', 'nirvata_admin_enqueue_about_styles' );
}
/* Add the admin setup function to the 'admin_menu' hook. */
add_action( 'admin_menu', 'nirvata_add_appearance_subpage' );

/**
 * Enqueue CSS
 *
 * @since 1.0
 * @access public
 * @return void
 */
function nirvata_admin_enqueue_about_styles( $hook ) {
	if ( $hook === hoot_dashboard( 'screen' ) ) {
		wp_enqueue_style( 'hoot-admin-about', hoot_data()->incuri . 'admin/css/about.css', array(),  hoot_data()->hoot_version );
		wp_enqueue_script( 'hoot-admin-about', hoot_data()->incuri . 'admin/js/about.js', array( 'jquery' ),  hoot_data()->hoot_version, true );
	}
}

/**
 * Display the Appearance Subpage
 *
 * @since 1.0
 * @access public
 * @return void
 */
function nirvata_appearance_subpage() {
	require_once( hoot_data()->incdir . 'admin/about-blocks.php' );

	$abouttags = nirvata_abouttag( true );
	$abouttags = is_array( $abouttags ) ? $abouttags : array();
	$sanetags = array();
	foreach ( array(
		'slug', 'name', 'dashlabel', 'dashslug', 'dashscreen', 'vers', 'shot', 'fullshot', 'urlhoot', 'urldemo', 'urltheme', 'urlcdn', 'urlsupport', 'urldocs'
	) as $key ) {
		$sanetags[ $key ] = isset( $abouttags[ $key ] ) && is_scalar( $abouttags[ $key ] ) ? $abouttags[ $key ] : '';
	}
	$availabletabs = array();
	$tabsarray = apply_filters( 'nirvata_about_load_tabs', array(
		'order' => array( 'premium', 'qstart', 'plugins', 'demoimport', 'hootkit', 'tools', 'code' ),
		'premium'      => array(
			'label'   => __( 'Premium Options', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_upselldata( $sanetags ),
		),
		'qstart'      => array(
			'label'   => __( 'Quick Start', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_qstartdata( $sanetags ),
		),
		'plugins'     => array(
			'label'   => __( 'Recommended Plugins', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_pluginsdata( $sanetags ),
		),
		'demoimport'  => array(
			'label'   => __( 'Pre-built Demo Import', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_require_hootkit( $sanetags, 'demoimport' ),
		),
		'hootkit'     => array(
			'label'   => __( 'HootKit Options', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_require_hootkit( $sanetags, 'hootkit' ),
		),
		'tools'       => array(
			'label'   => __( 'Tools', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_require_hootkit( $sanetags, 'tools', true ),
		),
		'code'        => array(
			'label'   => __( 'Custom Code', 'nirvata' ),
			'inpage'  => true,
			'content' => nirvata_require_hootkit( $sanetags, 'code', true ),
		),
	), $sanetags );
	if ( ! is_array( $tabsarray ) ) $tabsarray = array();
	$order = !empty( $tabsarray['order'] ) && is_array( $tabsarray['order'] ) ? $tabsarray['order'] : array();
	unset( $tabsarray['order'] );
	foreach ( $order as $key ) if ( isset( $tabsarray[ $key ] ) ) { $availabletabs[ $key ] = $tabsarray[ $key ]; }
	foreach ( $tabsarray as $key => $tarr ) if ( ! isset( $availabletabs[ $key ] ) ) { $availabletabs[ $key ] = $tarr; }

	$textlinks = apply_filters( 'nirvata_about_textlinks', array(
		'premium' => array(
			'label' => __( 'View Premium', 'nirvata' ),
			'url' => $sanetags['urltheme'],
			'dashicon' => 'dashboard',
			'standout' => true,
		),
		'demo' => array(
			'label' => __( 'View Demo', 'nirvata' ),
			'url' => $sanetags['urldemo'],
			'dashicon' => 'welcome-view-site',
			'highlight' => true,
		),
		'docs' => array(
			'label' => __( 'Documentation', 'nirvata' ),
			'url' => $sanetags['urldocs'],
			'dashicon' => 'editor-aligncenter',
		),
		'support' => array(
			'label' => __( 'Get Support', 'nirvata' ),
			'url' => $sanetags['urlsupport'],
			'dashicon' => 'sos',
		),
		'rate' => array(
			'label' => __( 'Rate Us', 'nirvata' ),
			'url' => 'https://wordpress.org/support/theme/' . $sanetags['slug'] . '/reviews/#new-post',
			'dashicon' => 'thumbs-up',
		),
	), $sanetags );

	$hasupsell = apply_filters( 'nirvata_load_upsell', true );
	if ( ! $hasupsell ) {
		if ( isset( $availabletabs['premium'] ) )
			unset( $availabletabs['premium'] );
		if ( isset( $textlinks['premium'] ) )
			unset( $textlinks['premium'] );
	}

	// User Hidden
	$hidetabs = get_option( $sanetags['slug'] . '_hidetabs', false );
	$hidetabs = is_array( $hidetabs ) ? $hidetabs : array();
	$needsupdate = false;
	foreach ( array( 'manager', 'plugins', 'demoimport', 'tools', 'code' ) as $key ) {
		$hidekey = !empty( $hidetabs[ $key ] );
		$getchecks = array( $key );
		if ( $key === 'manager' ) $getchecks[] = 'license';
		if ( $key === 'demoimport' ) $getchecks[] = 'import';
		foreach ( $getchecks as $check_key ) {
			if ( isset( $_GET['hide'.$check_key] ) ) {
				$hidekey = $_GET['hide'.$check_key] === 'false' ? false : true;
				$hidetabs[ $key ] = $hidekey;
				$needsupdate = true;
			}
		}
		if ( isset( $availabletabs[ $key ] ) && is_array( $availabletabs[ $key ] ) ) {
			$availabletabs[ $key ]['hideview'] = $hidekey ? true : false;
		}
	}
	if ( $needsupdate )
		update_option( $sanetags['slug'] . '_hidetabs', $hidetabs );
	// User Hidden - Add Note
	$note = array();
	$note[ 'grid-hidenote' ] = array( 'type' => 'gridgen', 'class' => 'hootabt-footnote' );
	$note[ 'hidenote' ] = array(
		'type' => 'columns',
		'columns' => 1,
		'blocks' => array(
			array(
				'name' => '',
				/* Translators: 1 is link start 2 is link end */
				'desc' => sprintf( esc_html__( '%1$sClick here to know how to hide this tab%2$s', 'nirvata' ), '<a href="https://wphoot.com/support/hide-license-tab-in-your-wp-admin" target="_blank">', '</a>' ),
			),
		),
	);
	$note[ 'grid-hidenoteend' ] = array( 'type' => 'gridgenend' );
	foreach ( array( 'manager' ) as $key ) {
		if ( isset( $availabletabs[ $key ] ) && is_array( $availabletabs[ $key ] ) ) {
			$availabletabs[ $key ]['content'] = !empty( $availabletabs[ $key ]['content'] ) && is_array( $availabletabs[ $key ]['content'] ) ? array_merge( $availabletabs[ $key ]['content'], $note ) : array();
		}
	}
	foreach ( array( 'demoimport', 'hootkit' ) as $key ) {
		if ( isset( $availabletabs[ $key ] ) ) unset( $availabletabs[ $key ] );
	}

	// Finally, active tab
	$activetab = !empty( $_GET['tab'] ) && array_key_exists( $_GET['tab'], $availabletabs ) ? $_GET['tab'] : 'qstart';//
	?>
	<div id="hootabt-wrap" class="hootabt-wrap<?php
		if ( class_exists( 'HootKit' ) ) echo ' hootabt-hashootkit';
		if ( !empty( $_GET['demo'] ) ) echo ' hootabt-hkimp-multisingle'; else echo ' hootabt-hkimp-multi';
		if ( !empty( $availabletabs[$activetab] ) && is_array( $availabletabs[$activetab] ) && !empty( $availabletabs[$activetab]['widen'] ) ) echo ' hootabt-widen';
	?>">

		<div id="hootabt-header" class="hootabt-header">
			<div class="hootabt-gridflex">
				<h3><?php 
					$img = file_exists( hoot_data()->incdir . 'admin/images/logo.png' ) ?
							hoot_data()->incuri . 'admin/images/logo.png' : (
								file_exists( hoot_data()->incdir . 'admin/images/logo.jpg' ) ?
								hoot_data()->incuri . 'admin/images/logo.jpg' : ''
							);
					echo ( !empty( $img ) ) ? '<img src="' . esc_url( $img ) . '" alt="' . esc_attr( $sanetags['name'] ) . '" /> ' : esc_html( $sanetags['name'] );
				?></h3>
				<div class="hootabt-textlinks"><?php
					foreach ( $textlinks as $textlink ) {
						if ( !empty( $textlink['label'] ) && !empty( $textlink['url'] ) ) {
							$highlightclass = !empty( $textlink['highlight'] ) ? ' hootabt-highlight' :
											( !empty( $textlink['standout'] )  ? ' hootabt-standout'  : '' );
							echo '<a class="button ' . esc_attr( $highlightclass ) . '" href="' . esc_url( $textlink['url'] ) . '" target="_blank">';
							if ( !empty( $textlink['dashicon'] ) ) {
								echo '<span class="dashicons dashicons-' . esc_attr( $textlink['dashicon'] ) . '"></span> ';
							}
							echo esc_html( $textlink['label'] ) . '</a>';
						}
					}
				?></div>
			</div>
		</div>

		<div id="hootabt-tabs" class="hootabt-tabs">
			<div class="hootabt-gridconbox">
				<?php foreach ( $availabletabs as $tabid => $tabarray ) :
					if ( ! is_array( $tabarray ) ) continue;
					echo '<a' .
							' href="' . esc_url( hoot_dashboard( 'url', array( 'tab' => $tabid ) ) ) . '"' .
							' class="hootabt-tab' . ( $activetab === $tabid ? ' hootabt-active' : '' ) . '"' .
							( !empty( $tabarray['inpage'] ) ? ' data-inpage="' . esc_attr( $tabid ) . '"' : '' ) .
							( !empty( $tabarray['widen'] ) ? ' data-widen="1"' : '' ) .
							( !empty( $tabarray['hideview'] ) ? ' style="display:none !important"' : '' ) .
							'>';
						if ( !empty( $tabarray['label'] ) ) echo esc_html( $tabarray['label'] );
					echo '</a>';
				endforeach; ?>
			</div>
		</div>

		<?php foreach ( $availabletabs as $tabid => $tabarray ) : ?>
			<div id="hootabt-<?php echo esc_attr( $tabid ); ?>" class="hootabt-module hootabt-<?php echo esc_attr( $tabid ); ?> <?php if ( $activetab === $tabid ) echo esc_attr( 'hootabt-active' ); ?>">
				<?php
				if ( !empty( $tabarray[ 'content' ] ) && is_array( $tabarray[ 'content' ] ) ) {
					foreach ( $tabarray[ 'content' ] as $blockid => $modblock ) {
						nirvata_display_modblock( $blockid, $modblock, $sanetags, $tabid );
					}
				} elseif ( !empty( $tabarray[ 'content' ] ) && is_string( $tabarray[ 'content' ] ) ) {
					do_action( $tabarray[ 'content' ], $sanetags, $tabid, 'nirvata_display_modblock' );
				} else {
					echo '<div class="hootabt-gridbox">' . esc_html__( 'Content not available.', 'nirvata' ) . '</div>';
				} ?>
			</div>
		<?php endforeach; ?>

		<a class="hootabt-top" href="#hootabt-header"><span class="dashicons dashicons-arrow-up-alt"></span></a>
	</div>
	<?php
}

/**
 * Display Module Block Template
 */
function nirvata_display_modblock( $blockid, $modblock, $sanetags, $tabid ) {
	if ( empty( $modblock ) || ! is_array( $modblock ) ) {
		return;
	}
	$modblock['type'] = isset( $modblock['type'] ) ? $modblock['type'] : 'undefined';
	$sanetags = is_array( $sanetags ) ? $sanetags : array();

	switch ( $modblock['type'] ) {
		case 'gridgen':
		case 'gridbox':
		case 'gridconbox':
		case 'gridflex':
			$class = 'hootabt-' . $modblock['type'] . ' hootabt-blockid--' . $blockid;
			$class .= isset( $modblock['class'] ) ? ' ' . $modblock['class'] : '';
			echo '<div class="' . hoot_sanitize_html_classes( $class ) . '">';
			break;
		case 'gridgenend':
		case 'gridboxend':
		case 'gridconboxend':
		case 'gridflexend':
			echo '</div>';
			break;
		case 'notice':
			nirvata_display_notice( $blockid, $modblock, $sanetags, $tabid );
			break;
		case 'introexit':
		case 'hero-top':
		case 'side-left': case 'side-right': case 'side':
		case 'aside':
		case 'std':
		case 'columns':
			$ctype = $modblock['type'] === 'side-left' || $modblock['type'] === 'side-right' ? 'side' : $modblock['type'];
			$class = 'hootabt-blocktype--' . $ctype . ' hootabt-blockid--' . $blockid;
			echo '<div class="hootabt-blocktype ' . hoot_sanitize_html_classes( $class ) . '">';
				switch ( $modblock['type'] ) {
					case 'introexit': nirvata_display_introexit( $blockid, $modblock, $sanetags, $tabid ); break;
					case 'hero-top':       nirvata_display_hero( $blockid, $modblock, $sanetags, $tabid ); break;
					case 'side-left': case 'side-right':
					case 'side':           nirvata_display_side( $blockid, $modblock, $sanetags, $tabid ); break;
					case 'aside':         nirvata_display_aside( $blockid, $modblock, $sanetags, $tabid ); break;
					case 'std':             nirvata_display_std( $blockid, $modblock, $sanetags, $tabid ); break;
					case 'columns':     nirvata_display_columns( $blockid, $modblock, $sanetags, $tabid ); break;
				}
			echo '</div>';
			break;
		default:
			$ctype = $modblock['type'];
			$class = 'hootabt-blocktype--' . $ctype . ' hootabt-blockid--' . $blockid;
			echo '<div class="hootabt-blocktype ' . hoot_sanitize_html_classes( $class ) . '">';
				do_action( 'nirvata_display_modblock_content', $blockid, $modblock, $sanetags, $tabid );
			echo '</div>';
			break;
	}

}

function nirvata_display_notice( $blockid, $block, $sanetags, $tabid ) {
	$src = isset( $block['src'] ) ? $block['src'] : 'text';
	$text = isset( $block['text'] ) && is_string( $block['text'] ) ? $block['text'] : false;
	$action = isset( $block['action'] ) && is_string( $block['action']) ? $block['action'] : false;
	$gridtype = !empty( $block['gridtype'] ) && is_string( $block['gridtype'] ) ? $block['gridtype'] : 'gen';

	echo '<div class="hootabt-grid' . $gridtype . '">';
		$ctype = $block['type'];
		$class = 'hootabt-blocktype--' . $ctype . ' hootabt-blockid--' . $blockid;
		echo '<div class="hootabt-blocktype ' . hoot_sanitize_html_classes( $class ) . '">';
			if ( $src === 'action' ) {
				if ( $action ) do_action( $action, $blockid, $block, $sanetags, $tabid );
			} else {
				if ( $text ) echo wp_kses_post( $text );
			}
		echo '</div>';
	echo '</div>';
}

function nirvata_display_introexit( $blockid, $block, $sanetags, $tabid ) {
	?><div class="hootabt-gridgen"><?php
		?><div class="hootabt-blocktext"><?php
			if ( !empty( $block['name'] ) ) {
				echo '<h2 class="hootabt-blocktitle">' . wp_kses_post( $block['name'] ) . '</h2>';
			}
			if ( !empty( $block['desc'] ) ) {
				echo '<p class="hootabt-blockdesc">' . wp_kses_post( $block['desc'] ) . '</p>';
			}
			if ( !empty( $block['cta'] ) && is_array( $block['cta'] ) ) : ?>
				<p class="hootabt-blockcta">
					<?php foreach ( $block['cta'] as $ctatype ) : switch( $ctatype ) {
						case 'demo':
							echo '<a class="button button-secondary hootabt-blockcta-btn" href="' . esc_url( $sanetags['urldemo'] ) . '" target="_blank"><span class="dashicons dashicons-welcome-view-site"></span> ' . esc_html__( 'View Demo Site', 'nirvata' ) . '</a>';
							break;
						case 'premium':
							/* Translators: 1 is the theme name */
							echo '<a class="button button-primary hootabt-blockcta-btn" href="' . esc_url( $sanetags['urltheme'] ) . '" target="_blank"><span class="dashicons dashicons-dashboard"></span> ' . sprintf( esc_html__( 'View %1$s Premium', 'nirvata' ), $sanetags['name'] ) . '</a>';
							break;
						case 'docs':
							echo '<a class="button button-primary hootabt-blockcta-btn" href="' . esc_url( $sanetags['urldocs'] ) . '" target="_blank"><span class="dashicons dashicons-editor-aligncenter"></span> ' . esc_html__( 'View Full Documentation', 'nirvata' ) . '</a>';
							break;
						case 'support':
							echo '<a class="button button-secondary hootabt-blockcta-btn" href="' . esc_url( $sanetags['urlsupport'] ) . '" target="_blank"><span class="dashicons dashicons-sos"></span> ' . esc_html__( 'Get Support', 'nirvata' ) . '</a>';
							break;
						default:
							continue 2;
					} endforeach; ?>
				</p>
			<?php endif;
		?></div><?php
	?></div><?php
}

function nirvata_display_hero( $blockid, $block, $sanetags, $tabid ) {
	?><div class="hootabt-gridgen"><?php
		if ( !empty( $block['name'] ) || !empty( $block['desc'] ) ) :
			?><div class="hootabt-blocktext"><?php
				if ( !empty( $block['name'] ) ) {
					echo '<h4 class="hootabt-blocktitle">';
						echo wp_kses_post( $block['name'] );
						if ( $tabid === 'premium' ) echo '<cite><span>' . esc_html__( '* Premium Feature', 'nirvata' ) . '</span></cite>';
					echo '</h4>';
				}
				if ( !empty( $block['desc'] ) )
					echo '<div class="hootabt-blockdesc">' . wp_kses_post( $block['desc'] ) . '</div>';
			?></div><?php
		endif;
		if ( !empty( $block['img'] ) )
			echo ' <div class="hootabt-blockimg">' . '<img src="' . esc_url( $block['img'] ) . '" />' . '</div>';
	?></div><?php
}

function nirvata_display_side( $blockid, $block, $sanetags, $tabid ) {
	$isright = isset( $block['type'] ) && $block['type'] === 'side-right';
	$img = ''; $imgloc = '';
	    if ( !empty( $block['img-top']    ) ) { $img = $block['img-top'];    $imgloc = 'img-top';    }
	elseif ( !empty( $block['img-bottom'] ) ) { $img = $block['img-bottom']; $imgloc = 'img-bottom'; }
	?><div class="hootabt-gridflex <?php echo ( $isright ? 'hootsideright' : 'hootsideleft' ); ?> <?php if ( $imgloc ) echo sanitize_html_class( 'hootside-' . $imgloc ); ?>"><?php

		if ( !empty( $block['img'] ) )
			echo ' <div class="hootabt-blockimg">' . '<img src="' . esc_url( $block['img'] ) . '" />' . '</div>';

		if ( !empty( $block['name'] ) || !empty( $block['desc'] ) ) :
			?><div class="hootabt-blocktext"><?php
				if ( !empty( $block['name'] ) ) {
					echo '<h4 class="hootabt-blocktitle">';
						echo wp_kses_post( $block['name'] );
						if ( $tabid === 'premium' ) echo '<cite><span>' . esc_html__( '* Premium Feature', 'nirvata' ) . '</span></cite>';
					echo '</h4>';
				}
				if ( !empty( $block['desc'] ) )
					echo '<div class="hootabt-blockdesc">' . wp_kses_post( $block['desc'] ) . '</div>';
			?></div><?php
		endif;

		if ( !empty( $img ) )
			echo ' <div class="hootabt-blockimg hootside-img">' . '<img src="' . esc_url( $img ) . '" />' . '</div>';

	?></div><?php
}

function nirvata_display_aside( $blockid, $block, $sanetags, $tabid ) {
	$img = ''; $imgloc = '';
	    if ( !empty( $block['img']        ) ) { $img = $block['img'];        $imgloc = 'img-top';    }
	elseif ( !empty( $block['img-top']    ) ) { $img = $block['img-top'];    $imgloc = 'img-top';    }
	elseif ( !empty( $block['img-bottom'] ) ) { $img = $block['img-bottom']; $imgloc = 'img-bottom'; }
	?><div class="hootabt-gridflex <?php if ( $imgloc ) echo sanitize_html_class( 'hootaside-' . $imgloc ); ?>"><?php

		if ( !empty( $block['blocks'] ) && is_array( $block['blocks'] ) ) {
			foreach ( $block['blocks'] as $subblock ) {
				if ( ! is_array( $subblock ) ) continue;
				?><div class="hootaside-block"><?php
					if ( !empty( $subblock['img'] ) )
						echo ' <div class="hootabt-blockimg">' . '<img src="' . esc_url( $subblock['img'] ) . '" />' . '</div>';

					if ( !empty( $subblock['name'] ) || !empty( $subblock['desc'] ) ) :
						?><div class="hootabt-blocktext"><?php
							if ( !empty( $subblock['name'] ) ) {
								echo '<h4 class="hootabt-blocktitle">';
									echo wp_kses_post( $subblock['name'] );
									if ( $tabid === 'premium' ) echo '<cite><span>' . esc_html__( '* Premium Feature', 'nirvata' ) . '</span></cite>';
								echo '</h4>';
							}
							if ( !empty( $subblock['desc'] ) )
								echo '<div class="hootabt-blockdesc">' . wp_kses_post( $subblock['desc'] ) . '</div>';
						?></div><?php
					endif;
				?></div><?php
			}
		}

		if ( $img )
			echo ' <div class="hootabt-blockimg hootaside-img">' . '<img src="' . esc_url( $img ) . '" />' . '</div>';

	?></div><?php
}

function nirvata_display_std( $blockid, $block, $sanetags, $tabid ) {
	$img = ''; $imgloc = '';
	    if ( !empty( $block['img']        ) ) { $img = $block['img'];        $imgloc = 'img-top';    }
	elseif ( !empty( $block['img-top']    ) ) { $img = $block['img-top'];    $imgloc = 'img-top';    }
	elseif ( !empty( $block['img-bottom'] ) ) { $img = $block['img-bottom']; $imgloc = 'img-bottom'; }
	?><div class="hootabt-gridflex <?php if ( $imgloc ) echo sanitize_html_class( 'hootstd-' . $imgloc ); ?>"><?php

		if ( $img )
			echo ' <div class="hootabt-blockimg hootstd-img">' . '<img src="' . esc_url( $img ) . '" />' . '</div>';

		if ( !empty( $block['name'] ) || !empty( $block['desc'] ) ) :
			?><div class="hootabt-blocktext hootabt-gridflex"><?php
				if ( !empty( $block['name'] ) ) {
					echo '<h4 class="hootabt-blocktitle">';
						echo wp_kses_post( $block['name'] );
						if ( $tabid === 'premium' ) echo '<cite><span>' . esc_html__( '* Premium Feature', 'nirvata' ) . '</span></cite>';
					echo '</h4>';
				}
				if ( !empty( $block['desc'] ) )
					echo '<div class="hootabt-blockdesc">' . wp_kses_post( $block['desc'] ) . '</div>';
			?></div><?php
		endif;

	?></div><?php
}

function nirvata_display_columns( $blockid, $block, $sanetags, $tabid ) {
	$cols = !empty( $block['columns'] ) ? $block['columns'] : 0;
	$cols = intval( $cols );
	$cols = $cols < 1 || $cols > 3 ? 2 : $cols;
	?><div class="hootcolumns <?php echo sanitize_html_class( 'hootcolumns-' . $cols ); ?>"><?php
		if ( !empty( $block['blocks'] ) && is_array( $block['blocks'] ) ) {
			foreach ( $block['blocks'] as $subblock ) {
				if ( ! is_array( $subblock ) ) continue;
				?><div class="hootcol-block <?php if ( !empty( $subblock['class'] ) ) echo sanitize_html_class( $subblock['class'] ); ?>"><?php
					$cta = !empty( $subblock['cta'] ) && is_array( $subblock['cta'] ) && !empty( $subblock['cta']['url'] ) ? $subblock['cta'] : array();
					if ( !empty( $subblock['name'] ) || !empty( $subblock['desc'] ) || !empty( $cta ) ) :
						?><div class="hootabt-blocktext"><?php
							if ( !empty( $subblock['name'] ) ) {
								echo '<h4 class="hootabt-blocktitle">';
									echo wp_kses_post( $subblock['name'] );
									if ( $tabid === 'premium' ) echo '<cite><span>' . esc_html__( '* Premium Feature', 'nirvata' ) . '</span></cite>';
								echo '</h4>';
							}
							if ( !empty( $subblock['desc'] ) )
								echo '<div class="hootabt-blockdesc">' . wp_kses_post( $subblock['desc'] ) . '</div>';
							if ( !empty( $cta['url'] ) ) {
								echo '<div class="hootabt-blockfooter">';
								$ctaclass = !empty( $cta['button'] ) ? 'button button-' . $cta['button'] : '';
								$ctaclass .= !empty( $cta['class'] ) ? ' ' . $cta['class'] : '';
								$ctatext = !empty( $cta['text'] ) ? $cta['text'] : '';
								echo '<a href="' . esc_url( $cta['url'] ) . '" class="' . hoot_sanitize_html_classes( $ctaclass ) . '" target="' . ( !empty( $cta['target'] ) ? esc_attr( $cta['target'] ) : '_self' ) . '"';
									if ( !empty( $cta['data-attr'] ) && is_array( $cta['data-attr'] ) )
										foreach ( $cta['data-attr'] as $data_key => $data_value )
											echo ' data-' . esc_attr( $data_key ) . '="' . esc_attr( $data_value ) . '"';
									echo '>' . wp_kses_post( $ctatext ) . '</a>';
								echo '</div>';
							}
						?></div><?php
					endif;
				?></div><?php
			}
		}
	?></div><?php
}
