<?php
/**
 * About page content
 */

function nirvata_upselldata( $sanetags ) {
	$ublocks = array();
	$imagepath =  esc_url( hoot_data()->incuri . 'admin/images/' );
	$themename = !empty( $sanetags['name'] ) ? $sanetags['name'] : '';
	$urldemo = !empty( $sanetags['urldemo'] ) ? $sanetags['urldemo'] : '';

	$cc= 1;

	$ublocks[ 'grid-intro' ] = array( 'type' => 'gridbox' );

	$ublocks[ 'introwrap' ] = array(
		'type' => 'introexit',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Do more with %2$s%1$s %3$sPremium%4$s%5$s', 'nirvata' ), $themename, '<span>', '<strong>', '</strong>', '</span>' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'If you have enjoyed using %1$s, you are going to love %2$s%1$s Premium%3$s.%4$sIt is a robust upgrade to %1$s that gives you many useful features.', 'nirvata' ), $themename, '<strong>', '</strong>', '<br />' ),
		'cta' => array( 'demo', 'premium' ),
		);

	$ublocks[ 'grid-introend' ] = array( 'type' => 'gridboxend' );

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'style' ] = array(
		'type' => 'hero-top',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Complete %1$sStyle %2$sCustomization%3$s', 'nirvata' ), '<br />', '<strong>', '</strong>' ),
		/* Translators: 1 is the theme name */
		'desc' => sprintf( esc_html__( 'Explore a wide range of customization options in %1$s Premium to create a unique website that matches your vision. Give your site the personality it deserves with diverse styling possibilities.', 'nirvata' ), $themename ),
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'colors' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Custom Colors &amp; Backgrounds for Sections', 'nirvata' ),
		/* Translators: 1 is the theme name */
		'desc' => sprintf( esc_html__( 'Tailor your site\'s design by assigning custom colors and backgrounds to different site sections like the header, footer, logo area, menu dropdown, content area, page title sections, etc.%2$s%3$sClick here to see example of custom colors/styles applied using Premium Options%4$s', 'nirvata' ), $themename, '<hr>', '<a href="' . esc_url( $urldemo ) . 'style-customization-typography/" target="_blank">', '</a>' ),
		'img' => $imagepath . 'premium-colors.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'typo' ] = array(
		'type' => 'std',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Fonts and %1$sTypography Control%2$s', 'nirvata' ), '<span>', '</span>' ),
		'desc' => esc_html__( "Customize your site's typography by assigning different fonts, sizes, and colors to elements like the menu, topbar, logo, content headings, sidebar, footer, etc.", 'nirvata' ),
		'img' => $imagepath . 'premium-typography.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'gfonts' ] = array(
		'type' => 'std',
		'name' => esc_html__( '600+ Google Fonts', 'nirvata' ),
		'desc' => esc_html__( "With access to over 600 Google Fonts, you can easily select the perfect fonts to match your site's unique personality and style.", 'nirvata' ),
		'img' => $imagepath . 'premium-googlefonts.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'sliders' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Unlimites Sliders, Unlimites Slides', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Create unlimited sliders with as many slides as you need using the powerful HootKit plugin in %1$s Premium.%2$sShowcase custom images with text, create carousels, or even display vertical sliding lists for posts and WooCommerce products.', 'nirvata' ), $themename, '<hr>' ),
		'img' => $imagepath . 'premium-sliders.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'carousels' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Image Carousels', 'nirvata' ),
		'desc' => esc_html__( 'Easily add carousel widgets to your posts, sidebar, front page, or footer. The drag-and-drop interface makes creating and managing carousels simple and hassle-free.', 'nirvata' ),
		'img' => $imagepath . 'premium-carousels.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'bloglayouts' ] = array(
		'type' => 'std',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Additional Blog Layouts (including pinterest type mosaic)', 'nirvata' ), '<span>', '</span>' ),
		/* Translators: 1 is the theme name */
		'desc' => sprintf( esc_html__( '%1$s Premium offers various layout options for your post archives, including a stunning mosaic-style layout inspired by Pinterest.', 'nirvata' ), $themename ),
		'img' => $imagepath . 'premium-blogstyles.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'widgets' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Custom Widgets', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Unlock additional HootKit custom widgets crafted exclusively for %1$s Premium to enhance your site\'s content presentation.%2$sUse widgets like Buttons, Carousel Sliders, Carousel Posts Slider, Contact Info, Icon Lists, Notices, Number Blocks, Tabs, Toggles, Vcards, and more for a polished, professional look.', 'nirvata' ), $themename, '<hr>' ),
		'img' => $imagepath . 'premium-widgets.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'menuicons' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Menu Icons', 'nirvata' ),
		'desc' => esc_html__( 'Choose from over 900 icons to enhance your main navigation menu links.', 'nirvata' ),
		'img' => $imagepath . 'premium-menuicons.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'bgpatts' ] = array(
		'type' => 'std',
		'name' => esc_html__( '125+ Premium Background Patterns', 'nirvata' ),
		/* Translators: 1 is the theme name */
		'desc' => sprintf( esc_html__( '%1$s Premium includes a curated collection of additional premium background patterns to elevate your site\'s design. You can also upload custom background images or patterns to perfectly match your site\'s design.', 'nirvata' ), $themename ),
		'img' => $imagepath . 'premium-backgrounds.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'lightbox' ] = array(
		'type' => 'std',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Automatic Image Lightbox and %1$sWordPress Gallery%2$s', 'nirvata' ), '<span>', '</span>' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Enable seamless automatic lightbox functionality for image links with %1$s Premium.%2$sAutomatically transform standard WordPress galleries into stunning sliders in a lightbox for a more dynamic visual experience.', 'nirvata' ), $themename, '<hr>' ),
		'img' => $imagepath . 'premium-lightbox.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'metaoptions' ] = array(
		'type' => 'side',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Post & Page %1$sSpecific Settings%2$s', 'nirvata' ), '<span>', '</span>' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => esc_html__( 'Optionally override global Customizer settings for an individual Post or Page. Adjust the sidebar layout, hide the title area, change feature image display, article background and width, add custom CSS, and configure other settings for each post or page.', 'nirvata' ),
		'img' => $imagepath . 'premium-postmeta.jpg',
		'img-bottom' => $imagepath . 'premium-metaoptions.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'custom404' ] = array(
		'type' => 'side',
		'name' => esc_html__( 'Custom 404 Error Page', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Ditch the boring "Not Found" error page! With %1$s Premium, design a custom 404 error page with tailored messages, images, and links to keep your visitors engaged and guide them back to your content.', 'nirvata' ), $themename ),
		'img' => $imagepath . 'premium-404.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'customcode' ] = array(
		'type' => 'aside',
		'img-bottom' => $imagepath . 'premium-customcode.jpg',
		'blocks' => array(
			array(
				'name' => esc_html__( 'Custom Javascript', 'nirvata' ),
				'desc' => esc_html__( "Easily add custom JavaScript snippets to your header without touching the core code files. Whether it's Google Analytics, AdSense, or any custom code, you can add it effortlessly.", 'nirvata' ),
				'img' => $imagepath . 'premium-customjs.jpg',
				),
			array(
				'name' => esc_html__( 'Custom PHP Snippets', 'nirvata' ),
				'desc' => esc_html__( 'Easily add PHP code from wp-admin without editing core files, creating custom plugins, or using child themes. Your snippets stay safe and intact when you update the theme.', 'nirvata' ),
				'img' => $imagepath . 'premium-customphp.jpg',
				),
			),
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'tools' ] = array(
		'type' => 'aside',
		'blocks' => array(
			array(
				'name' => esc_html__( 'Developers love {SCSS}', 'nirvata' ),
				/* Translators: 1 is the theme name */
				'desc' => sprintf( esc_html__( 'SCSS offers modularity and flexibility, making it a favorite for developers. %1$s Premium includes well-structured SCSS files for effortless customization and styling.', 'nirvata' ), $themename ),
				'img' => $imagepath . 'premium-scss.jpg',
				),
			array(
				'name' => esc_html__( 'Easy Import/Export', 'nirvata' ),
				'desc' => esc_html__( 'Switching hosts or applying a new child theme? Import or export your customizer settings in just a few clicks directly from the backend, making transitions seamless.', 'nirvata' ),
				'img' => $imagepath . 'premium-import-export.jpg',
				),
			),
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'updates' ] = array(
		'type' => 'std',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => sprintf( esc_html__( 'Continued %1$sLifetime Updates', 'nirvata' ), '<br />' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Active development of %1$s ensures your theme stays compatible with future WordPress versions for years to come so you don\'t have to worry about a broken website after an update.', 'nirvata' ), $themename ),
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'support' ] = array(
		'type' => 'std',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'name' => esc_html__( 'Priority Support', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Need assistance setting up %1$s? Upgrade to %1$s Premium for priority support from our growing team, ready to answer your questions.%2$sLooking for small modifications? Even if you\'re not a developer, our support staff can provide CSS snippets to help you achieve your desired look, and your changes will remain intact across updates.', 'nirvata' ), $themename, '<hr>' ),
		'img' => $imagepath . 'premium-support.jpg',
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$ublocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$ublocks[ 'exit' ] = array(
		'type' => 'introexit',
		'cta' => array( 'demo', 'premium' ),
		);
	$ublocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	return $ublocks;
}

function nirvata_qstartdata( $sanetags ) {
	$qblocks = array();
	$imagepath =  esc_url( hoot_data()->incuri . 'admin/images/' );
	$slug = !empty( $sanetags['slug'] ) ? $sanetags['slug'] : '';
	$themename = !empty( $sanetags['name'] ) ? $sanetags['name'] : '';

	$cc= 1;

	$widgetslink = admin_url( 'widgets.php' );
	$customizelink = admin_url( 'customize.php' );
	$menulink = admin_url( 'nav-menus.php' );
	$settinglink = admin_url( 'options-reading.php' );
	$addpagelink = admin_url( 'post-new.php?post_type=page' );

	$qblocks[ 'grid-qblobs' ] = array( 'type' => 'gridgen' );
	$qblocks[ 'qblobs' ] = array(
		'type' => 'columns',
		'columns' => 3,
		'blocks' => array(
			array(
				'name' => '<span class="dashicons dashicons-admin-plugins"></span> ' . esc_html__( 'Install Plugins', 'nirvata' ),
				/* Translators: 1 is the theme name */
				'desc' => sprintf( esc_html__( 'Pair %1$s with its free plugins. Get additional features and customization options to fine-tune your site\'s design.', 'nirvata' ), $themename ),
				'class' => 'hootabt-highlight',
				'cta' => ! class_exists( 'HootKit' ) ? array(
						'url' => hoot_dashboard( 'url', array( 'tab' => 'plugins' ) ),
						'text' => esc_html__( 'Install Plugins', 'nirvata' ),
						'button' => 'secondary',
						'class' => 'hootabt-shortcut',
						'data-attr' => array( 'inpage' => 'plugins' ),
					) : array(
						'url' => '#',
						'text' => '<span class="dashicons dashicons-yes"></span> ' . esc_html__( 'Installed', 'nirvata' ),
						'button' => 'secondary',
						'class' => 'hootabt-success',
					),
			),
			array(
				'name' => '<span class="dashicons dashicons-art"></span> ' . esc_html__( 'Import a Ready-Made Website', 'nirvata' ),
				'desc' => esc_html__( 'Skip the setup hassle. Import a complete demo site in 1-click and start customizing right away.', 'nirvata' ),
				'class' => 'hootabt-standout',
				'cta' => array(
					'url' => ! class_exists( 'HootImport' ) ? hoot_dashboard( 'url', array( 'tab' => 'plugins' ) ) : admin_url( 'themes.php?page=hoot-import' ),
					'text' => esc_html__( 'Import Demo', 'nirvata' ),
					'button' => 'secondary',
					'class' => 'hootabt-shortcut',
					'data-attr' => ! class_exists( 'HootImport' ) ? array( 'inpage' => 'plugins' ) : array(),
				),
			),
			array(
				'name' => '<span class="dashicons dashicons-awards"></span> ' . esc_html__( 'Upload Brand Logo', 'nirvata' ),
				'desc' => esc_html__( 'Start branding your new site by uploading your logo. Just add your logo and tweak default theme colors to match your brand.', 'nirvata' ),
				'class' => 'hootabt-highlight',
				'cta' => array(
					'url' => $customizelink . '?autofocus[section]=logo',
					'text' => esc_html__( 'Upload Logo', 'nirvata' ),
					'button' => 'secondary',
					'target' => '_blank',
				),
			),
		),
	);
	$qblocks[ 'grid-qblobsend' ] = array( 'type' => 'gridgenend' );

	$qblocks[ 'grid-intro' ] = array( 'type' => 'gridbox' );

	$qblocks[ 'introwrap' ] = array(
		'type' => 'introexit',
		'name' => '<img draggable="false" role="img" class="emoji" src="https://s.w.org/images/core/emoji/16.0.1/svg/1f4dd.svg" /> ' . esc_html__( 'Quick Start Guide', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'Follow these steps to quickly start developing your site.%1$sTo read the full documentation, or to get support from one of our support ninjas, click the buttons below.', 'nirvata' ), '<br />' ),
		'cta' => array( 'docs', 'support' ),
		);

	$qblocks[ 'grid-introend' ] = array( 'type' => 'gridboxend' );

	$qblocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$qblocks[ 'setupmenu' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Setup Main Navigation Menu', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( '%1$s
			%3$sGo to %10$swp-admin > Appearance > Menus%12$s%4$s
			%3$sClick on %5$screate a new menu%6$s. %9$s%7$s(If you already have an existing menu, jump to Step 6)%8$s%4$s
			%3$sGive your menu a name and click %5$sCreate Menu%6$s%4$s
			%3$sNow add the menu items you want to this menu.%4$s
			%3$sClick %5$sSave Menu%6$s%4$s
			%3$sClick %11$sManage Locations%12$s tab at the top%4$s
			%3$sSelect the menu you just created in the dropdown options.%4$s
			%3$sClick %5$sSave Changes%6$s%4$s
			%2$s
			', 'nirvata' ), '<ol>', '</ol>', '<li>', '</li>', '<strong>', '</strong>', '<em>', '</em>', '<br />',
										'<a href="' . esc_url( $menulink ) . '" target="_blank">',
										'<a href="' . esc_url( $menulink ) . '?action=locations" target="_blank">',
										'</a>'
				),
		);
	$qblocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$qblocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$qblocks[ 'fpblog' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Setup Frontpage and Blog Page', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( 'By default WordPress displays blog posts on the frontpage.%9$s%9$sHowever many users want a dedicated frontpage to welcome visitors and a separate page to display their blog posts. To set this up, follow these steps:%9$s%1$s
			%3$s%11$sCreate a New Page%12$s and lets give it the title %5$s"My Home Page"%6$s%4$s
			%3$s%11$sCreate another Page%12$s and lets give it the title %5$s"My Blog"%6$s%4$s
			%3$sGo to %10$swp-admin > Settings > Reading%12$s%4$s
			%3$sSelect the %5$sStatic Page%6$s option.%4$s
			%3$sSelect the pages you created above.%4$s
			%3$s%5$sSave%6$s the Changes.%4$s
			%2$s%7$s%5$sTip:%6$s You can add your new "My Home Page" and "My Blog" pages to the main menu we created in the above section.%8$s
			', 'nirvata' ), '<ol>', '</ol>', '<li>', '</li>', '<strong>', '</strong>', '<em>', '</em>', '<br />',
										'<a href="' . esc_url( $settinglink ) . '" target="_blank">',
										'<a href="' . esc_url( $addpagelink ) . '" target="_blank">',
										'</a>'
				),
		'img-bottom' => $imagepath . 'qstart-staticpage.png',
		);
	$qblocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$qblocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$qblocks[ 'fpcontent' ] = array(
		'type' => 'std',
		'name' => esc_html__( 'Add Content to Frontpage', 'nirvata' ),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'desc' => sprintf( esc_html__( '%1$s
			%3$sGo to %10$swp-admin > Appearance > Widgets%12$s%4$s
			%3$sAdd Widgets to the %5$sFrontpage Widget Areas%6$s%4$s
			%3$sYou can further manage Frontpage modules in %11$swp-admin > Appearance > Customizer > Frontpage Modules%12$s.%4$s
			%2$s
			%13$sExample: Display a full width slider%14$s
			To display a full width slider on your frontpage, set one of the Frontpage Module to full width in %11$sCustomizer > Frontpage Modules%12$s.%9$sNow go to the %10$sWidgets%12$s screen and add a %5$sHootKit Slider%6$s widget to this area.
			', 'nirvata' ), '<ol>', '</ol>', '<li>', '</li>', '<strong>', '</strong>', '<em>', '</em>', '<hr>',
										'<a href="' . esc_url( $widgetslink ) . '" target="_blank">',
										'<a href="' . esc_url( $customizelink ) . '?autofocus[section]=frontpage" target="_blank">',
										'</a>', '<h4>', '</h4>'
				),
		'img-bottom' => $imagepath . 'qstart-fpmodule.png',
		);
	$qblocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	$qblocks[ 'grid-con'.$cc ] = array( 'type' => 'gridconbox' );
	$qblocks[ 'exit' ] = array(
		'type' => 'introexit',
		'cta' => array( 'docs', 'support' ),
		);
	$qblocks[ 'grid-conend'.$cc ] = array( 'type' => 'gridconboxend' ); $cc++;

	return $qblocks;
}

function nirvata_pluginsdata( $sanetags ) {
	$pblocks = array();
	$slug = !empty( $sanetags['slug'] ) ? $sanetags['slug'] : '';

	$pblocks[ 'grid-qblobs' ] = array( 'type' => 'gridgen' );
	$pblocks[ 'pblobs' ] = array(
		'type' => 'columns',
		'columns' => 2,
		'blocks' => array(
			array(
				'name' => esc_html__( 'HootKit', 'nirvata' ),
				/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
				'desc' => sprintf( esc_html__( 'This plugin adds widgets and sliders developed and styled specifically for the theme.%3$s%1$sView Details on wordpress.org%2$s', 'nirvata' ), '<a href="https://wordpress.org/plugins/hootkit/" target="_blank">', '</a>', '<hr>' ),
				'cta' => ! class_exists( 'HootKit' ) ? array(
						'url' => admin_url( 'plugin-install.php?s=hootkit&tab=search&type=term' ),
						'text' => file_exists( WP_PLUGIN_DIR . '/hootkit/hootkit.php' ) ? esc_html__( 'Activate HootKit', 'nirvata' ) : esc_html__( 'Install HootKit', 'nirvata' ),
						'button' => 'primary',
						'class' => 'hoot-btn-processplugin hoot-btn-smallmsg',
						'data-attr' => array( 'plugin' => 'hootkit', 'redirectdashtab' => 'plugins' ),
					) : array(
						'url' => '#',
						'text' => '<span class="dashicons dashicons-yes"></span> ' . esc_html__( 'Installed', 'nirvata' ),
						'button' => 'secondary',
						'class' => 'hootabt-success',
					),
			),
			array(
				'name' => esc_html__( 'Hoot Import', 'nirvata' ),
				/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
				'desc' => sprintf( esc_html__( 'This plugin helps you import the demo website data that you can install with a single click.%3$s%1$sView Details on wordpress.org%2$s', 'nirvata' ), '<a href="https://wordpress.org/plugins/hoot-import/" target="_blank">', '</a>', '<hr>' ),
				'cta' => ! class_exists( 'HootImport' ) ? array(
						'url' => admin_url( 'plugin-install.php?s=hoot-import&tab=search&type=term' ),
						'text' => file_exists( WP_PLUGIN_DIR . '/hoot-import/hoot-import.php' ) ? esc_html__( 'Activate Hoot Import', 'nirvata' ) : esc_html__( 'Install Hoot Import', 'nirvata' ),
						'button' => 'primary',
						'class' => 'hoot-btn-processplugin hoot-btn-smallmsg',
						'data-attr' => array( 'plugin' => 'hoot-import', 'redirectdashtab' => 'plugins' ),
					) : array(
						'url' => '#',
						'text' => '<span class="dashicons dashicons-yes"></span> ' . esc_html__( 'Installed', 'nirvata' ),
						'button' => 'secondary',
						'class' => 'hootabt-success',
					),
			),
		),
	);
	$pblocks[ 'grid-qblobsend' ] = array( 'type' => 'gridgenend' );

	return $pblocks;
}

function nirvata_require_hootkit( $sanetags, $context, $inpremium=false ) {
	$rhkblocks = array();
	$slug = !empty( $sanetags['slug'] ) ? $sanetags['slug'] : '';

	$context = empty( $context ) || ! is_string( $context ) ? 'hootkit' : $context;

	$name = '';
	$desc = !class_exists( 'HootKit' ) ? __( 'Please Install and Activate the HootKit plugin to view these Options.', 'nirvata' ) : __( 'Please update the HootKit plugin to view these options.', 'nirvata' );
	switch ( $context ) {
		case 'demoimport':
			$name = __( 'Import Demo Content', 'nirvata' );
			/* Translators: 1 is link break */
			$desc = !class_exists( 'HootKit' ) ? sprintf( __( 'Please Install and Activate the HootKit plugin.%1$sThis will enable pre-built websites (demos) that you can install with a single click.', 'nirvata' ), '<br />' ) : sprintf( __( 'Please update the HootKit plugin.%1$sThis will enable pre-built websites (demos) that you can install with a single click.', 'nirvata' ), '<br />' );
			break;
		case 'hootkit':
			$name = __( 'HootKit Settings', 'nirvata' );
			break;
		case 'tools':
			$name = __( 'Theme Tools', 'nirvata' );
			break;
		case 'code':
			$name = __( 'Custom Code', 'nirvata' );
			break;
		default:
			$name = __( 'HootKit Plugin Required', 'nirvata' );
	}
	if ( $inpremium ) {
		/* Translators: HTML tags */
		$desc = defined( 'HOOT_PREMIUM_VERSION' ) ?  sprintf( __( 'Please update %1$sNirvata Premium plugin%2$s to its latest version to access this screen.%3$sYour settings are safe.', 'nirvata' ), '<strong>', '</strong>', '<br/>' ) : __( 'This is a Premium Feature. Please activate the Premium plugin to view these options.', 'nirvata' );
	}

	$rhkblocks[ 'grid-reqhk_na' ] = array( 'type' => 'gridgen' );
	$rhkblocks[ 'reqhk' ] = array(
		'type' => 'columns',
		'columns' => 1,
		'blocks' => array(
			array(
				'name' => esc_html( $name ),
				'desc' => $desc,
				// This block will not exists if HootKit is active and has the needed version.
				'cta' => class_exists( 'HootKit' ) ? array(
						'url' => admin_url( 'update-core.php' ),
						'text' => esc_html__( 'Update HootKit to latest Version', 'nirvata' ),
						'button' => 'primary',
					) : array(
						'url' => hoot_dashboard( 'url', array( 'tab' => 'plugins' ) ),
						'text' => file_exists( WP_PLUGIN_DIR . '/hootkit/hootkit.php' ) ? esc_html__( 'Activate HootKit', 'nirvata' ) : esc_html__( 'Install HootKit', 'nirvata' ),
						'button' => 'primary',
						'class' => 'hoot-btn-processplugin hoot-btn-smallmsg',
						'data-attr' => array( 'plugin' => 'hootkit', 'redirectdashtab' => $context ),
					),
			),
		),
	);
	if ( $inpremium ) { unset( $rhkblocks[ 'reqhk' ][ 'blocks' ][0][ 'cta' ] ); }
	$rhkblocks[ 'grid-reqhk_naend' ] = array( 'type' => 'gridgenend' );

	// Sub-blocks

	if ( $context === 'tools' ) :
		$rhkblocks[ 'grid-tc_na' ] = array( 'type' => 'gridgen' );
		$rhkblocks[ 'tc-na' ] = array(
			'type' => 'columns',
			'columns' => 2,
			'blocks' => array(
				array(
					'name' => '<span class="dashicons dashicons-migrate"></span> ' . esc_html__( 'Import Settings', 'nirvata' ),
					'desc' => esc_html__( 'Import Customizer Settings from any available wpHoot theme.', 'nirvata' ),
				),
				array(
					'name' => '<span class="dashicons dashicons-migrate"></span> ' . esc_html__( 'Export Settings', 'nirvata' ),
					'desc' => esc_html__( 'Export Customizer Settings for any available wpHoot theme.', 'nirvata' ),
				),
			),
		);
		$rhkblocks[ 'grid-tc_naend' ] = array( 'type' => 'gridgenend' );
	elseif ( $context === 'code' ) :
		$rhkblocks[ 'grid-tc_na' ] = array( 'type' => 'gridgen' );
		$rhkblocks[ 'tc-na' ] = array(
			'type' => 'columns',
			'columns' => 3,
			'blocks' => array(
				array(
					'name' => '<span class="dashicons dashicons-shortcode"></span> ' . esc_html__( 'Custom PHP', 'nirvata' ),
					'desc' => esc_html__( 'Insert Custom PHP Snippets.', 'nirvata' ),
				),
				array(
					'name' => '<span class="dashicons dashicons-table-row-before"></span> ' . esc_html__( 'Insert Header', 'nirvata' ),
					/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
					'desc' => sprintf( esc_html__( 'Insert Custom CSS/javascript in Header like %1$sGoogle Analytics%2$s, meta tags etc.', 'nirvata' ), '<strong>', '</strong>' ),
				),
				array(
					'name' => '<span class="dashicons dashicons-table-row-after"></span> ' . esc_html__( 'Insert Footer', 'nirvata' ),
					'desc' => esc_html__( 'Insert Custom code in Footer.', 'nirvata' ),
				),
			),
		);
		$rhkblocks[ 'grid-tc_naend' ] = array( 'type' => 'gridgenend' );
	endif;

	return $rhkblocks;
}
