<?php
/**
 * This file contains functions and hooks for styling Hootkit plugin
 *   Hootkit is a free plugin released under GPL license and hosted on wordpress.org.
 *
 * This file is loaded at 'after_setup_theme' action @priority 10 ONLY IF hootkit plugin is active
 */

// Register HootKit
add_filter( 'hootkit_register', 'nirvata_register_hootkit', 5 );

// Set data for theme scripts localization.
add_action( 'wp_enqueue_scripts', 'nirvata_localize_hootkit', 5 );
// The theme's main style is loaded @12
// The child's main style is loaded @18
add_action( 'wp_enqueue_scripts', 'nirvata_enqueue_hootkit', 14 );
add_action( 'wp_enqueue_scripts', 'nirvata_enqueue_childhootkit', 20 );

// Set dynamic css handle to hootkit
// Set dynamic css handle to child hootkit inside `nirvata_dynamic_css_hootkit_handle` using `nirvata_dynamic_css_childhootkit_handle` 
add_filter( 'hoot_style_builder_inline_style_handle', 'nirvata_dynamic_css_hootkit_handle', 2 );

/**
 * Register Hootkit
 *
 * @since 1.0
 * @param array $config
 * @return string
 */
if ( !function_exists( 'nirvata_register_hootkit' ) ) :
function nirvata_register_hootkit( $config ) {
	// Array of configuration settings.
	$config = array(
		'nohoot'    => false,
		'theme_css' => true,
		'modules'   => array(
			'widget' => array(
				// Sliders
				'slider-image', 'slider-postimage',
				// Widgets
				'announce', 'content-blocks', 'content-posts-blocks', 'cta', 'icon', 'post-grid', 'post-list', 'social-icons', 'ticker', 'content-grid', 'profile', 'ticker-posts', 'page-content',
				// WC
				'content-products-blocks', 'product-list', 'products-ticker', 'products-search', 'products-carticon',
			),
			'misc' => array( 'shortcode-timer', 'fly-cart', 'classic-widgets', 'widgets-as-sc' ),
		),
		'supports_version' => 'v2',
		'supports'  => array(
			'widget-subtitle', 'imgbg-cssvars',
			'cta-styles', 'social-icons-altcolor', 'social-icons-align',
			'content-blocks-style5', 'content-blocks-style5-nojs', 'content-blocks-style6', 'content-blocks-iconoptions', 'cbox-evenspacecol', 'content-blocks-emptyblocks',
			'slider-styles', 'slider-style3', 'slider-subtitles',
			'grid-widget', 'list-widget', 'list-evenspacecol',
		),
		'premium'   => array( 'carousel', 'postcarousel', 'postlistcarousel', 'productcarousel', 'productlistcarousel', 'contact-info', 'cover-image', 'number-blocks', 'vcards', 'buttons', 'icon-list', 'notice', 'toggle', 'tabs', ),
		'dashboard' => array(
			'dashmenu'    => 'nirvata_appearance_subpage',
			'aboutfilter' => 'nirvata_abouttags',
		),
		'theme-filters' => array(
			'fnspace' => 'nirvata',
			'abouttags' => array( 'fullshot' ),
			'customizer' => array( 'pattern_pnote', 'sblayoutpnote', 'colorspnote', 'typopnoteplus', 'gfontsnote-js', 'archivetypepnote', 'singlemetapnote', 'article_background_pnote', 'article_maxwidth_pnote', 'topann_content', 'header_image_title', 'header_image_subtitle', 'header_image_text' ),
		),
	);
	return $config;
}
endif;

/**
 * Enqueue Scripts and Styles
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'nirvata_localize_hootkit' ) ) :
function nirvata_localize_hootkit() {
	$scriptdata = hoot_data( 'scriptdata' );
	if ( empty( $scriptdata ) )
		$scriptdata = array();
	$scriptdata['contentblockhover'] = 'enable'; // This needs to be explicitly enabled by supporting themes
	$scriptdata['contentblockhovertext'] = 'disable'; // Disabling needed for proper positioning of animation in latest themes (jquery animation is now redundant) (may be deleted later once all hootkit themes ported)
	hoot_set_data( 'scriptdata', $scriptdata );
}
endif;

/**
 * Enqueue Scripts and Styles
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'nirvata_enqueue_hootkit' ) ) :
function nirvata_enqueue_hootkit() {

	$loadminified = ( defined( 'HOOT_DEBUG' ) ) ?
					( ( HOOT_DEBUG ) ? false : true ) :
					false;

	/* Load Hootkit Style */
	if ( $loadminified && file_exists( hoot_data()->template_dir . 'hootkit/hootkit.min.css' ) )
		$style_uri =  hoot_data()->template_uri . 'hootkit/hootkit.min.css';
	elseif ( file_exists( hoot_data()->template_dir . 'hootkit/hootkit.css' ) )
		$style_uri =  hoot_data()->template_uri . 'hootkit/hootkit.css';
	if ( !empty( $style_uri ) )
		wp_enqueue_style( 'nirvata-hootkit', $style_uri, array(), hoot_data()->template_version );

}
endif;
if ( !function_exists( 'nirvata_enqueue_childhootkit' ) ) :
function nirvata_enqueue_childhootkit() {
	if ( is_child_theme() ) :

	$loadminified = ( defined( 'HOOT_DEBUG' ) ) ?
					( ( HOOT_DEBUG ) ? false : true ) :
					false;

	/* Load Hootkit Style */
	if ( $loadminified && file_exists( hoot_data()->child_dir . 'hootkit/hootkit.min.css' ) )
		$style_uri =  hoot_data()->child_uri . 'hootkit/hootkit.min.css';
	elseif ( file_exists( hoot_data()->child_dir . 'hootkit/hootkit.css' ) )
		$style_uri =  hoot_data()->child_uri . 'hootkit/hootkit.css';
	if ( !empty( $style_uri ) ) {
		wp_enqueue_style( 'nirvata-child-hootkit', $style_uri, array(), hoot_data()->childtheme_version );
		add_filter( 'hoot_style_builder_inline_style_handle', 'nirvata_dynamic_css_childhootkit_handle', 10 );
	}

	endif;
}
endif;

/**
 * Set dynamic css handle to hootkit
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'nirvata_dynamic_css_hootkit_handle' ) ) :
function nirvata_dynamic_css_hootkit_handle( $handle ) {
	return 'nirvata-hootkit';
}
endif;
if ( !function_exists( 'nirvata_dynamic_css_childhootkit_handle' ) ) :
function nirvata_dynamic_css_childhootkit_handle( $handle ) {
	return 'nirvata-child-hootkit';
}
endif;

/**
 * Modify Content Box default style
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_content_blocks_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['boxes']['fields']['icon_style'] ) )
		$settings['form_options']['boxes']['fields']['icon_style']['std'] = 'none';
	return $settings;
}
add_filter( 'hootkit_content_blocks_widget_settings', 'nirvata_content_blocks_widget_settings', 5 );

/**
 * Modify Border Style
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_hootkit_widget_settings_border( $settings ) {
	if ( isset( $settings['form_options']['border']['options'] ) )
		$settings['form_options']['border']['options'] = array(
			'line line'		=> __( 'Top - Line || Bottom - Line', 'nirvata' ),
			'line shadow'	=> __( 'Top - Line || Bottom - Shadow', 'nirvata' ),
			'line none'		=> __( 'Top - Line || Bottom - None', 'nirvata' ),
			'shadow line'	=> __( 'Top - Shadow || Bottom - Line', 'nirvata' ),
			'shadow shadow'	=> __( 'Top - Shadow || Bottom - Shadow', 'nirvata' ),
			'shadow none'	=> __( 'Top - Shadow || Bottom - None', 'nirvata' ),
			'none line'		=> __( 'Top - None || Bottom - Line', 'nirvata' ),
			'none shadow'	=> __( 'Top - None || Bottom - Shadow', 'nirvata' ),
			'none none'		=> __( 'Top - None || Bottom - None', 'nirvata' ),
		);
	return $settings;
}
add_filter( 'hootkit_buttons_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_content_blocks_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_content_posts_blocks_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_content_products_blocks_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_cta_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_number_blocks_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_profile_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );
add_filter( 'hootkit_vcards_widget_settings', 'nirvata_hootkit_widget_settings_border', 5 );

/**
 * Modify Ticker default style
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_ticker_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['background'] ) )
		$settings['form_options']['background']['std'] = '#f1f1f1';
	if ( isset( $settings['form_options']['fontcolor'] ) )
		$settings['form_options']['fontcolor']['std'] = '#666666';
	return $settings;
}
function nirvata_ticker_products_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['background'] ) )
		$settings['form_options']['background']['std'] = '#f1f1f1';
	if ( isset( $settings['form_options']['fontcolor'] ) )
		$settings['form_options']['fontcolor']['std'] = '#333333';
	return $settings;
}
add_filter( 'hootkit_ticker_widget_settings', 'nirvata_ticker_widget_settings', 5 );
add_filter( 'hootkit_ticker_posts_widget_settings', 'nirvata_ticker_widget_settings', 5 );
add_filter( 'hootkit_products_ticker_widget_settings', 'nirvata_ticker_products_widget_settings', 5 );

/**
 * Filter Ticker and Ticker Posts display Title markup
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_hootkit_widget_title( $display, $title, $context, $icon = '' ) {
	$display = '<div class="ticker-title accent-typo">' . $icon . $title . '</div>';
	return $display;
}
add_filter( 'hootkit_widget_ticker_title', 'nirvata_hootkit_widget_title', 5, 4 );

/**
 * Set button styling (for user defined colors) in cover image widget
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
add_filter( 'hootkit_coverimage_inverthoverbuttons', '__return_true' );

/**
 * Set Read More button location for Content Block
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_hootkit_content_block_styles_inboxlink( $styles ) {
	$styles = array( 'style4', 'style5', 'style6' );
	return $styles;
}
add_filter( 'hootkit_content_block_styles_inboxlink', 'nirvata_hootkit_content_block_styles_inboxlink', 5 );

/**
 * Modify Social Icons default style
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function nirvata_social_icons_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['size'] ) )
		$settings['form_options']['size']['std'] = 'small';
	if ( isset( $settings['form_options']['altcolor'] ) )
		$settings['form_options']['altcolor']['std'] = 'default';
	return $settings;
}
add_filter( 'hootkit_social_icons_widget_settings', 'nirvata_social_icons_widget_settings', 5 );
