<?php
require get_template_directory() . '/inc/block-patterns.php';

function nimbora_theme_enqueue_styles()
{
    wp_enqueue_style(
        'nimbora_theme-main-css',
        get_template_directory_uri() . '/assets/css/main.css',
        array(),
        wp_get_theme()->get('Version'),
        'all'
    );
}

add_action('wp_enqueue_scripts', 'nimbora_theme_enqueue_styles');

function nimbora_theme_js_script()
{
wp_enqueue_script(
    'effects-js',
    get_template_directory_uri() . '/assets/js/effects.js',
    array(),
    wp_get_theme()->get('Version'),
    true // load on footer
);
}
add_action('wp_enqueue_scripts', 'nimbora_theme_js_script'); 

function nimbora_theme_js_custom_script()
{
wp_enqueue_script(
    'custom-js',
    get_template_directory_uri() . '/assets/js/custom.js',
    array(),
    wp_get_theme()->get('Version'),
    true // load on footer
);
}
add_action('wp_enqueue_scripts', 'nimbora_theme_js_custom_script'); 


// Add Customizer
require get_template_directory() . '/inc/customizer.php';


// Upsell in the customizer
if ( class_exists( 'WP_Customize_Section' ) ) {
	class Nimbora_Upsell_Section extends WP_Customize_Section {
		public $type = 'nimbora-upsell';
		public $button_text = '';
		public $url = '';
		public $background = '';
		public $text_color = '';
		protected function render() {
			$background = ! empty( $this->background ) ? esc_attr( $this->background ) : 'linear-gradient(90deg,rgb(0,0,0) 0%,rgb(0,0,0) 35%,rgb(0,0,0) 70%,rgb(0,0,0) 100%)
            ';
			$text_color       = ! empty( $this->text_color ) ? esc_attr( $this->text_color ) : '#fff';
			?>
			<li id="accordion-section-<?php echo esc_attr( $this->id ); ?>" class="nimbora_upsell_section accordion-section control-section control-section-<?php echo esc_attr( $this->id ); ?> cannot-expand">
				<h3 class="accordion-section-title" style="border: 0; color:#fff; background:<?php echo esc_attr( $background ); ?>;">
					<?php echo esc_html( $this->title ); ?>
					<a href="<?php echo esc_url( $this->url ); ?>" class="button button-secondary alignright" target="_blank" style="margin-top: -4px;"><?php echo esc_html( $this->button_text ); ?></a>
				</h3>
			</li>
			<?php
		}
	}
}

// Add Get Started
require get_template_directory() . '/inc/get-started/get-started.php';


function nimbora_notice() {
    $user_id = get_current_user_id();
    if ( !get_user_meta( $user_id, 'nimbora_notice_dismissed' ) ) {
 
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start" style="display: flex-inline;padding: 10px;">
        <h2 style="color: #FFC300"><?php esc_html_e('☆☆☆☆☆', 'nimbora'); ?><br></h2>
            <p style="color: #000"><?php esc_html_e('This is just a sample of what the Nimbora Template can do, the Premium Version is waiting for you!', 'nimbora'); ?></p>
            <a style="margin-top: 18px; color:#fff; background: steelblue !important;" class="button button-primary" target="_blank"
               href="<?php echo esc_url('https://realtimethemes.com/theme-nimbora'); ?>"><?php esc_html_e('See Premium Version', 'nimbora') ?></a>
               <a href="?nimbora-dismissed" style="margin-top: 18px;" class="button button-secondary"><?php esc_html_e('Dismiss', 'nimbora'); ?></a>
        </div>
        <?php
        }
}
add_action( 'admin_notices', 'nimbora_notice' ); 

function nimbora_notice_dismissed() {
    $user_id = get_current_user_id();
    if ( isset( $_GET['nimbora-dismissed'] ) ) 
        add_user_meta( $user_id, 'nimbora_notice_dismissed', 'true', true );
}
add_action( 'admin_init', 'nimbora_notice_dismissed' );

define('NIMBORA_BUY_NOW',__('https://realtimethemes.com/theme-nimbora','nimbora'));
define('NIMBORA_PRO_DEMO',__('https://preview.realtimethemes.com/nimbora','nimbora'));
define('NIMBORA_REVIEW',__('https://realtimethemes.com/theme-nimbora','nimbora'));
define('NIMBORA_SUPPORT',__('https://realtimethemes.com/','nimbora'));



// AD

if (! defined('REALTIME_THEMES_HELPER_PATH')) {
    define(
        'REALTIME_THEMES_HELPER_PATH',
        get_stylesheet_directory() . '/'
    );
}
if (! defined('REALTIME_THEMES_HELPER_URL')) {
    define('REALTIME_THEMES_HELPER_URL', get_stylesheet_directory_uri() .
        '/');
}
add_action('admin_enqueue_scripts', function () {
    wp_enqueue_style(
        'my-font',
        'https://fonts.googleapis.com/css2?
family=Bai+Jamjuree:wght@400;600;700&display=swap',
        [],
        null
    );
});
/**
 * Theme button admin bar
 */
add_action('admin_bar_menu', function ($wp_admin_bar) {
    if (! current_user_can('manage_options')) {
        return;
    }
    $wp_admin_bar->add_node([
        'id' => 'real_time_themes_helper_button2',
        'title' => '<span style="
color:#fff;
background:#000;
padding:0px 8px;
height: 100%;
font-weight: 700;
display: flex;
align-items: center;
gap: 5px;
width: 100%;
justify-content: center
">
<img src="http://realtimethemes.com/img/realtimethemes_logo.png"
alt="Real Time Themes Logo"
style="height: 15px; width: auto; object-fit: cover;" />
Real Time Themes Helper
</span>',
        'href' => admin_url('admin.php?page=realtime-themes-helper'),
        'meta' => [
            'class' => 'realtime-themes-helper-button',
            'title' => 'Open Real Time Themes Helper',
            'target' => '_blank',
        ]
    ]);
}, 100);
/**
 * Scripts
 */
add_action('enqueue_block_editor_assets', function () {
    $theme = wp_get_theme();
    if ($theme->parent()) {
        $theme = $theme->parent();
    }
    $theme_uri = $theme->get('ThemeURI');
    $settings = get_option('realtime_themes_helper_settings', [
        'allowed_blocks' => [],
    ]);
    wp_enqueue_script(
        'realtime-themes-helper-editor',
        get_stylesheet_directory_uri() . '/assets/js/script.js',
        ['wp-hooks', 'wp-element', 'wp-edit-post'],
        filemtime(get_stylesheet_directory() . '/assets/js/script.js'),
        true
    );
    error_log('Theme URI detectado: ' . $theme_uri);
    wp_localize_script(
        'realtime-themes-helper-editor',
        'RealtimeThemesHelper',
        ['allowedBlocks' => $settings['allowed_blocks'], 'themeUri' =>
        $theme_uri]
    );
}, 20);
$files = [
    'settings.php',
    'admin-page.php',
];
foreach ($files as $file) {
    $path = REALTIME_THEMES_HELPER_PATH . 'assets/php/' . $file;
    if (file_exists($path)) {
        require_once $path;
    }
}
// remover notice
if (
    isset($_GET['page']) && $_GET['page'] === 'realtime-themes-helper'
) {
    return;
}
