<?php
/**
 * The unminified critical css for the theme
 *
 * This is a manually generated unminified version of the critical css.
 * Any changes to critical css should be copy/pasted to https://unminify.com/ and
 * results pasted in to this file to conform with WP theme requirements that all code is
 * available in unminified format. This file is NOT used in any way in the live output.
 *
 * @package Nightingale
 * @copyright NHS Leadership Academy, Tony Blacker and Mahesh Murali P
 * @version 1.2 14th October 2025
 */

?>
html {
	line-height: 1.15;
	-webkit-text-size-adjust: 100%;
	overflow-x: hidden;
}
body {
	margin: 0;
}
a {
	background-color: rgba(0, 0, 0, 0);
}
button,
input {
	font-family: inherit;
	font-size: 100%;
	line-height: 1.15;
	margin: 0;
}
button {
	text-transform: none;
}
button,
[type="submit"] {
	-webkit-appearance: button;
}
button::-moz-focus-inner,
[type="submit"]::-moz-focus-inner {
	border-style: none;
	padding: 0;
}
button:-moz-focusring,
[type="submit"]:-moz-focusring {
	outline: 1px dotted ButtonText;
}
[type="search"] {
	-webkit-appearance: textfield;
	outline-offset: -2px;
}
[type="search"]::-webkit-search-decoration {
	-webkit-appearance: none;
}
::-webkit-file-upload-button {
	-webkit-appearance: button;
	font: inherit;
}
body,
button,
input {
	font-family:
		Frutiger W01,
		Arial,
		Sans-serif;
}
h2 {
	clear: both;
}
p {
	margin-bottom: 1.5em;
}
html {
	box-sizing: border-box;
}
*,
*:before,
*:after {
	box-sizing: inherit;
}
body {
	background: #fff;
}
ul {
	list-style: disc;
}
li > ul {
	margin-bottom: 0;
	margin-left: 1.5em;
}
.screen-reader-text {
	border: 0;
	clip: rect(1px, 1px, 1px, 1px);
	clip-path: inset(50%);
	height: 1px;
	margin: -1px;
	overflow: hidden;
	padding: 0;
	position: absolute;
	width: 1px;
	word-wrap: normal !important;
}
.clear:before,
.clear:after {
	content: "";
	display: table;
	table-layout: fixed;
}
.clear:after {
	clear: both;
}
.widget {
	margin: 0 0 1.5em;
}
html {
	-moz-box-sizing: border-box;
	-webkit-box-sizing: border-box;
	box-sizing: border-box;
}
*,
*:before,
*:after {
	-moz-box-sizing: inherit;
	-webkit-box-sizing: inherit;
	box-sizing: inherit;
}
button,
input {
	font-family: inherit;
}
a {
	color: #005eb8;
}
a:visited {
	color: #330072;
}
html {
	background-color: #d8dde0;
	overflow-y: scroll;
	font-family:
		Frutiger W01,
		Arial,
		Sans-serif;
}
@font-face {
	font-display: swap;
	font-family: "Frutiger W01";
	font-style: normal;
	font-weight: 400;
	src: url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.eot?#iefix");
	src:
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.eot?#iefix") format("eot"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.woff2") format("woff2"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.woff") format("woff"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.ttf") format("truetype"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-55Roman.svg#7def0e34-f28d-434f-b2ec-472bde847115") format("svg");
}
@font-face {
	font-display: swap;
	font-family: "Frutiger W01";
	font-style: normal;
	font-weight: 600;
	src: url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.eot?#iefix");
	src:
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.eot?#iefix") format("eot"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.woff2") format("woff2"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.woff") format("woff"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.ttf") format("truetype"),
		url("https://assets.nhs.uk/fonts/FrutigerLTW01-65Bold.svg#eae74276-dd78-47e4-9b27-dac81c3411ca") format("svg");
}
body {
	background-color: #f0f4f5;
	color: #212b32;
	font-size: 16px;
	-moz-osx-font-smoothing: grayscale;
	-webkit-font-smoothing: antialiased;
	line-height: 1.5;
	margin: 0;
	min-height: 100%;
}
.nhsuk-grid-row {
	margin-left: -16px;
	margin-right: -16px;
}
.nhsuk-grid-row:after {
	clear: both;
	content: "";
	display: block;
}
.nhsuk-grid-column-one-third {
	box-sizing: border-box;
	padding: 0 16px;
}
@media (min-width: 48.0625em) {
	.nhsuk-grid-column-one-third {
		float: left;
		width: 33.3333%;
	}
}
.nhsuk-grid-column-two-thirds {
	box-sizing: border-box;
	padding: 0 16px;
}
@media (min-width: 48.0625em) {
	.nhsuk-grid-column-two-thirds {
		float: left;
		width: 66.6666%;
	}
}
.nhsuk-grid-column-full {
	box-sizing: border-box;
	padding: 0 16px;
}
@media (min-width: 48.0625em) {
	.nhsuk-grid-column-full {
		float: left;
		width: 100%;
	}
}
.nhsuk-main-wrapper {
	padding-top: 40px;
	padding-bottom: 40px;
	display: block;
}
@media (min-width: 40.0625em) {
	.nhsuk-main-wrapper {
		padding-top: 48px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-main-wrapper {
		padding-bottom: 48px;
	}
}
.nhsuk-main-wrapper > *:first-child {
	margin-top: 0;
}
.nhsuk-main-wrapper > *:last-child {
	margin-bottom: 0;
}
.nhsuk-width-container {
	margin: 0 16px;
	max-width: 960px;
}
@media (min-width: 48.0625em) {
	.nhsuk-width-container {
		margin: 0 32px;
	}
}
@media (min-width: 1024px) {
	.nhsuk-width-container {
		margin: 0 auto;
	}
}
.nhsuk-icon {
	height: 34px;
	width: 34px;
}
.nhsuk-icon__search {
	fill: #005eb8;
}
.nhsuk-icon__arrow-right-circle {
	fill: #007f3b;
}
.nhsuk-icon__chevron-down {
	fill: #fff;
	height: 24px;
	position: absolute;
	right: 4px;
	transform: rotate(90deg);
	width: 24px;
}
ul {
	font-size: 16px;
	font-size: 1rem;
	line-height: 1.5;
	margin-bottom: 16px;
	list-style-type: none;
	margin-top: 0;
	padding-left: 0;
}
@media (min-width: 40.0625em) {
	ul {
		font-size: 19px;
		font-size: 1.1875rem;
		line-height: 1.47368;
	}
}
@media (min-width: 40.0625em) {
	ul {
		margin-bottom: 24px;
	}
}
ul ul {
	margin-top: 8px;
	margin-bottom: 0;
}
@media (min-width: 40.0625em) {
	ul ul {
		margin-top: 8px;
	}
}
ul > li {
	margin-bottom: 8px;
}
@media (min-width: 40.0625em) {
	ul > li {
		margin-bottom: 8px;
	}
}
ul > li:last-child {
	margin-bottom: 0;
}
ul {
	list-style-type: disc;
	padding-left: 20px;
}
h2 {
	font-size: 24px;
	font-size: 1.5rem;
	line-height: 1.33333;
	display: block;
	font-weight: 600;
	margin-top: 0;
	margin-bottom: 16px;
}
@media (min-width: 40.0625em) {
	h2 {
		font-size: 32px;
		font-size: 2rem;
		line-height: 1.25;
	}
}
@media (min-width: 40.0625em) {
	h2 {
		margin-bottom: 24px;
	}
}
.nhsuk-heading-m {
	font-size: 20px;
	font-size: 1.25rem;
	line-height: 1.4;
	display: block;
	font-weight: 600;
	margin-top: 0;
	margin-bottom: 16px;
}
@media (min-width: 40.0625em) {
	.nhsuk-heading-m {
		font-size: 24px;
		font-size: 1.5rem;
		line-height: 1.33333;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-heading-m {
		margin-bottom: 24px;
	}
}
p {
	font-size: 16px;
	font-size: 1rem;
	line-height: 1.5;
	display: block;
	margin-top: 0;
	margin-bottom: 16px;
}
@media (min-width: 40.0625em) {
	p {
		font-size: 19px;
		font-size: 1.1875rem;
		line-height: 1.47368;
	}
}
@media (min-width: 40.0625em) {
	p {
		margin-bottom: 24px;
	}
}
p {
	color: inherit;
}
.nhsuk-u-visually-hidden {
	border: 0;
	clip: rect(0 0 0 0);
	-webkit-clip-path: inset(50%);
	clip-path: inset(50%);
	height: 1px;
	margin: 0;
	overflow: hidden;
	padding: 0;
	position: absolute;
	white-space: nowrap;
	width: 1px;
}
.nhsuk-action-link {
	margin-bottom: 32px;
}
@media (min-width: 40.0625em) {
	.nhsuk-action-link {
		margin-bottom: 40px;
	}
}
.nhsuk-action-link__link {
	font-weight: 400;
	font-size: 18px;
	font-size: 1.125rem;
	line-height: 1.55556;
	display: inline-block;
	font-weight: 600;
	padding-left: 38px;
	position: relative;
	text-decoration: none;
}
@media (min-width: 40.0625em) {
	.nhsuk-action-link__link {
		font-size: 22px;
		font-size: 1.375rem;
		line-height: 1.45455;
	}
}
@media (max-width: 40.0525em) {
	.nhsuk-action-link__link {
		padding-left: 26px;
	}
}
.nhsuk-action-link__link .nhsuk-icon__arrow-right-circle {
	fill: #007f3b;
	height: 36px;
	left: -3px;
	position: absolute;
	top: -2px;
	width: 36px;
}
@media (max-width: 40.0525em) {
	.nhsuk-action-link__link .nhsuk-icon__arrow-right-circle {
		height: 24px;
		left: -2px;
		margin-bottom: 0;
		top: 2px;
		width: 24px;
	}
}
.nhsuk-breadcrumb {
	padding-bottom: 16px;
	padding-top: 20px;
}
.nhsuk-breadcrumb__list {
	list-style: none;
	margin: 0;
	padding: 0;
}
@media (max-width: 40.0525em) {
	.nhsuk-breadcrumb__list {
		display: none;
	}
}
.nhsuk-breadcrumb__item {
	font-weight: 400;
	font-size: 14px;
	font-size: 0.875rem;
	line-height: 1.71429;
	display: inline-block;
	margin-bottom: 0;
}
@media (min-width: 40.0625em) {
	.nhsuk-breadcrumb__item {
		font-size: 16px;
		font-size: 1rem;
		line-height: 1.5;
	}
}
.nhsuk-breadcrumb__back {
	font-weight: 400;
	font-size: 14px;
	font-size: 0.875rem;
	line-height: 1.71429;
	margin: 0;
	padding-left: 16px;
	position: relative;
}
@media (min-width: 40.0625em) {
	.nhsuk-breadcrumb__back {
		font-size: 16px;
		font-size: 1rem;
		line-height: 1.5;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-breadcrumb__back {
		display: none;
	}
}
.nhsuk-card {
	margin-bottom: 40px;
	background: #fff;
	border: 1px solid #d8dde0;
	position: relative;
	width: 100%;
}
@media (min-width: 40.0625em) {
	.nhsuk-card {
		margin-bottom: 48px;
	}
}
.nhsuk-card__content {
	padding: 24px;
}
.nhsuk-card__content > *:first-child {
	margin-top: 0;
}
.nhsuk-card__content > *:last-child {
	margin-bottom: 0;
}
@media (min-width: 40.0625em) {
	.nhsuk-card__content {
		padding: 32px;
	}
}
.nhsuk-card__heading,
.nhsuk-card__description {
	margin-bottom: 16px;
}
.nhsuk-card--clickable {
	border-bottom-width: 4px;
}
.nhsuk-card--clickable .nhsuk-card__link::before {
	background-color: rgba(255, 255, 255, 0);
	bottom: 0;
	content: "";
	display: block;
	left: 0;
	position: absolute;
	right: 0;
	top: 0;
}
.nhsuk-card-group {
	display: flex;
	flex-wrap: wrap;
	margin-bottom: 16px;
	padding: 0;
}
@media (max-width: 48.0525em) {
	.nhsuk-card-group {
		margin-bottom: 40px;
	}
}
.nhsuk-card-group__item {
	display: flex;
	list-style-type: none;
	margin-bottom: 0;
}
@media (max-width: 48.0525em) {
	.nhsuk-card-group__item {
		flex: 0 0 100%;
	}
}
.nhsuk-card-group__item .nhsuk-card {
	margin-bottom: 32px;
}
@media (max-width: 48.0525em) {
	.nhsuk-card-group__item .nhsuk-card {
		margin-bottom: 16px;
	}
	.nhsuk-card-group__item:last-child .nhsuk-card {
		margin-bottom: 0;
	}
}
.nhsuk-footer-container {
	padding-bottom: 24px;
	padding-top: 24px;
	background-color: #d8dde0;
	border-top: 4px solid #005eb8;
}
.nhsuk-footer-container:after {
	clear: both;
	content: "";
	display: block;
}
@media (min-width: 40.0625em) {
	.nhsuk-footer-container {
		padding-bottom: 32px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-footer-container {
		padding-top: 32px;
	}
}
.nhsuk-footer {
	background-color: #d8dde0;
	margin-bottom: 15px;
}
@media (min-width: 48.0625em) {
	.nhsuk-footer {
		display: flex;
		justify-content: space-between;
	}
}
.nhsuk-footer__list {
	padding-bottom: 16px;
	list-style-type: none;
	margin-bottom: 25px;
	padding-left: 0;
}
@media (min-width: 40.0625em) {
	.nhsuk-footer__list {
		padding-bottom: 24px;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-footer__list {
		float: left;
		padding-bottom: 0;
		padding-right: 40px;
		width: 75%;
	}
}
.nhsuk-footer__list-item {
	font-weight: 400;
	font-size: 14px;
	font-size: 0.875rem;
	line-height: 1.71429;
}
@media (min-width: 40.0625em) {
	.nhsuk-footer__list-item {
		font-size: 16px;
		font-size: 1rem;
		line-height: 1.5;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-footer__list-item {
		float: none;
		margin-right: 0;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-footer-default__list-item {
		float: left;
		margin-right: 32px;
	}
}
.nhsuk-footer__list-item-link {
	color: #003087;
}
.nhsuk-footer__list-item-link:visited {
	color: #003087;
}
.nhsuk-footer__copyright {
	font-weight: 400;
	font-size: 14px;
	font-size: 0.875rem;
	line-height: 1.71429;
	color: #231f20;
	margin-bottom: 0;
}
@media (min-width: 40.0625em) {
	.nhsuk-footer__copyright {
		font-size: 16px;
		font-size: 1rem;
		line-height: 1.5;
	}
}
.nhsuk-header {
	background-color: #005eb8;
}
.nhsuk-header__container {
	margin: 0 16px;
	max-width: 960px;
	padding: 20px 0;
}
@media (min-width: 48.0625em) {
	.nhsuk-header__container {
		margin: 0 32px;
	}
}
@media (min-width: 1024px) {
	.nhsuk-header__container {
		margin: 0 auto;
	}
}
@media (max-width: 40.0525em) {
	.nhsuk-header__container {
		padding-bottom: 0;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-header__container {
		border-bottom: 1px solid rgba(255, 255, 255, 0.2);
		display: flex;
		justify-content: space-between;
	}
}
@media (max-width: 40.0525em) {
	.nhsuk-header__logo {
		position: relative;
		z-index: 1;
	}
}
.nhsuk-header__logo .nhsuk-logo__background {
	fill: #fff;
}
.nhsuk-header__logo .nhsuk-logo__text {
	fill: #005eb8;
}
@media (min-width: 40.0625em) {
	.nhsuk-header__logo {
		padding-left: 0;
	}
}
.nhsuk-header__logo .nhsuk-logo {
	height: 40px;
	width: 100px;
	border: 0;
}
@media (max-width: 48.0525em) {
	.nhsuk-header__logo {
		max-width: 60%;
	}
}
@media (max-width: 450px) {
	.nhsuk-header__logo {
		max-width: 50%;
	}
}
.nhsuk-header__link {
	height: 40px;
	width: 100px;
	display: block;
}
.nhsuk-header__content {
	position: relative;
}
.nhsuk-header__search {
	position: relative;
	text-align: right;
}
@media (min-width: 40.0625em) {
	.nhsuk-header__search {
		margin-left: 8px;
	}
}
.nhsuk-header__search-form {
	height: 100%;
	overflow: visible;
}
@media (max-width: 40.0525em) {
	.nhsuk-header__search-form {
		display: flex;
		margin: 16px 0 0;
		position: relative;
		width: 100%;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-header__search-wrap {
		display: block;
	}
}
.nhsuk-search__input {
	-webkit-appearance: listbox;
	border-bottom-left-radius: 4px;
	border-bottom-right-radius: 0;
	border-top-left-radius: 4px;
	border-top-right-radius: 0;
	padding: 0 16px;
}
.nhsuk-search__input:-ms-input-placeholder {
	color: #4c6272;
	font-size: 16px;
}
.nhsuk-search__input::-webkit-input-placeholder {
	color: #4c6272;
	font-size: 16px;
}
@media (max-width: 40.0525em) {
	.nhsuk-search__input {
		border: 1px solid #fff;
		border-bottom-right-radius: 4px;
		border-top-right-radius: 4px;
		flex-grow: 2;
		-ms-flex-positive: 2;
		font-size: inherit;
		height: 40px;
		margin: 0;
		outline: none;
		width: 100%;
		z-index: 1;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-search__input {
		border: 1px solid #fff;
		font-size: 16px;
		height: 40px;
		width: 200px;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-search__input {
		width: 235px;
	}
}
.nhsuk-search__submit {
	border: 0;
	border-bottom-left-radius: 0;
	border-bottom-right-radius: 4px;
	border-top-left-radius: 0;
	border-top-right-radius: 4px;
	float: right;
	font-size: inherit;
	line-height: inherit;
	outline: none;
	padding: 0;
}
.nhsuk-search__submit::-moz-focus-inner {
	border: 0;
}
@media (max-width: 40.0525em) {
	.nhsuk-search__submit {
		background-color: #f0f4f5;
		border: 0;
		height: 40px;
		margin: 0;
		padding: 8px 8px 0;
		position: absolute;
		right: 0;
		top: 0;
		z-index: 9;
	}
	.nhsuk-search__submit .nhsuk-icon__search {
		fill: #005eb8;
		height: 27px;
		width: 27px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-search__submit {
		background-color: #f0f4f5;
		display: block;
		height: 40px;
		line-height: 1;
		width: 44px;
	}
	.nhsuk-search__submit .nhsuk-icon__search {
		height: 27px;
		width: 27px;
	}
}
.nhsuk-header__navigation-link {
	font-weight: 400;
	font-size: 14px;
	font-size: 0.875rem;
	line-height: 1.71429;
	border-bottom: 4px solid rgba(0, 0, 0, 0);
	border-top: 4px solid rgba(0, 0, 0, 0);
	color: #fff;
	display: block;
	font-size: inherit;
	padding: 16px 12px;
	text-decoration: underline;
	white-space: nowrap;
}
@media (min-width: 40.0625em) {
	.nhsuk-header__navigation-link {
		font-size: 16px;
		font-size: 1rem;
		line-height: 1.5;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-header__navigation-link {
		padding: 12px 16px;
	}
}
.nhsuk-header__navigation-link:visited {
	color: #fff;
}
@media (min-width: 61.875em) {
	.nhsuk-header__navigation-link:visited {
		color: #fff;
	}
}
.nhsuk-header__menu-toggle {
	background: rgba(0, 0, 0, 0);
	border: 0;
	border-bottom: 4px solid rgba(0, 0, 0, 0);
	border-radius: 0;
	border-top: 4px solid rgba(0, 0, 0, 0);
	box-sizing: border-box;
	margin: 0;
	overflow: visible;
	position: relative;
	right: 0;
	text-align: center;
	text-decoration: underline;
	vertical-align: top;
	visibility: hidden;
	width: auto;
	z-index: 1;
}
.nhsuk-header__menu-toggle.nhsuk-header__navigation-link {
	padding-right: 30px;
}
@media (min-width: 48.0625em) {
	.nhsuk-header__menu-toggle {
		display: none;
	}
}
.nhsuk-navigation {
	display: flex;
}
@media (max-width: 40.0525em) {
	.nhsuk-navigation {
		position: relative;
		z-index: 10;
	}
}
.nhsuk-header__drop-down,
.nhsuk-header__navigation-list {
	list-style: none;
	margin: 0;
	padding: 0;
}
.nhsuk-header__navigation-list {
	margin: 0 16px;
	max-width: 960px;
	width: 100%;
}
@media (min-width: 48.0625em) {
	.nhsuk-header__navigation-list {
		margin: 0 32px;
	}
}
@media (min-width: 1024px) {
	.nhsuk-header__navigation-list {
		margin: 0 auto;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-header__navigation-list {
		display: flex;
		justify-content: space-between;
	}
}
.js-enabled .nhsuk-header__navigation-list {
	display: flex;
}
.nhsuk-header__navigation-item {
	margin-bottom: 0;
}
.nhsuk-navigation-container {
	position: relative;
}
.nhsuk-header__drop-down {
	background-color: #fff;
	border-bottom: 4px solid #f0f4f5;
	overflow: hidden;
	position: absolute;
	right: 0;
	top: 100%;
	left: 0;
}
.nhsuk-header__drop-down--hidden {
	display: none;
}
.nhsuk-mobile-menu-container {
	align-self: center;
	display: none;
}
.nhsuk-header--organisation .nhsuk-header__link {
	height: auto;
	text-decoration: none;
	width: auto;
}
.nhsuk-header--organisation .nhsuk-header__logo .nhsuk-logo {
	height: 32px;
	width: 80px;
}
@media (max-width: 450px) {
	.nhsuk-header--organisation .nhsuk-header__logo .nhsuk-logo {
		height: 24px;
		width: 60px;
	}
}
@media (max-width: 375px) {
	.nhsuk-header--organisation .nhsuk-header__logo .nhsuk-logo {
		height: 20px;
		width: 50px;
	}
}
.nhsuk-organisation-name {
	color: #fff;
	display: block;
	font-size: 22px;
	font-weight: bold;
	letter-spacing: 0.2px;
	line-height: 23px;
	margin-top: -2px;
}
@media (max-width: 450px) {
	.nhsuk-organisation-name {
		font-size: 17px;
		letter-spacing: 0.1px;
		line-height: 17px;
	}
}
@media (max-width: 375px) {
	.nhsuk-organisation-name {
		font-size: 13px;
		line-height: 13px;
	}
}
.nhsuk-organisation-name .nhsuk-organisation-name-split {
	display: block;
}
.nhsuk-organisation-descriptor {
	color: #fff;
	display: block;
	font-size: 15px;
	font-weight: bold;
	line-height: 21px;
}
@media (max-width: 450px) {
	.nhsuk-organisation-descriptor {
		font-size: 12px;
		line-height: 18px;
	}
}
@media (max-width: 375px) {
	.nhsuk-organisation-descriptor {
		font-size: 10px;
		line-height: 13px;
	}
}
.nhsuk-header__transactional-service-name {
	padding-left: 16px;
	padding-top: 3px;
}
@media (max-width: 40.0525em) {
	.nhsuk-header__transactional-service-name {
		padding-bottom: 16px;
	}
}
@media (max-width: 40.0525em) {
	.nhsuk-header__transactional-service-name {
		padding-left: 0;
		padding-top: 8px;
		width: 100%;
	}
}
.nhsuk-header__transactional-service-name--link {
	color: #fff;
	font-weight: 400;
	font-size: 16px;
	font-size: 1rem;
	line-height: 1.5;
	text-decoration: none;
}
@media (min-width: 40.0625em) {
	.nhsuk-header__transactional-service-name--link {
		font-size: 19px;
		font-size: 1.1875rem;
		line-height: 1.47368;
	}
}
.nhsuk-header--white {
	background-color: #fff;
}
.nhsuk-header--white .nhsuk-header__search-wrap {
	margin-bottom: 16px;
}
.nhsuk-header--white .nhsuk-search__submit {
	background-color: #005eb8;
}
.nhsuk-header--white .nhsuk-search__submit .nhsuk-icon__search {
	fill: #fff;
}
@media (max-width: 40.0525em) {
	.nhsuk-header--white .nhsuk-header__search-form {
		padding-top: 0;
	}
}
.nhsuk-panel-group {
	margin-left: 0;
	margin-right: 0;
}
#primary p {
	-ms-word-wrap: break-word;
	word-wrap: break-word;
}
#cookie-notice {
	position: fixed;
	left: 0;
	bottom: 0;
	width: 100%;
}
.nhsuk-header__navigation-item {
	border-top: none;
}
.nhsuk-navigation-container .nhsuk-navigation .nhsuk-icon__chevron-down {
	fill: #fff;
}
@media (max-width: 40.0525em) {
	.nhsuk-search__submit {
		background-color: #f0f4f5;
		border: 0;
		margin: 0;
		padding: 8px 8px 0;
		position: absolute;
		right: 0;
		top: auto;
		height: 40px;
		z-index: 9;
	}
	.nhsuk-header__search-form {
		padding: 16px 0 0 0;
	}
	.nhsuk-header__search-wrap {
		display: block;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-header__container {
		justify-content: normal;
	}
	.nhsuk-header__transactional-service-name {
		padding-left: 28px;
		width: 100%;
	}
	.nhsuk-header__search {
		margin-left: 0px;
		width: 100%;
	}
	.nhsuk-header__content {
		width: 100%;
	}
}
@media (min-width: 48.0625em) {
	.nhsuk-header--organisation .nhsuk-header__link {
		max-width: 500px;
		width: max-content;
	}
}
.nhsuk-grid-column-full {
	padding: 0;
}
.nhsuk-grid-column-one-third {
	flex-flow: wrap;
}
.nhsuk-grid-column-full {
	clear: both;
}
.nhsuk-icon__arrow-right-circle {
	vertical-align: middle;
}
.clear:after {
	clear: both;
	content: "";
	display: block;
}
.nhsuk-readmore {
	text-align: left;
	padding-bottom: 16px;
}
button {
	margin: 0;
}
.nhsuk-card .nhsuk-card__description {
	display: flow-root;
}
#secondary section {
	border-top: 2px solid #005eb8;
	margin-bottom: 32px;
	padding-top: 16px;
	padding-bottom: 16px;
}
.nhsuk-global-alert {
	background-color: #ffeb3b;
	padding-bottom: 24px;
	padding-top: 24px;
}
.nhsuk-global-alert__content {
	position: relative;
	margin: 0 16px;
}
.nhsuk-global-alert__content > *:first-child {
	margin-top: 0;
}
.nhsuk-global-alert__heading {
	font-size: 20px;
	font-size: 1.25rem;
	line-height: 1.4;
	margin: 0;
}
@media (min-width: 40.0625em) {
	.nhsuk-global-alert__heading {
		font-size: 24px;
		font-size: 1.5rem;
		line-height: 1.33333;
	}
}
.nhsuk-global-alert__message {
	margin-top: 8px;
	line-height: 1.5;
}
.nhsuk-hero__overlay {
	margin-bottom: 50px;
}
.nhsuk-card .nhsuk-card__description {
	display: flow-root;
}
.nhsuk-panel {
	margin-bottom: 40px;
	margin-top: 40px;
	padding: 24px;
	background-color: #fff;
	color: #212b32;
	width: 100%;
}
@media (min-width: 40.0625em) {
	.nhsuk-panel {
		margin-bottom: 48px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-panel {
		margin-top: 48px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-panel {
		padding: 32px;
	}
}
.nhsuk-panel-with-label {
	margin-bottom: 40px;
	margin-top: 40px;
	padding: 24px;
	background-color: #fff;
	color: #212b32;
	border: 1px solid #d8dde0;
	padding-top: 0 !important;
}
@media (min-width: 40.0625em) {
	.nhsuk-panel-with-label {
		margin-bottom: 48px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-panel-with-label {
		margin-top: 48px;
	}
}
@media (min-width: 40.0625em) {
	.nhsuk-panel-with-label {
		padding: 32px;
	}
}
.nhsuk-panel-with-label__label {
	font-size: 20px;
	font-size: 1.25rem;
	line-height: 1.4;
	background-color: #005eb8;
	color: #fff;
	display: inline-block;
	margin: 0 0 8px -33px;
	padding: 8px 32px;
	position: relative;
	top: -16px;
}
@media (min-width: 40.0625em) {
	.nhsuk-panel-with-label__label {
		font-size: 24px;
		font-size: 1.5rem;
		line-height: 1.33333;
	}
}
@media (max-width: 40.0525em) {
	.nhsuk-panel-with-label__label {
		margin-left: -25px;
		margin-right: 0;
		padding: 8px 24px;
		top: -8px;
	}
}
.nhsuk-panel-group {
	display: flex;
	flex-wrap: wrap;
	margin-bottom: 32px;
}
@media (max-width: 48.0525em) {
	.nhsuk-panel-group {
		margin-bottom: 24px;
	}
}
.nhsuk-panel-with-label {
	width: 100%;
}
#cookie-notice {
	position: fixed;
	min-width: 100%;
	height: auto;
	padding: 16px 0;
	z-index: 100000;
	letter-spacing: 0;
	left: 0;
	text-align: center;
	border-top: 4px solid #003087;
	font-weight: normal;
	padding: 0;
}
