<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nightingale
 * @copyright NHS Leadership Academy, Tony Blacker
 * @version 1.1 21st August 2019
 */

get_header();

flush();

?>

<div id="primary" class=" nhsuk-grid-row">
	<div class="nhsuk-grid-column-two-thirds page <?php echo nightingale_sidebar_location( 'sidebar-1' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>">
		<?php
		while ( have_posts() ) :
			the_post();
			get_template_part( 'template-parts/content', 'page' );
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>
	</div>
	<div class="nhsuk-grid__item nhsuk-grid-column-one-third">
		<?php
		get_sidebar( 'page' );
		?>
	</div>

</div><!-- #primary -->

<?php
flush();
get_footer();
