<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( ! function_exists( 'nigamana_setup' ) ) {
	add_action( 'after_setup_theme', 'nigamana_setup' );
	// Sets up theme defaults and registers support for various WordPress features.
	function nigamana_setup() {
		
		add_editor_style( 'style.css' );
		
	}
}

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'martanda_background_setup' );
function martanda_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ffffff',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Replace default fonts from parent theme
function martanda_get_font_face_styles() {
	return "
	@font-face{
		font-family: 'Inter';
		font-weight: 100;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Thin.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 200;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-ExtraLight.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 300;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Light.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 400;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Regular.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 500;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Medium.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 600;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-SemiBold.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 700;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Bold.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 800;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-ExtraBold.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Inter';
		font-weight: 900;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/Inter-Black.woff2') format('woff2');
	}
	";
}

function martanda_font_family_css() {
	// Get our settings
	$martanda_settings = wp_parse_args(
		get_option( 'martanda_settings', array() ),
		martanda_get_defaults()
	);

	// Initiate our class
	$css = new martanda_css;
	
	$og_defaults = martanda_get_defaults( false );
	
	$bodyclass = 'body';
	if ( is_admin() ) {
		$bodyclass = '.editor-styles-wrapper';
	}
	
	$bodyfont = $martanda_settings[ 'font_body' ];
	if ( $bodyfont == 'inherit' ) { $bodyfont = 'Inter'; }
	
	$font_site_title = $martanda_settings[ 'font_site_title' ];
	if ( $font_site_title == 'inherit' ) { $font_site_title = 'Inter'; }
	$font_navigation = $martanda_settings[ 'font_navigation' ];
	if ( $font_navigation == 'inherit' ) { $font_navigation = 'Inter'; }
	$font_buttons = $martanda_settings[ 'font_buttons' ];
	if ( $font_buttons == 'inherit' ) { $font_buttons = 'Inter'; }
	$font_heading_1 = $martanda_settings[ 'font_heading_1' ];
	if ( $font_heading_1 == 'inherit' ) { $font_heading_1 = 'Inter'; }
	$font_heading_2 = $martanda_settings[ 'font_heading_2' ];
	if ( $font_heading_2 == 'inherit' ) { $font_heading_2 = 'Inter'; }
	$font_heading_3 = $martanda_settings[ 'font_heading_3' ];
	if ( $font_heading_3 == 'inherit' ) { $font_heading_3 = 'Inter'; }
	$font_heading_4 = $martanda_settings[ 'font_heading_4' ];
	if ( $font_heading_4 == 'inherit' ) { $font_heading_4 = 'Inter'; }
	$font_heading_5 = $martanda_settings[ 'font_heading_5' ];
	if ( $font_heading_5 == 'inherit' ) { $font_heading_5 = 'Inter'; }
	$font_heading_6 = $martanda_settings[ 'font_heading_6' ];
	if ( $font_heading_6 == 'inherit' ) { $font_heading_6 = 'Inter'; }
	$font_footer = $martanda_settings[ 'font_footer' ];
	if ( $font_footer == 'inherit' ) { $font_footer = 'Inter'; }
	$font_fixed_side = $martanda_settings[ 'font_fixed_side' ];
	if ( $font_fixed_side == 'inherit' ) { $font_fixed_side = 'Inter'; }
	
	$css->set_selector( $bodyclass );
	$css->add_property( '--martanda--font-body', esc_attr( $bodyfont ) );
	$css->add_property( '--martanda--font-site-title', esc_attr( $font_site_title ) );
	$css->add_property( '--martanda--font-navigation', esc_attr( $font_navigation ) );
	$css->add_property( '--martanda--font-buttons', esc_attr( $font_buttons ) );
	$css->add_property( '--martanda--font-heading-1', esc_attr( $font_heading_1 ) );
	$css->add_property( '--martanda--font-heading-2', esc_attr( $font_heading_2 ) );
	$css->add_property( '--martanda--font-heading-3', esc_attr( $font_heading_3 ) );
	$css->add_property( '--martanda--font-heading-4', esc_attr( $font_heading_4 ) );
	$css->add_property( '--martanda--font-heading-5', esc_attr( $font_heading_5 ) );
	$css->add_property( '--martanda--font-heading-6', esc_attr( $font_heading_6 ) );
	$css->add_property( '--martanda--font-footer', esc_attr( $font_footer ) );
	$css->add_property( '--martanda--font-fixed-side', esc_attr( $font_fixed_side ) );
	
	$css->set_selector( '.editor-styles-wrapper .top-bar-socials button' );
	$css->add_property( 'background-color', 'inherit' );
	
	// Allow us to hook CSS into our output
	do_action( 'martanda_font_family_css', $css );

	return apply_filters( 'martanda_font_family_css_output', $css->css_output() );
}

// Overwrite theme URL
function martanda_theme_uri_link() {
	return 'https://wpkoi.com/nigamana-wpkoi-wordpress-theme/';
}

// Extra cutomizer functions
if ( ! function_exists( 'nigamana_customize_register' ) ) {
	add_action( 'customize_register', 'nigamana_customize_register' );
	function nigamana_customize_register( $wp_customize ) {
				
		// Add Nigamana customizer section
		$wp_customize->add_section(
			'nigamana_layout_effects',
			array(
				'title' => __( 'Mouse effect', 'nigamana' ),
				'priority' => 24,
			)
		);
		
		// Magic mouse
		$wp_customize->add_setting(
			'nigamana_settings[magic_cursor]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'nigamana_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'nigamana_settings[magic_cursor]',
			array(
				'type' => 'select',
				'label' => __( 'Magic mouse', 'nigamana' ),
				'choices' => array(
					'enable' => __( 'Enable', 'nigamana' ),
					'disable' => __( 'Disable', 'nigamana' )
				),
				'settings' => 'nigamana_settings[magic_cursor]',
				'section' => 'nigamana_layout_effects',
				'priority' => 30
			)
		);
		
		// Effect colors
		$wp_customize->add_setting(
			'nigamana_settings[nigamana_color_1]', array(
				'default' => '#000000',
				'type' => 'option',
				'sanitize_callback' => 'nigamana_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'nigamana_settings[nigamana_color_1]',
				array(
					'label' => __( 'Mouse color', 'nigamana' ),
					'section' => 'nigamana_layout_effects',
					'settings' => 'nigamana_settings[nigamana_color_1]',
					'priority' => 35
				)
			)
		);
		
	}
}

//Sanitize choices.
if ( ! function_exists( 'nigamana_sanitize_choices' ) ) {
	function nigamana_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'nigamana_sanitize_hex_color' ) ) {
	function nigamana_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Nigamana effects css
if ( ! function_exists( 'nigamana_effect_css' ) ) {
	function nigamana_effect_css() {
		// Get Customizer settings
		$nigamana_settings = get_option( 'nigamana_settings' );
		
		$nigamana_color_1	 = isset( $nigamana_settings['nigamana_color_1'] ) ? $nigamana_settings['nigamana_color_1'] : '#000000';
		
		$nigamana_effect_css = 'body {--martanda--nigamana-color-1: ' . esc_attr( $nigamana_color_1 ) . ';}';
		
		return $nigamana_effect_css;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'nigamana_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'nigamana_remove_parent_dynamic_css' );
	function nigamana_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'martanda_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'nigamana_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nigamana_enqueue_parent_dynamic_css', 50 );
	function nigamana_enqueue_parent_dynamic_css() {
		$css = martanda_get_font_face_styles() . martanda_font_family_css() . martanda_base_css() . nigamana_effect_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'martanda-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'nigamana_body_classes' ) ) {
	add_filter( 'body_class', 'nigamana_body_classes' );
	function nigamana_body_classes( $classes ) {
		// Get Customizer settings
		$nigamana_settings = get_option( 'nigamana_settings' );
		
		$magic_cursor     = 'enable';
		
		if ( isset( $nigamana_settings['magic_cursor'] ) ) {
			$magic_cursor = $nigamana_settings['magic_cursor'];
		}
		
		// Magic mouse
		if ( $magic_cursor != 'disable' ) {
			$classes[] = 'nigamana-magic-cursor';
		}
		
		return $classes;
	}
}

// Magic mouse
if ( ! function_exists( 'nigamana_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'nigamana_scripts' );
	/**
	 * Enqueue scripts and styles
	 */
	function nigamana_scripts() {

		$dir_uri = get_stylesheet_directory_uri();
		// Get Customizer settings
		$nigamana_settings = get_option( 'nigamana_settings' );
		$magic_cursor  = 'enable';
		if ( isset( $nigamana_settings['magic_cursor'] ) ) {
			$magic_cursor = $nigamana_settings['magic_cursor'];
		}
		
		if ( $magic_cursor != 'disable' ) {
			wp_enqueue_style( 'nigamana-magic-mouse', esc_url( $dir_uri ) . "/css/magic-mouse.min.css", false, '1.0.0', 'all' );
			wp_enqueue_script( 'nigamana-magic-mouse', esc_url( $dir_uri ) . "/js/magic-mouse.min.js", array( 'jquery'), '1.0.0', true );
		}
	}
}